#!/usr/bin/perl -w -I/scs/sbin

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

$0 = "amUpdateNow";

# amUpdateNow - activem monitor program to get most updated status
#             - modified(simplifiled) from UpdateNow.pl from health monitor
#
# Author: Jian Li <jianli@sun.com>
#
# $Id: amUpdateNow.pl,v 1.16 2004/09/29 08:52:02 liwang Exp $

### Modules
use lib "/scs/lib/perl5";
use AM;
use amUpdate;
use Appliance;
use BDConfig;           
use Progress;
use BDUtil;
use BDi18n;             
use Getopt::Std;
use Fcntl qw(O_CREAT O_RDONLY O_WRONLY O_APPEND);


### Global Vars
my $ipaddr = 0;	# ip address of SCS


### Main
{
	my %opt	= ();	# hash of command-line options
	my $jobid= 0;   # unique job id for each config
	my %setup= ();  # config data on a per file basis
	my $statechanged=0;
	my $oneStateChange=0;
	my $ret;

	amUpdate::logger('Starting Active Monitoring updateNow script...');

        $progr = 0;
        if (defined($ARGV[0])) {
        	$progr = 1;
        	amUpdate::logger('started from progress bar...');
        }

        if ($progr) {
            BDi18n::setDomain('base-mgmt-am');
            Progress::initProgress(\@ARGV);
            Progress::setMessage(BDi18n::getMsg('updateActiveMonitor'));
            Progress::setProcessName(BDi18n::getMsg('updateActiveMonitor'));
            Progress::setWorkItems(1);
        }

	my @confs = amUpdate::get_config();

        if ($progr) {
            Progress::setMessage(BDi18n::getMsg('processAMConfig'));
        }
	for (@confs) {
		%setup = parse_config($_);
		# run program specified in config files
		$ret = amUpdate::runConfProg(\%setup);
		# update state info.
		$oneStateChange = amUpdate::updateStateInfo($jobid, $ret, \%setup);
		$statechanged = $statechanged || $oneStateChange;
		$jobid++;
	}

	if (!$statechanged) {
		amUpdate::logger("There is no state change");
                if ($progr) {
	            Progress::advanceProgress();
	            Progress::progressComplete(BDi18n::getMsg('finishedSuccess'));
                }
		exit 0;
	}

        if ($progr) {
            Progress::setMessage(BDi18n::getMsg('processAMEvent'));
        }
	amUpdate::process_am_event();
	amUpdate::updateMailIgnoreFile();
        if ($progr) {
            Progress::setMessage(BDi18n::getMsg('sendEmails'));
        }
	amUpdate::sendEmails();

        if ($progr) {
	     Progress::advanceProgress();
	     Progress::progressComplete(BDi18n::getMsg('finishedSuccess'));
     }

     amUpdate::logger('Shutting down amUpdateNow.pl ...');
     exit 0;
}


### End main


### Subroutines

sub usage
# usage - output usage details to STDERR
# Arguments: none
# Returns:   null
# Callers:   main()
{
print<<HERE
amUpdateNow.pl - script to get latest active monitor data

  options:
     -d - Turn on Debugging
     -h - print out this help text
     -s [string] -- Set alternate state file directory (default: /var/tmp/hmd)
     -c [string] -- Set alternate config file directory (default: /var/tmp/hmd)
HERE
}


sub parse_config
# parse_config - configuration file parser
# Arguments: config file
# Returns:   hash reference to arguments
# Callers:   main()
{
	my $filename = shift;
        my ($config,%vars);

        amUpdate::logger("Parsing $filename");

        sysopen(CONF,$filename,O_RDONLY) or
                die "Failed to open $filename for reading: $!\n";

        while(<CONF>) {
                chomp;
                my $line = $_;
                my ($key, $value);
                if ( /^.+\s+=/ ) {
                        ($key,$value) = split(/=/, $line, 2);
                } else {
                        ($key,$value) = split(/ +/, $line, 2);
                }

                # Trim any extra spaces in key or value
                $key =~ s/\s+$//;
                $value =~ s/^\s+//;

                $vars{$key} = $value;
        }

        close(CONF);

	# Verificaion
	for (qw(version program detail vendor interval name description)) {
		if ( ! exists $vars{$_} ) {
			error("$_ directive missing from $filename");
		}
	}

	# Set optional threshholds to 0 if not present
	( ! exists $vars{yellowalarm} ) ? $vars{yellowalarm} = 0 : 0;
	( ! exists $vars{redalarm} ) ? $vars{redalarm} = 0 : 0;

#	while (my ($key,$value) = each %vars) { debug("$key = $value") }
	
	return %vars;
}

sub print_am_data
{
	my $data = shift;
	print STDOUT "$data\n";
}
