#!/usr/bin/perl -w
# $Id: 080_am_tables.pl,v 1.1 2004/09/20 08:50:38 pp122837 Exp $
# Copyright 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use lib '/scs/lib/perl5';
use strict;
use SCSDB;

#
# Active Monitor Service
#

exit (1) if (SCSDB::mkTable('am_service',
			   'service_id   serial       PRIMARY KEY',
			   'service_name varchar(255) NOT NULL'));

#
# Active Monitor State
#

exit (1) if (SCSDB::mkTable('am_state',
                           'state_id     serial       PRIMARY KEY',
			   'service_id   integer      DEFAULT 1 REFERENCES am_service',
                           'state        integer      NOT NULL',
			   'date_time    timestamp    NOT NULL DEFAULT CURRENT_TIMESTAMP',
			   'vendor       text         NOT NULL',
			   'message      text         NOT NULL',
			   'url          text',
			   'status_url   text         NOT NULL'));

exit (0);
