package AM;

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.


#
# AM.pm : Active Monitor database API
# $Id: AM.pm,v 1.7 2004/12/08 20:39:59 rs131644 Exp $
#
# Functions provided:
# -------------------
#   addAMService
#   addAMState
#   getWorstState
#   getAllStates
#   removeAMInfo
#

use lib "/scs/lib/perl5";
use SCSDB;

#------------------------------------------------------------------------
#                           addAMService
#------------------------------------------------------------------------
#
# In : Active Monitor  Service name
#
# Out : New AM Service ID (positive integer) or error code (negative)
#
sub addAMService
{
  my ($service, $serviceName, $serviceRef, $serviceId);

  $serviceName = shift;

  return SCSDB::errorCode(EPARM, 'Service name is required')
    if (! defined($serviceName));

  $serviceId = &getAMServiceId($serviceName);

  return SCSDB::errorCode(EBDERR, "Invalid service id found for $serviceName")
    if ($serviceId < 0);
 
  return $serviceId if ($serviceId > 0);
 
  return SCSDB::errorCode(EDBERR, 'Error deleting am_service record')
    if (SCSDB::runCommand("delete from am_service where service_name = '$serviceName'"));

  return SCSDB::errorCode(EDBERR, 'Error inserting new am_service record')
    if (SCSDB::runCommand('insert into am_service (service_name)'
                          . " values ('$serviceName')"));

  return SCSDB::getInsertId(am_service, service_id, am_service_service_id_seq);
}
#------------------------------------------------------------------------

#------------------------------------------------------------------------
#                           getAMServiceId
#------------------------------------------------------------------------
#
# In : AM Service name
#
# Out : AM Service ID (positive integer) or error code (negative)
#
sub getAMServiceId {

  my $serviceName = shift;

  return SCSDB::errorCode(EPARM, 'Service name is required')
    if (! defined($serviceName));

  return SCSDB::getResult('select service_id from am_service' 
                         . " where am_service.service_name = '$serviceName'");
}
#------------------------------------------------------------------------

#------------------------------------------------------------------------
#                           getAMServices
#------------------------------------------------------------------------
#
# In : Nothing
#
# Out : Reference to list of AM Service names
#
sub getAMServices
{
  return SCSDB::getResultList('select service_name'
                            . ' from am_service'
                        . ' order by service_id');
}
#------------------------------------------------------------------------

#------------------------------------------------------------------------
#                           addAMState
#------------------------------------------------------------------------
#
# In :
#   Required : AM service name, State
#   Optional : Vendor, Message, URL
#
# Out : New AM State ID (positive integer) or error code (negative)
#
sub addAMState
{
  my ($serviceName, $state, $vendor, $msg, $url, $status_url) = @_;

  return SCSDB::errorCode(EPARM, 'Service name and State are required')
    if (! defined($serviceName) || ! defined($state) || ($state eq ''));
  $vendor  = '' if (! defined($vendor));
  $msg     = '' if (! defined($msg));
  $url     = '' if (! defined($url));
  $status_url     = '' if (! defined($status_url));

  my $serviceId = SCSDB::getResult('select service_id'
                                 . ' from am_service'
                                . " where service_name = '$serviceName'");
  return SCSDB::errorCode(EINVAL, 'No am service ID for service name = ' . $serviceName)
    if (! $serviceId);

  # do we need to update?
  my $stateref = getAllStates();
  if (scalar(@{$stateref}) > 0) {
    foreach my $ref ( @{$stateref} ) {
      if ($ref->{service_name} eq $serviceName) {
        return 0 if ($ref->{state} == $state);
      }
    }
  }

  return SCSDB::errorCode(EDBERR, 'Error deleting am_state record')
    if (SCSDB::runCommand("delete from am_state where service_id = '$serviceId'"));

  return SCSDB::errorCode(EDBERR, 'Error inserting new am_state record')
    if (SCSDB::runCommand('insert into am_state (service_id, state, vendor, message, status_url, url)'
       . " values ('$serviceId', '$state', '$vendor', '$msg', '$status_url', '$url')"));

  return SCSDB::getInsertId(am_state, state_id, am_state_state_id_seq);
}


#------------------------------------------------------------------------

#------------------------------------------------------------------------
#                              getWorstState
#------------------------------------------------------------------------
#
# In : none
#
# Out : Return code, Reference to hash (am_state record)
#
sub getWorstState
{
  #
  # Return the top state
  #
  return (SCSDB::errorCode(OKAY),
          SCSDB::getResultHash('select *'
                             . ' from am_state'
                         . ' order by state desc'
                            . ' limit 1'));
}
#------------------------------------------------------------------------


#------------------------------------------------------------------------
#                          getAllStates
#------------------------------------------------------------------------
#
# In : none
#
# Out : Return code, Reference to list of hash references with keys:
#          service_name, date_time (UNIX timestamp), state,
#          vendor, message, url
#   
#
sub getAllStates
{
  return (SCSDB::errorCode(OKAY),
          SCSDB::getResultHashes('select s.service_name'
                                   . ', h.date_time'
                                   . ', h.state'
                                   . ', h.vendor'
                                   . ', h.message'
                                   . ', h.url'
                                   . ', h.status_url'
                               . ' from am_state as h'
                                   . ', am_service as s'
                              . ' where h.service_id = s.service_id'
                           . ' order by h.date_time'));
}
#------------------------------------------------------------------------


#------------------------------------------------------------------------
#                          removeAMInfo
#------------------------------------------------------------------------
#
# In : none
#
# Out : Return code
#   
# Remove all the am record
#
sub removeAMInfo
{
  my $table = 'am_state';
  return SCSDB::errorCode(EDBERR, 'Error deleting from ' . $table)
    if (SCSDB::runCommand('delete from ' . $table));

  return SCSDB::errorCode(OKAY)
}
#------------------------------------------------------------------------

1;
