#!/usr/bin/perl

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use IO::Socket qw(SOCK_STREAM);
use Fcntl qw(O_CREAT O_WRONLY O_APPEND O_RDONLY);
#use strict;
use lib '/scs/lib/perl5';
use SysCmd;

# cobalt_services.pl - health monitoring script for services on a JDS
#
# $Id: am_services_monitor.pl,v 1.1.6.4 2005/05/03 08:13:39 rs131644 Exp $
#
# Details:
#
# This script is used in conjunction with the health monitoring cron job
# for use with "Big Daddy".  IPC is accomplished by setting the proper exit
# code of this script.  The following exit codes coincide with the following
# states:
# 
# -1 - fatal error
# 0  - none   ( unmonitored/state unavailable )
# 1  - green  ( normal state )
# 2  - yellow ( warning state )
# 3  - red    ( critical state )
# 
# Based up the exit code, the health monitoring cron job will react by sending an event to
# the management station with the information defined in the config file for
# this service.

# 1. check config file. If no, grey; else
# 2. check process. If exist, green; else
# 3. check init file. If no, grey; else red

($#ARGV != 0) ? usage() : 0;
my $service = shift;

my $TIMEOUT = 5;

my $HTTP_CONF_FILE = '/etc/apache/httpd.conf';
$HTTP_CONF_FILE = '/etc/httpd/httpd.conf' if ( ! -f $HTTP_CONF_FILE );
my $HTTP_PROC_NAME = 'httpd';
my $HTTP_PROC_PORT = 80;
my $HTTP_PROTOCOL = 'tcp';

my $SNMP_CONF_FILE= '/etc/init.d/init.snmpdx';
my $SNMP_PROC_NAME = 'snmpdx';
my $SNMP_PROC_PORT = "161/162";
my $SNMP_PROTOCOL = 'udp';

my $DNS_CONF_FILE= '/etc/named.conf';
my $DNS_PROC_NAME = 'named';
my $DNS_PROC_PORT = 153;
my $DNS_PROTOCOL = 'udp';

my $MAIL_CONF_FILE= '/etc/init.d/sendmail';
my $MAIL_PROC_NAME = 'sendmail';
if ( ! -f $MAIL_CONF_FILE ) {
  $MAIL_CONF_FILE = '/etc/init.d/postfix';
  $MAIL_PROC_NAME = 'postfix';
}
my $MAIL_PROC_PORT = 25;
my $MAIL_PROTOCOL = 'tcp';

my $FTP_PROC_PORT = 21;
my $FTP_PROTOCOL = 'tcp';

my $TELNET_PROC_PORT = 23;
my $TELNET_PROTOCOL = 'tcp';

my $SSH_CONF_FILE= '/etc/ssh/sshd_config';
my $SSH_PROC_NAME = 'sshd';
my $SSH_PROC_PORT = 22;
my $SSH_PROTOCOL = 'tcp';

my $PGSQL_PROC_NAME = 'postgres';
my $PGSQL_PROC_PORT = 5432;
my $PGSQL_PROTOCOL = 'tcp';

my $INET_CONF = "/etc/inetd.conf";

my $state;	# state of service

my $conf_file="";
my $proc_name="";
my $proc_port="";
my $protocol="";

my $runLevel = SysCmd::getRunlevel();
my $lsCmd = SysCmd::getCmd('ls');

if ($service eq 'PGSQL')
{
  if (system($lsCmd . ' /etc/rc.d/rc' . $runLevel . '.d/*scs-db* >/dev/null'))
  {
    out(0);
  }
  if (SysCmd::runFullCmd(SysCmd::getCmd('ps') . ' | ' . SysCmd::getCmd('grep') . 'postgres | ' . SysCmd::getCmd('grep') . ' -v grep >/dev/null'))
  {
    out(3);
  }
  out(1);
}
else
{
  $conf_file = eval(join("", "\$", $service, "_CONF_FILE"));
  if (( $conf_file ) && ( ! -e $conf_file )) {
          out(0);
  }
}

if ($service eq 'TELNET' || $service eq 'FTP') {

	if ( -r $INET_CONF) {
	  if (!sysopen(CONF, $INET_CONF, O_RDONLY) ) {
		print STDERR "failed to open $INET_CONF\n";
		out(3);
	  }
	  while(<CONF>) {
		chomp;
		if (( $service eq 'FTP' ) && ($_ =~ /^ftp/)) {
			$proc_name = (split)[6];
			break;
		} elsif (( $service eq 'TELNET' ) && ($_ =~ /^telnet/)) {
			$proc_name = (split)[6];
			break;
		} else {
			next;
		}
	  }

          $proc_port = eval(join("", "\$", $service, "_PROC_PORT"));
          $protocol = eval(join("", "\$", $service, "_PROTOCOL"));
	}
	else {
	  my $cFile = '/etc/xinetd.d/';
	  my $bkpFile = '/etc/xinetd.d/';
	  if ($service eq 'TELNET') {
	    $proc_port = 23;
	    $cFile .= 'telnet';
	  }
	  else {
	    $proc_port = 21;
	    $cFile .= 'gssftp';
            $bkpFile .= 'vsftpd';
	  }
	  $protocol = 'tcp';
	  if (! -r $cFile) {
            $cFile = $bkpFile;
            if ($service eq 'TELNET') {
              out(0);
            }
            elsif (! -r $cFile) {
              out(0);
            }
	  }
	  my $grepCmd = SysCmd::getCmd('grep');
	  my ($outSt, $rc) = SysCmd::runFullCmd("$grepCmd disable $cFile | $grepCmd yes");
	  if (!$rc)
	  {
	    out(0);
	  }
	}

        # the process is tcp process, try connecting to it
        $state = connect_to_process($proc_port);
        if ($state==0) {
                # the connection is open
                out(1);
        } else {
                # the connection is not open, looking for whether it is disabled
		#if (!$proc_name) {
			# not specified in $INET_CONF
                #        out(0);
                #} else {
                        out(3);
                #}
        }
} else {
	# other services
	$proc_name = eval(join("", "\$", $service, "_PROC_NAME"));

	if (!$proc_name) {
		# wrong service
		out(0);
	}

	my $tmp_dir = '/etc/rc.d/rc' . $runLevel . '.d/';
        if (!(match_file($tmp_dir))) {
          $tmp_dir = '/etc/init.d/rc' . $runLevel . '.d/';
          if (!(match_file($tmp_dir))) {
            out(0);
          }
        }

        # check if the process is running
	($state, $rc) = SysCmd::runFullCmd(SysCmd::getCmd('ps') . ' | ' . SysCmd::getCmd('grep') . $proc_name . ' | ' . SysCmd::getCmd('grep') . ' -v grep >/dev/null');
	if ($rc) {
		# process doesn't run
		out(3);
	} else {
                # when it reaches here, the process is running
                $proc_port = eval(join("", "\$", $service, "_PROC_PORT"));
                $protocol = eval(join("", "\$", $service, "_PROTOCOL"));

                # so the process is running, if not a tcp process, that's all we can check
                if ($protocol ne 'tcp') {
                        out(1);
                }

                # the process is tcp process, try connecting to it
                $state = connect_to_process($proc_port);
                if ($state!=0) {
                        out(3);
                } else {
                        out(1);
                }
	}
}

sub out
# exit gracefully
# argumets: exit code
{
	my $ec = shift;

	if ( $ec < 0 ) {
		print STDERR "Fatal Error!\n";
		exit $ec;
	} else {
		exit $ec;
	}
}

sub usage
{
	print STDERR "usage: $0 [HTTP/SNMP/DNS/MAIL/TELNET/FTP/SSH/PGSQL]\n";
	exit -1;
}

sub connect_to_process
# try connecting to a tcp port 
# argument: process port number
# return 0 if successful, return 1 otherwise
{
	my $port = shift;
	return 1 unless (defined $port && $port !=0);

	return 1 unless(validPortP($port));
	
	my $conn = IO::Socket::INET->new(PeerAddr => localhost,
					PeerPort => $port,
					Proto    => 'tcp',
					Type     => SOCK_STREAM,
					Timeout  => $TIMEOUT );
	unless (defined $conn)
	{
		return 1;
	}

	close($conn);
	
	return 0;
}

sub pintP {
    return (defined $_[0] && $_[0] =~ /^[\+]?[0-9]+$/);
}

sub validPortP {
    return (&pintP($_[0]) && ($_[0] >= 1 && $_[0] <= 65000));
}

sub match_file {
    opendir(DIR, shift);
    my @files = grep { /S.*$proc_name.*/ } readdir(DIR);
    closedir(DIR);
    if (defined @files) {
      return 1;
    }
    else {
      return 0;
    }
}
