#!/usr/bin/perl -w

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

# $Id: am_raid_monitor.pl,v 1.1 2004/11/16 22:03:34 rs131644 Exp $
#
# This script returns the state of RAID.
#
# When invoked without any options, the script will return a message
# indicating the RAID status uninterpolated and generalized (if there
# is a failure condition, the message won't specify which drive failed).
#
# separated list:
#   Disabled/No info: 0
#   All good:         1
#   Some Failures:    2
#   All Fail:         3 (should never happen)


use strict;

my $Debug = 0;

my $raid_state = &raid_poll_mdstat();

print STDERR $raid_state if $Debug;
print STDERR "\n\n" if $Debug;

exit $raid_state;


sub raid_poll_mdstat
{
	my($ret, @md);
	my($raid_inactive, $raid_active, $raid_state, $raiddev) = (0, 0, 1, -1);
	my($num_active, $num_inactive, $num_U, $num_F) = (0, 0, 0, 0);
	
	open(RAID, "/proc/mdstat") || return (0);
	while(<RAID>) {

		if ( (!(/raid/)) && (!($raid_active)) ) {
			$raid_inactive = 1;
			last;
		} elsif (!($raid_active)) {
			$raid_active = 1;
		}

		if (/: active/) {
			$num_active = 1;
		}

		if (/inactive/) { 
			$num_inactive = 1;
		}

		if (/\[_|_\]|U_|_U|\(F\)|__/) { 
			$num_F = 1;
		}

		$raiddev = $1 if ((/^md(\d)/) && ($raiddev == -1));

		if (/\(F\)/) { 
			my ($count_tot, $count_fail) = (0, 0);
			$count_tot++ while ($_ =~ /\[\d\]/g);
			$count_fail++ while ($_ =~ /\(F\)/g);
			$num_U = 1 if ($count_fail != $count_tot);
			last;
		}

		if (/\[U|U\]|UU/) { 
			$num_U = 1;
		}

	}
	close(RAID);

	if ( ($raid_inactive) || ($raiddev < 0) || ($num_active == 0) ) {
		return 0;
	}

	if ($num_F == 0) {
		return 1;
	}

	if ( ($num_F > 0) && ($num_U > 0) ) {
		return 2;
	}

	if ( ($num_U == 0) && ($num_F > 0) ) {
		return 3;
	}
}
