#!/usr/bin/perl

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use strict;
use lib '/scs/lib/perl5';
use SysCmd;

# cobalt_mem.pl - health monitoring script for the memory
#
# Author: Jeff Lovell <jeffrey.lovell@sun.com>
# $Id: am_memory_monitor.pl,v 1.1 2004/11/16 22:03:34 rs131644 Exp $
#
# Details:
#
# This script is used in conjunction with the health monitoring daemon (hmd)
# for use with "Big Daddy".  IPC is accomplished by setting the proper exit
# code of this script.  The following exit codes coincide with the following
# states:
# 
# -1 - fatal error
# 0  - n/a    ( unmonitored/state unavailable )
# 1  - green  ( normal state )
# 2  - yellow ( warning state )
# 3  - red    ( critical state )
# 
# Based up the exit code, the hmd will react by sending an event to the
# management station with the information defined in the config file for
# this service.

my $yel_thresh = $ARGV[0] || 50;
my $red_thresh = $ARGV[1] || 75;
my ($ptot,$pfree,$stot,$sfree,$vtot,$vused,$usepcent, $rc, $outStr);

# there seems to be some inconsistency about the format of this
# file.  Let's hope that it's okay.

if (SysCmd::getOS() eq 'Linux')
{
  open(MEM,"/proc/meminfo") or out(-1);

  while (<MEM>)
  {
    if (/^MemTotal:\s+(\d+)/o) {
      $ptot = $1;
    } elsif (/^MemFree:\s+(\d+)/o) {
      $pfree = $1;
    } elsif (/^SwapTotal:\s+(\d+)/o) {
      $stot = $1;
    } elsif (/^SwapFree:\s+(\d+)/o) {
      $sfree = $1; 
    } elsif (/^Buffers:\s+(\d+)/o) {
	# Linux uses whatever excess physical memory isn't actually
	# in use for buffer space.  For our purposes, this shouldn't
	# be counted as memory actually in use, so we count it as
	# free memory.
      $pfree += $1;
    }
  }
  close MEM;
}
else
{
  (my $platform, $rc) = SysCmd::runCmd('uname', '-m');
  out(-1) if ($rc || !$platform);
  ($outStr, $rc) = SysCmd::runFullCmd('/usr/platform/' . $platform . '/sbin/prtdiag | ' . SysCmd::getCmd('grep') . '"Memory size"');
  out(-1) if ($rc || !$outStr);
  ($ptot) = ($outStr =~ /^Memory size: ([0-9]+)/);
  ($outStr, $rc) = SysCmd::runFullCmd(SysCmd::getCmd('vmstat') . '| ' . SysCmd::getCmd('tail') . '-1');
  out(-1) if ($rc || !$outStr);
  my @t = split(/\s+/, $outStr);
  $pfree = int((int($t[5])) / 1024);
}

$vtot = $ptot + $stot;
$vused = $vtot - ($pfree + $sfree);
$usepcent = int(($vused / $vtot) * 1000) / 10;

if ($usepcent >= $red_thresh) {
	out(3);
} elsif ($usepcent >= $yel_thresh ) {
	out(2);
} else {
	out(1);
}
			    
sub out
# exit gracefully
# argumets: exit code
{
	my $ec = shift;

	if ( $ec < 0 ) {
		print STDERR "Fatal Error!\n";
		exit $ec;
	} else {
		exit $ec;
	}
}
