#!/usr/bin/perl

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use IO::Socket qw(SOCK_STREAM);
use Fcntl qw(O_CREAT O_WRONLY O_APPEND O_RDONLY);
#use strict;

# cobalt_web.pl - health monitoring script for http
#
# Author: Jian Li <jianli@sun.com>
# $Id: am_http_monitor.pl,v 1.1 2004/11/16 22:03:34 rs131644 Exp $
#
# return value:
#
# 0  - none   ( unmonitored/state unavailable )
# 1  - green  ( normal state )
# 2  - yellow ( warning state )
# 3  - red    ( critical state )
# 
# Based up the exit code, the health monitoring cron job will react by sending an event to
# the management station with the information defined in the config file for
# this service.

# 1. check config file. If no, grey; else
# 2. check process. If exist, green; else
# 3. check init file. If no, grey; else red
#
my $init_file= '/etc/rc.d/rc3.d/S80init.scs-httpd';
my $TIMEOUT = 5;

my $state;	# state of service

my $proc_name= 'httpd';
my $proc_port= '80';

# check if the process is running
$state = system("/bin/ps -ef | /bin/grep $proc_name | /bin/grep -v grep");	
if ($state!=0) {
	# process doesn't run, looking for reboot startup script
	if (-x $init_file) {
		# but init file exist, error condition, retry
		system("$init_file stop");
		sleep(1);
		system("$init_file start");
		sleep($TIMEOUT);
		exit connect_to_process($proc_port);
	} else {
		# init file doesn't exit anyway
		exit 0;
	}
} else {
	# the process is running, try connecting to it
	exit connect_to_process($proc_port);
}

sub connect_to_process
# try connecting to a tcp port 
# argument: process port number
# return 0 if successful, return 1 otherwise
{
	my $port = shift;
	
	my $conn = IO::Socket::INET->new(PeerAddr => localhost,
					PeerPort => $port,
					Proto    => 'tcp',
					Type     => SOCK_STREAM,
					Timeout  => $TIMEOUT );
	unless (defined $conn) {
		return 3;
	}

	close($conn);
	
	return 1;
}
