#!/usr/bin/perl

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use strict;

# cobalt_disk.pl - health monitoring script for the disk
#
# Author: Jeff Lovell <jeffrey.lovell@sun.com>
# $Id: am_disk_monitor.pl,v 1.1.6.1 2005/02/23 20:10:19 rs131644 Exp $
#
# Details:
#
# This script is used in conjunction with the health monitoring daemon (hmd)
# for use with "Big Daddy".  IPC is accomplished by setting the proper exit
# code of this script.  The following exit codes coincide with the following
# states:
# 
# -1 - fatal error
# 0  - n/a    ( unmonitored/state unavailable )
# 1  - green  ( normal state )
# 2  - yellow ( warning state )
# 3  - red    ( critical state )
# 
# Based up the exit code, the hmd will react by sending an event to the
# management station with the information defined in the config file for
# this service.

my $yel_thresh = $ARGV[0] || 80;
my $red_thresh = $ARGV[1] || 90;
my ($cap,$header,$freespace);

# report ANY filesystem past the thresholds
my @fs = qw(/);

for (@fs) {
	unless ((-e $_) && (open (DF, "/bin/df $_|"))) {
		out(-1);
	}

	$header = <DF>; # toss the header line

	while (<DF>) {
		($cap,$freespace) = (split(/\s+/o))[4,3];
		        chop $cap; # remove the % sign
	}
	close DF;

	if ($cap >= $red_thresh) {
		out(3);
	} elsif ($cap >= $yel_thresh ) {
		out(2);
	}
}
out(1);
			    
sub out
# exit gracefully
# argumets: exit code
{
	my $ec = shift;

	if ( $ec < 0 ) {
		print STDERR "Fatal Error!\n";
		exit $ec;
	} else {
		exit $ec;
	}
}
