#!/usr/bin/perl

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use strict;
use lib '/scs/lib/perl5';
use SysCmd;

# cobalt_cpu.pl - health monitoring script for the CPU
#
# Author: Jeff Lovell <jeffrey.lovell@sun.com>
# $Id: am_cpu_monitor.pl,v 1.1 2004/11/16 22:03:34 rs131644 Exp $
#
# Details:
#
# This script is used in conjunction with the health monitoring daemon (hmd)
# for use with "Big Daddy".  IPC is accomplished by setting the proper exit
# code of this script.  The following exit codes coincide with the following
# states:
# 
# -1 - fatal error
# 0  - n/a    ( unmonitored/state unavailable )
# 1  - green  ( normal state )
# 2  - yellow ( warning state )
# 3  - red    ( critical state )
# 
# Based up the exit code, the hmd will react by sending an event to the
# management station with the information defined in the config file for
# this service.

my $yel_thresh = $ARGV[0] || 3;
my $red_thresh = $ARGV[1] || 6;

my ($uptime, $rc) = SysCmd::runCmd('uptime');
my @t = split(/\s+/, $uptime);
my $fifteen = $t[10];
$fifteen =~ s/,//g;

if ($fifteen >= $red_thresh) {
	out(3);
} elsif ($fifteen >= $yel_thresh ) {
	out(2);
} else {
	out(1);
}
			    
sub out
# exit gracefully
# argumets: exit code
{
	my $ec = shift;

	if ( $ec < 0 ) {
		print STDERR "Fatal Error!\n";
		exit $ec;
	} else {
		exit $ec;
	}
}
