#!/bin/sh
# $Id: getBuild.sh,v 1.16.6.1 2005/02/25 20:41:25 dm123365 Exp $
# getBuild.sh -> determine the "cobalt" style build number for
#                a system. Should work on most unix flavors
# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

# output format should be OS|Release|arch

BUILD=
BUILDARC=
ETCBUILD="/etc/build"
ETCSUNRELEASE="/etc/sun-release"
ETCSUSERELEASE="/etc/SuSE-release"
RPM=/bin/rpm
TMPF="/var/tmp/getbuild.$$.`date +%Y%m%d%H%M%S.$$`"

# if we have /etc/build, parse it to get the build number

if [ -r "$ETCBUILD" ] ; then 
   BUILD="`awk '{ print "ControlStation|"$2 ; }' $ETCBUILD 2>/dev/null`"
fi

# if BUILD is null either we don't have a /etc/build or 
# we couldn't parse it so let's try /etc/sun-release

if [ "X$BUILD" = "X" ] ; then
   if [ -r "$ETCSUNRELEASE" ] ; then
      BUILD="`awk '/^Sun Java Desktop System, Release [0-9]+/ { printf("JDS|%s",$6); exit; }' $ETCSUNRELEASE 2>/dev/null`" 
   fi
fi

# if BUILD is still null, we either don't have a /etc/sun-release or
# we can't parse it, so let's try to look for a JDS /etc/SuSE-release

if [ "X$BUILD" = "X" ] ; then 
   if [ -r "$ETCSUSERELEASE" ] ; then 
      BUILD="`awk '/^Sun Java Desktop System [0-9]+$/ { printf("JDS|%s",$5); exit; }' $ETCSUSERELEASE 2>/dev/null`"
   fi
fi

# if BUILD is still null, this must not be a JDS box so let's
# try using rpm to determine the version

if [ "X$BUILD" = "X" ] ; then
   if [ -x $RPM ] ; then
      if $RPM -q redhat-release > /dev/null 2>&1 ; then 
         RHREL="`$RPM -q redhat-release 2>/dev/null`"
         BUILD="`echo $RHREL | sed -e 's/\-/ /g' | awk '{ print "RedHatLinux|"$3; }'`"
      fi
      if [ "X$BUILD" = "X" ] ; then 
         for i in ws es as 
         do
           if $RPM -q redhat-release-$i > /dev/null 2>&1 ; then
	      RHREL="`$RPM -q redhat-release-$i 2> /dev/null`"
              BUILD="`echo $RHREL | sed -e 's/\-/ /g' | awk '{ print "RedHatLinux|"$4; }'`"
           fi
         done
      fi
      if [ "X$BUILD" = "X" ] ; then
          if $RPM -q fedora-release > /dev/null 2>&1 ; then
             RHREL="`$RPM -q fedora-release 2>/dev/null`"
             BUILD="`echo $RHREL | sed -e 's/\-/ /g' | awk '{ print "FedoraLinux|"$3; }'`"
          fi
      fi
      if [ "X$BUILD" = "X" ] ; then
          if $RPM -q suse-release > /dev/null 2>&1 ; then
             RHREL="`$RPM -q suse-release 2>/dev/null`"
             BUILD="`echo $RHREL | sed -e 's/\-/ /g' | awk '{ print "SuSELinux|"$3; }'`"
          fi
      fi
      if [ "X$BUILD" = "X" ] ; then
          if $RPM -q sles-release > /dev/null 2>&1 ; then
             RHREL="`$RPM -q sles-release 2>/dev/null`"
             BUILD="`echo $RHREL | sed -e 's/\-/ /g' | awk '{ print "SLES|"$3; }'`"
          fi
      fi

   fi
fi

# if BUILD is still null either rpm isn't installed or this 
# isn't a redhat system so let's try something else

if [ "X$BUILD" = "X" ] ; then
    OS=`uname -s`
    RELEASE=`uname -r`
    BUILD="${OS}|${RELEASE}"
fi

# if we just can't figure it out say unknown

if [ "X$BUILD" = "X" ] ; then
   BUILD="Unknown|Unknown"
fi

# Figure out the architecture of the system
BUILDARC=`uname -p`
if [ $BUILDARC = "unknown" ]; then
    BUILDARC=`uname -m`
fi

# when it comes up as athlon it might be an opteron but
# just to be safe we are defaulting it to i386
BUILDARC=`echo $BUILDARC | sed -e 's/i[3-9]86\|athlon/i386/'`

# Append kernel mode approiately for SunOS
if [ "$OS" = "SunOS" ]; then
    KERNEL_MODE=`isainfo -b`
    # Add kernel mode of the sparc platform
    if [ "$BUILDARC" = "sparc" ]; then
        BUILDARC=${BUILDARC}_${KERNEL_MODE}
    fi
    # Add kernel mode for i386 processors if they support 64-bit operation
    if [ "$BUILDARC" = "i386" -a "$KERNEL_MODE" = "64" ]; then
	BUILDARC="x86_64"
    fi
fi

echo "${BUILD}|${BUILDARC}"

exit 0
