#!/usr/bin/perl -w

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
# $Id: runCmd.pl,v 1.4 2004/09/10 18:51:15 ms152511 Exp $

use strict;
use lib '/scs/lib/perl5';
use CLIids;
use Appliance;
use RawAgentInterface;
use Progress;
use BDi18n;

BDi18n::setDomain('base-mgmt-runCmd');
Progress::initProgress(\@ARGV);
Progress::setProcessName(BDi18n::getMsg('runCmd'));

if (defined($ARGV[0]) && ($ARGV[0] eq 'debug'))
{
  shift @ARGV;
  BDUtil::setDebug();
}

if (!defined($ARGV[1]))
{
  print STDERR "Usage: $0 [debug] <\"command with args\"> <hosts>\n";
  CLIids::printUsage();
  exit 0;
}

my $cmd = shift @ARGV;

my $ids = CLIids::getHostIds(\@ARGV);
my ($rc, $ips) = Appliance::getApplianceIPaddressList(@{$ids});
if ($rc || !$ips)
{
  BDUtil::setError('Error getting IP address list');
  Progress::progressFailed(BDi18n::getMsg('troubleGettingIPaddresses'));
  exit 1;
}

Progress::setWorkItems(scalar(@{$ips}));

my ($conn, $outStr, $msg, $htmlMsg);
my $success = 0;
my $total = 0;
foreach my $ip (@{$ips})
{
  ++$total;
  $msg = BDi18n::getMsg('connectingTo', { 'ip' => $ip->{'ip_address'} });
  Progress::setMessage($msg);
  BDUtil::info($msg);
  $conn = RawAgentInterface::ConnStart($ip->{'ip_address'});
  if ($conn <= 0)
  {
    $msg = BDi18n::getMsg('couldNotConnect', { 'ip' => $ip->{'ip_address'} });
    BDUtil::warning($msg);
    Progress::warningEvent($msg);
  }
  else
  {
    ($rc, $outStr) = RawAgentInterface::RunCmd($conn, $cmd);
    if ($rc)
    {
      $msg = BDi18n::getMsg('errorRunningCommand',
                            { 'ip' => $ip->{'ip_address'} }) . ' : ';

      if (!$outStr)
      { 
        $htmlMsg = $msg .= BDi18n::getMsg('noOutput');
      } 
      else
      {
        $htmlMsg = $msg . '<BR><PRE>' . $outStr . '</PRE>';
        $msg     = $msg . "\n"        . $outStr;
      }

      BDUtil::warning($msg);
      Progress::warningEvent($htmlMsg);
    }
    else
    {
      ++$success;
      $msg = BDi18n::getMsg('successfullyRanCommand',
                            { 'ip' => $ip->{'ip_address'} }) . ' : ';
      if (!$outStr)
      {
        $htmlMsg = $msg .= BDi18n::getMsg('noOutput');
      }
      else
      {
        $htmlMsg = $msg . '<BR><PRE>' . $outStr . '</PRE>';
        $msg     = $msg . "\n"        . $outStr;
      }      

      BDUtil::info($msg);
      Progress::infoEvent($htmlMsg);
    }
    RawAgentInterface::ConnEnd($conn);
  }
  Progress::updateProgress($msg);
}

if ($success == 0)
{
  Progress::progressFailed(BDi18n::getMsg('finishedError'));
}
elsif ($success == $total)
{
  Progress::progressComplete(BDi18n::getMsg('finishedSuccess'));
}
else
{
  Progress::progressWarned(BDi18n::getMsg('finishedWarning'));
}
