#!/usr/bin/perl -w

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
# $Id: pushFile.pl,v 1.2 2004/01/26 04:26:10 pp122837 Exp $

use strict;
use lib '/scs/lib/perl5';
use CLIids;
use Appliance;
use RawAgentInterface;
use Progress;
use BDi18n;

BDi18n::setDomain('base-mgmt-pushFile');
Progress::initProgress(\@ARGV);
Progress::setProcessName(BDi18n::getMsg('pushFile'));

if (!defined($ARGV[2]))
{
  print STDERR "Usage: $0 <local file path> <remote file path> <hosts>\n";
  CLIids::printUsage();
  exit 0;
}

my $localFile = shift @ARGV;
if ( ! -r $localFile )
{
  print STDERR "Can't read file $localFile!\n";
  Progress::progressFailed(BDi18n::getMsg('cantReadFile'));
  exit 1;
}

my $remoteFile = shift @ARGV;
if (substr($remoteFile, 0, 1) ne '/')
{
  print STDERR "Remote file path must be fully qualified\n";
  Progress::progressFailed(BDi18n::getMsg('targetPathMustBeFullyQualified'));
  exit 1;
}

my $ids = CLIids::getHostIds(\@ARGV);
my ($rc, $ips) = Appliance::getApplianceIPaddressList(@{$ids});
if ($rc || !$ips)
{
  BDUtil::setError('Error getting IP address list');
  Progress::progressFailed(BDi18n::getMsg('troubleGettingIPaddresses'));
  exit 1;
}

Progress::setWorkItems(scalar(@{$ips}));

my ($conn, $msg);
my $success = 0;
my $total = 0;
foreach my $ip (@{$ips})
{
  ++$total;
  Progress::setMessage(BDi18n::getMsg('connectingTo',
                                      { 'ip' => $ip->{'ip_address'} }));
  $conn = RawAgentInterface::ConnStart($ip->{'ip_address'});
  if ($conn <= 0)
  {
    $msg = BDi18n::getMsg('couldNotConnect', { 'ip' => $ip->{'ip_address'} });
    BDUtil::warning($msg);
    Progress::warningEvent($msg);
  }
  else
  {
    Progress::setMessage(BDi18n::getMsg('pushingFile',
                                        { 'ip' => $ip->{'ip_address'} }));
    if (RawAgentInterface::SendFile($conn, $localFile, $remoteFile) <= -1)
    {
      $msg = BDi18n::getMsg('errorPushingFile', { 'ip' => $ip->{'ip_address'} });
      BDUtil::warning($msg);
      Progress::warningEvent($msg);
    }
    else
    {
      $msg = BDi18n::getMsg('pushedFile', { 'ip' => $ip->{'ip_address'} });
      Progress::infoEvent($msg);
      BDUtil::info($msg);
      ++$success;
    }
    RawAgentInterface::ConnEnd($conn);
  }
  Progress::updateProgress($msg);
}

if ($success == 0)
{
  Progress::progressFailed(BDi18n::getMsg('finishedError'));
}
elsif ($success == $total)
{
  Progress::progressComplete(BDi18n::getMsg('finishedSuccess'));
}
else
{
  Progress::progressWarned(BDi18n::getMsg('finishedWarning'));
}
