#!/usr/bin/perl
#
# hostssh.pl - connect to a managed host over SSH

use strict;
use File::Spec;
use IPC::Open2;
use lib '/scs/lib/perl5';
use Appliance;
use PropertyUtil;
use SCSDB;

my $Ssh_Path         = PropertyUtil::getProperty('cmd.ssh');

my $Version          = '2.2';
my $Default_Username = 'csadmin';
my $Remote_Shell     = '/bin/sh';
my $Identity_Path    = PropertyUtil::getProperty('file.privatekey');
my $Known_Hosts_Path = PropertyUtil::getProperty('file.knownhosts');
my $Default_Port     = 22;

# main

my $target = shift @ARGV;
my $remote_host;
if ($target =~ /\d+/) {
    my $rc;
    ($rc, $remote_host) = Appliance::getApplianceIPaddress($target);
    die SCSDB::getErrorMessage()
        if ($rc);
} else {
    $remote_host = SCSUtil::getIPAddress($target);
}

my $remote_port = $Default_Port;
my $remote_user = $Default_Username;

my @ssh_cmd = ( $Ssh_Path,
                "-i$Identity_Path",
                # Suppress requests for host key approval, etc.
                '-o BatchMode yes',
                "-o GlobalKnownHostsFile $Known_Hosts_Path",
                '-o UserKnownHostsFile ' . File::Spec->devnull(),
                '-q',
                "-p$remote_port",
                "-l$remote_user",
                $remote_host,
                $Remote_Shell );

print STDERR "Executing: \"@ssh_cmd\"\n";

my $ssh_pid = open2( ">&STDOUT",  "<&STDIN", @ssh_cmd );
waitpid( $ssh_pid, 0 );
print STDERR "ssh completed with status $?\n";
