#!/usr/bin/perl -w

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
# $Id: deviceInfo.pl,v 1.6 2004/10/25 22:36:01 ms152511 Exp $

use strict;
use lib '/scs/lib/perl5';
use BDDB;
use CLIids;

sub printUsage
{
  print<<EOD;

Usage : $0 <-l | -m> [options]

Options:
--------
   -l : List the managed hosts and their attributes
   -m : Modify the attribute(s) of a set of hosts, usage:
        -m <Host ID[,..,ID]>> [ -h <new hostname> ]
                               [ -e <new email> ] [ -d <new desc> ] >
EOD

  CLIids::printUsage();
  exit 0;
}

printUsage() if (!defined($ARGV[0]) || (length($ARGV[0]) != 2));

my $mode = shift @ARGV;
$mode = substr($mode, 1, 1);

my %modeHash =
(
  'l' => \&listMode,
  'm' => \&modMode
);

printUsage() if (!exists($modeHash{$mode}));

&{$modeHash{$mode}}();

##
#
##
sub listMode ()
{
    my $aList = BDDB::getResultHashes('select appliance_id, status, ip_address, host_name, email_addr, description from mgmt_appliance');
    
    if (!$aList)
    {
        print "No hosts.\n";
        return;
    }
    
    printf "%4s  %-9s  %-15s  %-30s  %-25s  %s\n", 'id', 'Status', 'IP Address', 'Host Name', 'Email Address', 'Description';
    printf "%4s  %-9s  %-15s  %-30s  %-25s  %s\n", '--', '------', '----------', '---------', '-------------', '-----------';
    
    foreach my $a (@{$aList})
    {
        my $status = $a->{'status'};
        my $status_string = $status eq 'M' ? 'Managed'   :
                            $status eq 'A' ? 'Approved'  :
                            $status eq 'S' ? 'Scanned'   :
                            $status eq 'F' ? 'Mgmt Fail' :
                            'Unknown';

        printf( "%4d  %-9s  %-15s  %-30s  %-25s  %s\n",
                $a->{'appliance_id'},
                $status_string,
                $a->{'ip_address'},
                $a->{'host_name'},
                ( defined($a->{'email_addr'}) ?
                  $a->{'email_addr'} :
                  '(none)' ),
                ( defined($a->{'description'}) ?
                  $a->{'description'} :
                  '(none)' ) );
    }
}

##
#
##
sub modMode ()
{
    printUsage() if ( not defined($ARGV[1]) );
    CLIids::setExitOnError();
    
    my @hostString = split(/,/, shift @ARGV);
    my $aIds = CLIids::getHostIds(\@hostString);
    my ($parm, $val);
    my %parmHash = ( 'h' => 'host_name', 'e' => 'email_addr', 'd' => 'description' );
    my @fields = ();

    while (defined($ARGV[0]))
    {
        $parm = shift @ARGV;
        printUsage() if ( ( length($parm) != 2 )
                          || not exists( $parmHash{substr($parm, 1, 1)} ) );
        $val = shift @ARGV || '';
        push (@fields, $parmHash{substr($parm, 1, 1)} . " = '" . $val . "'");
    }
    
    my $sql = 'update mgmt_appliance set ' . join(',', @fields) . ' where appliance_id in (' . join(',', @{$aIds}) . ')';
    if (BDDB::runCommand($sql))
    {
        print 'ERROR!  ' . BDDB::getDBerrorString() . "\n";
        return;
    }
}
