#!/usr/bin/perl -w
# $Id: AgentInterface.pm,v 1.10 2004/08/06 17:54:30 ms152511 Exp $
# AgentInterface.pm - SCS agent access routines
# Copyright 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms

package AgentInterface;

BEGIN {
    use lib "/scs/lib/perl5";
    use strict;
    use BDUtil;
    use RawAgentInterface;   
    use PropertyUtil;     
}

#
# PingAgent
#
# In : IP Address
#
# Out : Ping output or -1 if fail
#
sub PingAgent {
    my ($ret,$outputStr,$host,@parts,$systype);

    BDUtil::printDebug("Entering PingAgent");

    $systype = "";

    $host = shift;
    unless (defined $host && $host ne "") {
	BDUtil::warning('A hostname must be specified');
	return -1;
    }

    my $conn = RawAgentInterface::ConnStart($host);
    return -1 if (int($conn) <= 0);

    ($ret, $systype) = 
	RawAgentInterface::RunCmd($conn,
                                  "/bin/sh",
                                  "/usr/mgmt/libexec/getBuild.sh");
    BDUtil::printDebug("Return code is $ret");
    $systype = "Unknown" if (int($ret) != 0);
    RawAgentInterface::ConnEnd($conn);	    
    chomp $systype;
    BDUtil::printDebug("Systype is $systype");
    return $systype;
}

#
# SendFile
#
# In : IP Address, Local file
#
# Out : 1 if successful, -1 is failed
#
sub SendFile {
    my ($host, $local_path, $remote_path) = @_;
    BDUtil::printDebug("Entering SendFile");
    
    unless (defined $host && $host ne "") {
	BDUtil::warning("A hostname must be specified");
	return -1;
    }

    unless (defined $local_path && $local_path ne '') {
        BDUtil::warning('A local path must be specified');
        return -1;
    }
    
    my $conn = RawAgentInterface::ConnStart($host);
    if (int($conn) < 0) {
	BDUtil::warning("Cannot establish connection to $host");
	return -1;
    }

    my $ret = RawAgentInterface::SendFile( $conn, $local_path, $remote_path );
    
    RawAgentInterface::ConnEnd($conn);
    
    return $ret;
}

#
# GetFile
#
# In : IP Address, Remote file
#
# Out : 1 if successful, -1 if fail
#
sub GetFile {
    my ($host, $remote_path, $local_path) = @_;
    BDUtil::printDebug("Entering GetFile");

    unless (defined $host && $host ne "") {
	BDUtil::warning("A hostname must be specified");
	return -1;
    }

    unless (defined $remote_path && $remote_path ne '') {
        BDUtil::warning('A remote path must be specified');
        return -1;
    }
    
    my $conn = RawAgentInterface::ConnStart($host);
    if ($conn + 0 < 0) {
	BDUtil::warning("Cannot establish connection to $host");
	return -1;
    }

    my $ret = RawAgentInterface::GetFile( $conn, $remote_path, $local_path );

    RawAgentInterface::ConnEnd($conn);
    
    return $ret;
}

#
# RunCmdToString
#
# In : IP Address, Command to run
#
# Out : Return code (0 for success, nonzero for fail), output string
#
sub RunCmdToString {

    BDUtil::printDebug("Entering RunCmdToString");

    my $host = shift @_;
    unless (defined $host && $host ne "") {
	BDUtil::warning("A hostname must be specified");
	return -1;
    }
    
    my $cmd = shift @_;
    unless (defined $cmd && $cmd ne '') {
        BDUtil::warning('A command must be specified');
        return -1;
    }
    
    my $conn = RawAgentInterface::ConnStart($host);
    if ($conn + 0 < 0) {
	BDUtil::warning("Cannot establish connection to $host");
	return -1;
    }

    my ($ret, $outputStr) = RawAgentInterface::RunCmd( $conn, $cmd, @_ );

    RawAgentInterface::ConnEnd($conn);

    return ($ret, $outputStr);
}

#
# RunCmd
#
# In : IP Address, Command to run
#
# Out : 1 for success, -1 for fail
#
sub RunCmd
{
  my ($rc, $outStr);

  BDUtil::printDebug("Entering RunCmd");

  ($rc, $outStr) = RunCmdToString(@_);
  return -1 if ($rc == -1);

  print $outStr if (defined $outStr);

  return 1;
}

1;
