/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream.socket;

import com.sun.cacao.agent.JmxAgent;
import com.sun.cacao.commandstream.socket.SocketHelper;
import com.sun.cacao.commandstream.socket.SocketUtils;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;

public class TLSSocketHelper
implements SocketHelper {
    private static Logger logger = Logger.getLogger("com.sun.cacao.commandstream.socket");
    private ServerSocketFactory serverSocketFactory = null;

    public synchronized ServerSocket createServerSocket(String string, int n) throws Exception {
        Object object;
        if (this.serverSocketFactory == null) {
            object = JmxAgent.getKeyManagerFactory();
            SSLContext sSLContext = SSLContext.getInstance("TLSv1");
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextInt();
            sSLContext.init(((KeyManagerFactory)object).getKeyManagers(), JmxAgent.getTrustManagers(), secureRandom);
            this.serverSocketFactory = sSLContext.getServerSocketFactory();
        }
        object = null;
        try {
            object = (SSLServerSocket)this.serverSocketFactory.createServerSocket();
            ((ServerSocket)object).setReuseAddress(true);
            SocketUtils.bindServerSocket((ServerSocket)object, string, n);
        }
        catch (Throwable throwable) {
            logger.fine("Advanced configuration of server socket not supported by JVM");
            object = string != null ? (SSLServerSocket)this.serverSocketFactory.createServerSocket(n, 0, InetAddress.getByName(string)) : (SSLServerSocket)this.serverSocketFactory.createServerSocket(n);
        }
        ((SSLServerSocket)object).setEnableSessionCreation(true);
        try {
            ((SSLServerSocket)object).setWantClientAuth(true);
        }
        catch (Throwable throwable) {
            logger.fine("JSSE implementation does not support wantClientAuth");
        }
        ((SSLServerSocket)object).setUseClientMode(false);
        return object;
    }

    public Subject extractSubject(Socket socket) throws Exception {
        SSLSession sSLSession;
        Subject subject = new Subject();
        if (socket != null && socket instanceof SSLSocket && (sSLSession = ((SSLSocket)socket).getSession()) != null) {
            X509Certificate[] x509CertificateArray = null;
            try {
                x509CertificateArray = sSLSession.getPeerCertificateChain();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
            if (x509CertificateArray != null && x509CertificateArray[0] != null) {
                String string = x509CertificateArray[0].getSubjectDN().getName();
                X500Principal x500Principal = new X500Principal(string);
                subject.getPrincipals().add(x500Principal);
            }
        }
        return subject;
    }
}

