/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream.shell;

import com.sun.cacao.commandstream.Command;
import com.sun.cacao.commandstream.CommandInputStream;
import com.sun.cacao.commandstream.CommandOutputMutex;
import com.sun.cacao.commandstream.CommandOutputStream;
import com.sun.cacao.commandstream.CommandStreamUtils;
import com.sun.cacao.commandstream.Registry;
import com.sun.cacao.commandstream.shell.CommandLine;
import com.sun.cacao.commandstream.shell.CommandLineParser;
import com.sun.cacao.commandstream.shell.ExitException;
import com.sun.cacao.commandstream.shell.LastException;
import com.sun.cacao.common.instrum.InstrumConfiguration;
import com.sun.cacao.common.instrum.InstrumForwarderStats;
import com.sun.cacao.common.instrum.InstrumTimes;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class Shell {
    public static final char END_OF_COMMAND_LINE = '\n';
    private static Logger logger = Logger.getLogger("com.sun.cacao.commandstream.shell");
    private Registry cmdReg = null;
    private InstrumForwarderStats stats = null;
    private Logger iLogger = null;
    private String clientKey = null;

    public Shell(MBeanServer mBeanServer, Registry registry, InstrumForwarderStats instrumForwarderStats, String string) {
        this.cmdReg = registry;
        this.clientKey = string;
        this.stats = instrumForwarderStats;
        this.iLogger = Logger.getLogger(InstrumConfiguration.getInstrumLoggerName((String)"Command Stream", (String)"Shell"));
        this.iLogger.setLevel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(InputStream inputStream, OutputStream outputStream) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            Exception exception;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            long l;
            long l2;
            String string;
            block44: {
                Object var25_28;
                Object object;
                bl = bl2;
                CommandInputStream commandInputStream = new CommandInputStream(inputStream);
                CommandOutputMutex commandOutputMutex = new CommandOutputMutex();
                CommandOutputStream commandOutputStream = new CommandOutputStream(outputStream, false, commandOutputMutex);
                CommandOutputStream commandOutputStream2 = new CommandOutputStream(outputStream, true, commandOutputMutex);
                string = null;
                int n = 191;
                l2 = 0L;
                l = 0L;
                boolean bl6 = false;
                bl5 = false;
                bl4 = false;
                bl3 = false;
                exception = null;
                try {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("reading a command line...");
                    }
                    n = 3;
                    try {
                        string = CommandStreamUtils.readEncoded(commandInputStream, '\n');
                    }
                    catch (Exception exception2) {
                        if (!(exception2 instanceof InterruptedIOException)) {
                            if (!exception2.getClass().getName().equals("java.nio.channels.ClosedByInterruptException")) throw exception2;
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("adaptor stopping -> send error & exit shell");
                        }
                        bl = true;
                        throw exception2;
                    }
                    if (string == null) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("input stream closed by client -> exit shell directly");
                        }
                        this.stats.incrNumberOfAbortedOperations();
                        return;
                    }
                    bl6 = true;
                    l2 = InstrumTimes.getNsTime();
                    l = 0L;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("start executing command line[" + string + "]");
                    }
                    n = 2;
                    object = new CommandLineParser(string);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("parse [" + string + "]...");
                    }
                    CommandLine commandLine = ((CommandLineParser)object).parse();
                    bl5 = true;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("find command [" + commandLine.getDomain() + ":" + commandLine.getName() + "]...");
                    }
                    if (this.clientKey != null && this.iLogger.isLoggable(Level.FINEST)) {
                        this.iLogger.log(Level.FINEST, "received : " + commandLine.getDomain() + ":" + commandLine.getName() + "<" + commandLine.getArguments() + "> for <" + this.clientKey + ">");
                    }
                    Command command = this.cmdReg.findCommand(commandLine.getDomain(), commandLine.getName());
                    bl4 = true;
                    hashMap.put("cmddomain", commandLine.getDomain());
                    hashMap.put("cmdname", commandLine.getName());
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("execute [" + commandLine.getDomain() + ":" + commandLine.getName() + "] with arguments [" + commandLine.getArguments() + "]...");
                    }
                    n = 5;
                    n = command.execute(commandLine.getArguments(), commandInputStream, commandOutputStream, commandOutputStream2, hashMap);
                    bl3 = true;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("command line[" + string + "] returns [" + n + "]");
                    }
                }
                catch (LastException lastException) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("last request caught");
                    }
                    bl2 = true;
                    n = 0;
                }
                catch (ExitException exitException) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("exit request caught");
                    }
                    bl = true;
                    n = exitException.getExitCode();
                }
                catch (Exception exception3) {
                    exception = exception3;
                    logger.log(Level.FINE, "Exception thrown while executing [" + string + "]", exception3);
                    try {
                        CommandStreamUtils.writeEncoded(commandOutputStream2, exception3.toString());
                    }
                    catch (Exception exception4) {
                        logger.log(Level.FINE, "no way to send error to client", exception3);
                        n = 3;
                    }
                }
                object = CommandStreamUtils.buildExitSequence(n);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("writing command exit sequence [" + (String)object + "]...");
                }
                try {
                    try {
                        CommandStreamUtils.writeEncoded(outputStream, (String)object);
                        outputStream.flush();
                    }
                    catch (Exception exception5) {
                        logger.log(Level.FINE, "no way to properly terminate the command line", exception5);
                        var25_28 = null;
                        if (this.clientKey == null) return;
                        if (bl) {
                            if (!this.iLogger.isLoggable(Level.FINEST)) return;
                            this.iLogger.log(Level.FINEST, "exit request from client <" + this.clientKey + ">");
                            return;
                        }
                        if (bl2) {
                            if (!this.iLogger.isLoggable(Level.FINEST)) return;
                            this.iLogger.log(Level.FINEST, "last request from client <" + this.clientKey + ">");
                            return;
                        }
                        if (!bl6) {
                            this.stats.incrNumberOfAbortedOperations();
                            if (!this.iLogger.isLoggable(Level.WARNING)) return;
                            this.iLogger.log(Level.WARNING, "no way to read next command line from <" + this.clientKey + ">:" + exception.getMessage());
                            return;
                        }
                        if (!bl5) {
                            this.stats.incrNumberOfAbortedOperations();
                            if (!this.iLogger.isLoggable(Level.WARNING)) return;
                            this.iLogger.log(Level.WARNING, "Exception thrown while initialising [" + string + "] from <" + this.clientKey + ">:" + exception.getMessage());
                            return;
                        }
                        if (!bl4) {
                            this.stats.incrNumberOfAbortedOperations();
                            if (!this.iLogger.isLoggable(Level.FINEST)) return;
                            this.iLogger.log(Level.FINEST, "Unable to resolve command for <" + this.clientKey + ">");
                            return;
                        }
                        if (!bl3) {
                            this.stats.incrNumberOfFailedOperations();
                            if (!this.iLogger.isLoggable(Level.WARNING)) return;
                            this.iLogger.log(Level.WARNING, "Exception thrown while executing [" + string + "] from <" + this.clientKey + ">:" + exception.getMessage());
                            return;
                        }
                        l = InstrumTimes.getNsTime();
                        this.stats.updateTimes(l - l2);
                        this.stats.incrNumberOfOperations();
                        return;
                    }
                    var25_28 = null;
                    if (this.clientKey == null) continue;
                    if (bl) {
                        if (!this.iLogger.isLoggable(Level.FINEST)) continue;
                        this.iLogger.log(Level.FINEST, "exit request from client <" + this.clientKey + ">");
                        continue;
                    }
                    if (bl2) {
                        if (!this.iLogger.isLoggable(Level.FINEST)) continue;
                        this.iLogger.log(Level.FINEST, "last request from client <" + this.clientKey + ">");
                        continue;
                    }
                    if (bl6) break block44;
                }
                catch (Throwable throwable) {
                    var25_28 = null;
                    if (this.clientKey == null) throw throwable;
                    if (bl) {
                        if (!this.iLogger.isLoggable(Level.FINEST)) throw throwable;
                        this.iLogger.log(Level.FINEST, "exit request from client <" + this.clientKey + ">");
                        throw throwable;
                    }
                    if (bl2) {
                        if (!this.iLogger.isLoggable(Level.FINEST)) throw throwable;
                        this.iLogger.log(Level.FINEST, "last request from client <" + this.clientKey + ">");
                        throw throwable;
                    }
                    if (!bl6) {
                        this.stats.incrNumberOfAbortedOperations();
                        if (!this.iLogger.isLoggable(Level.WARNING)) throw throwable;
                        this.iLogger.log(Level.WARNING, "no way to read next command line from <" + this.clientKey + ">:" + exception.getMessage());
                        throw throwable;
                    }
                    if (!bl5) {
                        this.stats.incrNumberOfAbortedOperations();
                        if (!this.iLogger.isLoggable(Level.WARNING)) throw throwable;
                        this.iLogger.log(Level.WARNING, "Exception thrown while initialising [" + string + "] from <" + this.clientKey + ">:" + exception.getMessage());
                        throw throwable;
                    }
                    if (!bl4) {
                        this.stats.incrNumberOfAbortedOperations();
                        if (!this.iLogger.isLoggable(Level.FINEST)) throw throwable;
                        this.iLogger.log(Level.FINEST, "Unable to resolve command for <" + this.clientKey + ">");
                        throw throwable;
                    }
                    if (!bl3) {
                        this.stats.incrNumberOfFailedOperations();
                        if (!this.iLogger.isLoggable(Level.WARNING)) throw throwable;
                        this.iLogger.log(Level.WARNING, "Exception thrown while executing [" + string + "] from <" + this.clientKey + ">:" + exception.getMessage());
                        throw throwable;
                    }
                    l = InstrumTimes.getNsTime();
                    this.stats.updateTimes(l - l2);
                    this.stats.incrNumberOfOperations();
                    throw throwable;
                }
                this.stats.incrNumberOfAbortedOperations();
                if (!this.iLogger.isLoggable(Level.WARNING)) continue;
                this.iLogger.log(Level.WARNING, "no way to read next command line from <" + this.clientKey + ">:" + exception.getMessage());
                continue;
            }
            if (!bl5) {
                this.stats.incrNumberOfAbortedOperations();
                if (!this.iLogger.isLoggable(Level.WARNING)) continue;
                this.iLogger.log(Level.WARNING, "Exception thrown while initialising [" + string + "] from <" + this.clientKey + ">:" + exception.getMessage());
                continue;
            }
            if (!bl4) {
                this.stats.incrNumberOfAbortedOperations();
                if (!this.iLogger.isLoggable(Level.FINEST)) continue;
                this.iLogger.log(Level.FINEST, "Unable to resolve command for <" + this.clientKey + ">");
                continue;
            }
            if (!bl3) {
                this.stats.incrNumberOfFailedOperations();
                if (!this.iLogger.isLoggable(Level.WARNING)) continue;
                this.iLogger.log(Level.WARNING, "Exception thrown while executing [" + string + "] from <" + this.clientKey + ">:" + exception.getMessage());
                continue;
            }
            l = InstrumTimes.getNsTime();
            this.stats.updateTimes(l - l2);
            this.stats.incrNumberOfOperations();
        }
    }
}

