/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream.builtin;

import com.sun.cacao.commandstream.CommandStreamUtils;
import com.sun.cacao.commandstream.builtin.BaseCommand;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SetLocale
extends BaseCommand {
    private static final String LOCALE = "locale";
    public static final String ENV_LOCALE_KEY = "locale";
    private static List validLocales = Arrays.asList(Locale.getISOLanguages());
    private static List validCountries = Arrays.asList(Locale.getISOCountries());

    protected Map parse(String[] stringArray) throws Exception {
        int n;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n != 1) {
            throw new Exception(CommandStreamUtils.getMessage("arguments.total.exact.wrong", "1", "" + n));
        }
        hashMap.put("locale", stringArray[0]);
        return hashMap;
    }

    protected int doExecute(Map map, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, Map map2) throws Exception {
        String string = (String)map.get("locale");
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException(CommandStreamUtils.getMessage("argument.null", "locale"));
        }
        if (string.equals("C") || string.equals("POSIX")) {
            return 0;
        }
        int n = string.indexOf(46);
        int n2 = string.indexOf(95);
        int n3 = string.indexOf(64);
        if (n2 == -1 && n != -1) {
            string = string.substring(0, n) + "__" + string.substring(n + 1);
        } else if (n2 < n) {
            string = string.substring(0, n) + "_" + string.substring(n + 1);
        } else if (n2 == -1 && n == -1 && n3 != -1) {
            string = string.substring(0, n3) + "__" + string.substring(n3 + 1);
        } else if (n == -1 && n2 < n3) {
            string = string.substring(0, n3) + "_" + string.substring(n3 + 1);
        }
        String[] stringArray = this.parseLocale(string);
        Locale locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
        map2.put("locale", locale);
        CommandStreamUtils.setClientLocale(locale);
        return 0;
    }

    private String[] parseLocale(String string) throws IllegalArgumentException {
        String string2;
        String[] stringArray;
        if (string.length() < 2) {
            throw new IllegalArgumentException(CommandStreamUtils.getMessage("locale.size.wrong"));
        }
        int n = string.length();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            if ((i = string.indexOf(95, i)) == -1) {
                arrayList.add(string.substring(n2));
                break;
            }
            arrayList.add(string.substring(n2, i));
        }
        if ((stringArray = arrayList.toArray(new String[0])).length > 3) {
            throw new IllegalArgumentException(CommandStreamUtils.getMessage("locale.parts.wrong"));
        }
        String string3 = stringArray[0];
        String string4 = stringArray.length < 2 ? "" : stringArray[1];
        String string5 = string2 = stringArray.length < 3 ? "" : stringArray[2];
        if (string3.length() == 0 && string4.length() == 0) {
            throw new IllegalArgumentException(CommandStreamUtils.getMessage("locale.lang.country.bothempty"));
        }
        if (string3.length() != 0 && string3.length() != 2) {
            throw new IllegalArgumentException(CommandStreamUtils.getMessage("locale.lang.format.wrong"));
        }
        if (string3.length() != 0 && !validLocales.contains(string3)) {
            throw new IllegalArgumentException(CommandStreamUtils.getMessage("locale.lang.code.unknown", string3));
        }
        if (string4.length() != 0 && string4.length() != 2) {
            throw new IllegalArgumentException(CommandStreamUtils.getMessage("locale.country.format.wrong"));
        }
        if (string4.length() != 0 && !validCountries.contains(string4)) {
            throw new IllegalArgumentException(CommandStreamUtils.getMessage("locale.country.code.unknown", string4));
        }
        return new String[]{string3, string4, string2};
    }
}

