/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream.builtin;

import com.sun.cacao.commandstream.CommandStreamUtils;
import com.sun.cacao.commandstream.builtin.BaseCommand;
import com.sun.cacao.commandstream.builtin.BuiltInUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class Invoke
extends BaseCommand {
    private static final String OBJECT_NAME = "objectName";
    private static final String METHOD = "method";
    private static final String PARAMETERS = "parameters";
    private static final String VOID_TYPE = "void";

    public Invoke(MBeanServer mBeanServer) {
        super(mBeanServer);
    }

    protected Map parse(String[] stringArray) throws Exception {
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n < 2) {
            throw new Exception(CommandStreamUtils.getMessage("arguments.total.min.wrong", "2", "" + n));
        }
        hashMap.put(OBJECT_NAME, stringArray[0]);
        hashMap.put(METHOD, stringArray[1]);
        String[] stringArray2 = new String[n - 2];
        for (int i = 0; i < n - 2; ++i) {
            stringArray2[i] = stringArray[i + 2];
        }
        hashMap.put(PARAMETERS, stringArray2);
        return hashMap;
    }

    protected int doExecute(Map map, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, Map map2) throws Exception {
        int n;
        int n2;
        Object[] objectArray;
        MBeanParameterInfo[] mBeanParameterInfoArray;
        String string = (String)map.get(OBJECT_NAME);
        String string2 = (String)map.get(METHOD);
        String[] stringArray = (String[])map.get(PARAMETERS);
        ObjectName objectName = new ObjectName(string);
        MBeanServer mBeanServer = this.getMBeanServer();
        MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        ClassLoader classLoader = mBeanServer.getClassLoaderFor(objectName);
        ArrayList<MBeanParameterInfo[]> arrayList = new ArrayList<MBeanParameterInfo[]>();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            mBeanParameterInfoArray = mBeanOperationInfoArray[i];
            if (!mBeanParameterInfoArray.getName().equals(string2) || (objectArray = mBeanParameterInfoArray.getSignature()) == null || objectArray.length != stringArray.length) continue;
            n2 = 1;
            for (n = 0; n < objectArray.length; ++n) {
                if (BuiltInUtils.isTypeSupported(((MBeanParameterInfo)objectArray[n]).getType(), classLoader)) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0) continue;
            arrayList.add(mBeanParameterInfoArray);
        }
        if (arrayList.isEmpty()) {
            throw new Exception(CommandStreamUtils.getMessage("invoke.nomethod", string2, string, "" + stringArray.length));
        }
        if (arrayList.size() > 1) {
            throw new Exception(CommandStreamUtils.getMessage("invoke.method.ambiguous", string2, string, "" + stringArray.length));
        }
        MBeanOperationInfo mBeanOperationInfo = (MBeanOperationInfo)arrayList.get(0);
        mBeanParameterInfoArray = mBeanOperationInfo.getSignature();
        objectArray = new String[mBeanParameterInfoArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray[n2] = mBeanParameterInfoArray[n2].getType();
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (n = 0; n < objectArray2.length; ++n) {
            objectArray2[n] = BuiltInUtils.string2object(stringArray[n], (String)objectArray[n], classLoader);
        }
        Object object = mBeanServer.invoke(objectName, string2, objectArray2, (String[])objectArray);
        String string3 = mBeanOperationInfo.getReturnType();
        if (!string3.equals(VOID_TYPE)) {
            CommandStreamUtils.writeEncoded(outputStream, BuiltInUtils.object2string(object));
        }
        return 0;
    }
}

