/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream.builtin;

import com.sun.cacao.commandstream.CommandStreamUtils;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;

public class BuiltInUtils {
    public static final String KEYWORD_MARKER = "#";
    public static final String NULL_VALUE = "#null";
    private static Set supportedTypeSet = new HashSet();

    public static String[] split(String string) throws Exception {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 127);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.quoteChar(34);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.slashStarComments(false);
        streamTokenizer.slashSlashComments(false);
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        block3: while (bl) {
            int n = streamTokenizer.nextToken();
            switch (n) {
                case -1: {
                    bl = false;
                    continue block3;
                }
            }
            arrayList.add(BuiltInUtils.unescape(streamTokenizer.sval));
        }
        return arrayList.toArray(new String[0]);
    }

    public static String object2string(Object object) {
        return BuiltInUtils.escape(object == null ? null : object.toString());
    }

    public static Object string2object(String string, String string2, ClassLoader classLoader) throws Exception {
        if (string == null) {
            return null;
        }
        if (string2.equals(Date.class.getName())) {
            throw new Exception(CommandStreamUtils.getMessage("type.unsupported", string2));
        }
        if (string2.equals(Boolean.TYPE.getName()) || string2.equals(Boolean.class.getName())) {
            return Boolean.valueOf(string);
        }
        if (string2.equals(Byte.TYPE.getName()) || string2.equals(Byte.class.getName())) {
            return Byte.valueOf(string);
        }
        if (string2.equals(Character.TYPE.getName()) || string2.equals(Character.class.getName())) {
            if (string.length() != 1) {
                throw new Exception(CommandStreamUtils.getMessage("character.invalid", string));
            }
            return new Character(string.charAt(0));
        }
        if (string2.equals(Double.TYPE.getName()) || string2.equals(Double.class.getName())) {
            return Double.valueOf(string);
        }
        if (string2.equals(Float.TYPE.getName()) || string2.equals(Float.class.getName())) {
            return Float.valueOf(string);
        }
        if (string2.equals(Integer.TYPE.getName()) || string2.equals(Integer.class.getName())) {
            return Integer.valueOf(string);
        }
        if (string2.equals(Long.TYPE.getName()) || string2.equals(Long.class.getName())) {
            return Long.valueOf(string);
        }
        if (string2.equals(Short.TYPE.getName()) || string2.equals(Short.class.getName())) {
            return Short.valueOf(string);
        }
        if (string2.equals(String.class.getName())) {
            return string;
        }
        if (string2.equals(BigInteger.class.getName())) {
            return new BigInteger(string);
        }
        if (string2.equals(ObjectName.class.getName())) {
            return ObjectName.getInstance(string);
        }
        if (classLoader == null) {
            classLoader = BuiltInUtils.class.getClassLoader();
        }
        Constructor<?> constructor = null;
        try {
            Class<?> clazz = Class.forName(string2, true, classLoader);
            constructor = clazz.getConstructor(String.class);
        }
        catch (Exception exception) {
            throw new Exception(CommandStreamUtils.getMessage("type.unsupported", string2));
        }
        try {
            return constructor.newInstance(string);
        }
        catch (Exception exception) {
            String string3 = null;
            string3 = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            throw new Exception(CommandStreamUtils.getMessage("wrong.value.for.constructor", string, string2, string3));
        }
    }

    public static boolean isTypeSupported(String string, ClassLoader classLoader) {
        if (string == null) {
            return false;
        }
        if (supportedTypeSet.contains(string)) {
            return true;
        }
        if (classLoader == null) {
            classLoader = BuiltInUtils.class.getClassLoader();
        }
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return Modifier.isPublic(constructor.getModifiers());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static String escape(String string) {
        if (string == null) {
            return NULL_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.indexOf(KEYWORD_MARKER, n);
            if (n3 > -1) {
                stringBuffer.append(string.substring(n, n3 + KEYWORD_MARKER.length()));
                stringBuffer.append(KEYWORD_MARKER);
                n = n3 + KEYWORD_MARKER.length();
                continue;
            }
            stringBuffer.append(string.substring(n, n2));
            n = n2;
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        if (string == null || string.equals(NULL_VALUE)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "##";
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.indexOf(string2, n);
            if (n3 > -1) {
                stringBuffer.append(string.substring(n, n3 + KEYWORD_MARKER.length()));
                n = n3 + string2.length();
                continue;
            }
            stringBuffer.append(string.substring(n, n2));
            n = n2;
        }
        return CommandStreamUtils.unescapeJava(stringBuffer.toString());
    }

    static {
        supportedTypeSet.add(Boolean.TYPE.getName());
        supportedTypeSet.add(Boolean.class.getName());
        supportedTypeSet.add(Byte.TYPE.getName());
        supportedTypeSet.add(Byte.class.getName());
        supportedTypeSet.add(Character.TYPE.getName());
        supportedTypeSet.add(Character.class.getName());
        supportedTypeSet.add(Double.TYPE.getName());
        supportedTypeSet.add(Double.class.getName());
        supportedTypeSet.add(Float.TYPE.getName());
        supportedTypeSet.add(Float.class.getName());
        supportedTypeSet.add(Integer.TYPE.getName());
        supportedTypeSet.add(Integer.class.getName());
        supportedTypeSet.add(Long.TYPE.getName());
        supportedTypeSet.add(Long.class.getName());
        supportedTypeSet.add(Short.TYPE.getName());
        supportedTypeSet.add(Short.class.getName());
        supportedTypeSet.add(String.class.getName());
        supportedTypeSet.add(BigInteger.class.getName());
        supportedTypeSet.add(ObjectName.class.getName());
    }
}

