/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream.authentication;

import com.sun.cacao.agent.auth.CacaoCallbackHandler;
import com.sun.cacao.agent.auth.ThreadLocalAuthenticator;
import com.sun.cacao.commandstream.CommandInputStream;
import com.sun.cacao.commandstream.CommandOutputMutex;
import com.sun.cacao.commandstream.CommandOutputStream;
import com.sun.cacao.commandstream.CommandStreamUtils;
import com.sun.cacao.commandstream.authentication.Authenticator;
import com.sun.cacao.commandstream.builtin.BaseCommand;
import com.sun.cacao.commandstream.builtin.SaslPlain;
import com.sun.cacao.commandstream.shell.CommandLine;
import com.sun.cacao.commandstream.shell.CommandLineParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;

public class SaslPlainAuthenticator
implements Authenticator {
    public static final String SASL_DOMAIN = "com.sun.cacao.sasl";
    public static final String PLAIN_NAME = "plain";
    public static final String MECHANISM = "PLAIN";
    private static Logger logger = Logger.getLogger("com.sun.cacao.commandstream.authentication");
    private Subject subject = null;

    public void initialize(Subject subject) {
        this.subject = subject;
    }

    public void dispose() {
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean authenticate(InputStream inputStream, OutputStream outputStream) {
        boolean bl;
        Object object;
        CommandInputStream commandInputStream = new CommandInputStream(inputStream);
        CommandOutputMutex commandOutputMutex = new CommandOutputMutex();
        CommandOutputStream commandOutputStream = new CommandOutputStream(outputStream, false, commandOutputMutex);
        CommandOutputStream commandOutputStream2 = new CommandOutputStream(outputStream, true, commandOutputMutex);
        String string = null;
        int n = 1;
        try {
            SaslServer saslServer = Sasl.createSaslServer(MECHANISM, "command_stream_adaptor", null, null, (CallbackHandler)new CacaoCallbackHandler());
            if (saslServer == null) {
                throw new Exception(CommandStreamUtils.getMessage("sasl.plain.notconfigured"));
            }
            object = new SaslPlain(saslServer);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("reading the authentication command line...");
            }
            if ((string = CommandStreamUtils.readEncoded(commandInputStream, '\n')) == null) {
                throw new Exception("input stream closed by client");
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("authentication using command line [" + string + "]");
            }
            CommandLineParser commandLineParser = new CommandLineParser(string);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("parse [" + string + "]...");
            }
            CommandLine commandLine = commandLineParser.parse();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("find command [" + commandLine.getDomain() + ":" + commandLine.getName() + "]...");
            }
            if (!commandLine.getDomain().equals(SASL_DOMAIN) || !commandLine.getName().equals(PLAIN_NAME)) {
                throw new Exception(CommandStreamUtils.getMessage("sasl.plain.command.unknown"));
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("execute [sasl:plain] with arguments [" + commandLine.getArguments() + "]...");
            }
            int n2 = ((BaseCommand)object).execute(commandLine.getArguments(), commandInputStream, commandOutputStream, commandOutputStream2, new HashMap());
            if (this.subject == null) {
                this.subject = new Subject();
            }
            ThreadLocalAuthenticator threadLocalAuthenticator = new ThreadLocalAuthenticator();
            threadLocalAuthenticator.authenticateSubject(this.subject);
            n = n2;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Exception thrown while authenticating [" + string + "]", exception);
            try {
                CommandStreamUtils.writeEncoded(commandOutputStream2, exception.toString());
            }
            catch (Exception exception2) {
                logger.log(Level.FINE, "no way to send error to client", exception);
            }
        }
        boolean bl2 = bl = n == 0;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("authentication [" + string + "] " + (bl ? "ok" : "ko"));
        }
        object = CommandStreamUtils.buildExitSequence(n);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("writing command exit sequence [" + (String)object + "]...");
        }
        try {
            CommandStreamUtils.writeEncoded(outputStream, (String)object);
            outputStream.flush();
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "no way to properly terminate authentication", exception);
            bl = false;
        }
        return bl;
    }
}

