/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandStreamUtils {
    public static final String MODULE_BUNDLE_BASE_NAME = "com.sun.cacao.commandstream.resources.CommandStream";
    private static Logger logger = Logger.getLogger("com.sun.cacao.commandstream");
    private static Locale defaultLocale = Locale.getDefault();
    private static ThreadLocal clientLocaleContainer = new ThreadLocal();
    private static String defaultEncoding = "UTF-8";
    private static ThreadLocal clientEncodingContainer = new ThreadLocal();

    public static String unescapeJava(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        StringBuffer stringBuffer2 = new StringBuffer(4);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl2) {
                stringBuffer2.append(c);
                if (stringBuffer2.length() != 4) continue;
                try {
                    int n2 = Integer.parseInt(stringBuffer2.toString(), 16);
                    stringBuffer.append((char)n2);
                }
                catch (NumberFormatException numberFormatException) {
                    stringBuffer.append("\\u" + stringBuffer2.toString());
                }
                stringBuffer2.setLength(0);
                bl2 = false;
                bl = false;
                continue;
            }
            if (bl) {
                bl = false;
                switch (c) {
                    case '\\': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case '\'': {
                        stringBuffer.append('\'');
                        break;
                    }
                    case '\"': {
                        stringBuffer.append('\"');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        break;
                    }
                    case 'f': {
                        stringBuffer.append('\f');
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'b': {
                        stringBuffer.append('\b');
                        break;
                    }
                    case 'u': {
                        bl2 = true;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl2) {
            stringBuffer.append("\\u" + stringBuffer2.toString());
            bl = false;
        }
        if (bl) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    public static String buildExitSequence(int n) {
        return "~?" + n + '~' + '!';
    }

    public static String buildEndSequence() {
        return "~#";
    }

    public static void writeEncoded(OutputStream outputStream, String string) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("writing [" + string + "]");
        }
        if (string != null) {
            outputStream.write(string.getBytes(CommandStreamUtils.getClientEncoding()));
        }
    }

    public static String readEncoded(InputStream inputStream, char c) throws Exception {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        int n = 0;
        int n2;
        while ((n2 = inputStream.read()) != -1) {
            if (n2 == c) {
                Byte[] byteArray = arrayList.toArray(new Byte[n]);
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = byteArray[i];
                }
                return new String(byArray, CommandStreamUtils.getClientEncoding());
            }
            ++n;
            arrayList.add(new Byte((byte)n2));
        }
        return null;
    }

    public static Locale getClientLocale() {
        if (clientLocaleContainer.get() == null) {
            return CommandStreamUtils.getDefaultLocale();
        }
        return (Locale)clientLocaleContainer.get();
    }

    public static void setClientLocale(Locale locale) {
        clientLocaleContainer.set(locale);
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static String getClientEncoding() {
        if (clientEncodingContainer.get() == null) {
            return CommandStreamUtils.getDefaultEncoding();
        }
        return (String)clientEncodingContainer.get();
    }

    public static void setClientEncoding(String string) throws UnsupportedEncodingException {
        byte[] byArray = "foo".getBytes(string);
        clientEncodingContainer.set(string);
    }

    public static String getDefaultEncoding() {
        return defaultEncoding;
    }

    public static ResourceBundle getModuleBundle() throws MissingResourceException {
        return ResourceBundle.getBundle(MODULE_BUNDLE_BASE_NAME, CommandStreamUtils.getClientLocale());
    }

    public static String getMessage(String string, String[] stringArray) {
        String string2;
        try {
            string2 = MessageFormat.format(CommandStreamUtils.getMessage(string), stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = "key [" + string + "] does not follow resource properties rules";
        }
        return string2;
    }

    public static String getMessage(String string, String string2) {
        return CommandStreamUtils.getMessage(string, new String[]{string2});
    }

    public static String getMessage(String string, String string2, String string3) {
        return CommandStreamUtils.getMessage(string, new String[]{string2, string3});
    }

    public static String getMessage(String string, String string2, String string3, String string4) {
        return CommandStreamUtils.getMessage(string, new String[]{string2, string3, string4});
    }

    public static String getMessage(String string) {
        String string2;
        try {
            string2 = CommandStreamUtils.getModuleBundle().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "missing message entry for " + string;
        }
        return string2;
    }

    public static void throwInterruptedException() throws IOException {
        IOException iOException;
        try {
            iOException = (IOException)Class.forName("java.nio.channels.ClosedByInterruptException").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            iOException = new InterruptedIOException();
        }
        throw iOException;
    }
}

