/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream;

import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.Module;
import com.sun.cacao.ObjectNameFactory;
import com.sun.cacao.commandstream.Command;
import com.sun.cacao.commandstream.CommandStreamAdaptor;
import com.sun.cacao.commandstream.CommandStreamAdaptorMBean;
import com.sun.cacao.commandstream.CommandStreamUtils;
import com.sun.cacao.commandstream.Registry;
import com.sun.cacao.commandstream.authentication.PublicAccessAuthenticatorFactory;
import com.sun.cacao.commandstream.authentication.SaslPlainAuthenticatorFactory;
import com.sun.cacao.commandstream.builtin.EchoCommand;
import com.sun.cacao.commandstream.builtin.ExitCommand;
import com.sun.cacao.commandstream.builtin.GetAttribute;
import com.sun.cacao.commandstream.builtin.Invoke;
import com.sun.cacao.commandstream.builtin.LastCommand;
import com.sun.cacao.commandstream.builtin.QueryNames;
import com.sun.cacao.commandstream.builtin.SetAttribute;
import com.sun.cacao.commandstream.builtin.SetEncoding;
import com.sun.cacao.commandstream.builtin.SetLocale;
import com.sun.cacao.commandstream.socket.ClearTextSocketHelper;
import com.sun.cacao.commandstream.socket.TLSSocketHelper;
import com.sun.cacao.common.instrum.InstrumConfiguration;
import com.sun.cacao.common.instrum.InstrumForwarderStats;
import com.sun.cacao.container.Container;
import com.sun.cacao.invocation.InvocationException;
import com.sun.cacao.invocation.InvocationStatus;
import com.sun.cacao.invocation.InvokeCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class CommandStreamAdaptorModule
extends Module {
    public static final String PUBLIC_PORT_PARAMETER_KEY = "commandstream.adaptor.public.port";
    public static final String PUBLIC_HOSTNAME_PARAMETER_KEY = "commandstream.adaptor.public.hostname";
    public static final String SECURE_PORT_PARAMETER_KEY = "commandstream.adaptor.secure.port";
    public static final String SECURE_HOSTNAME_PARAMETER_KEY = "commandstream.adaptor.secure.hostname";
    private static Logger logger = Logger.getLogger("com.sun.cacao.commandstream");
    private static Registry cmdReg = null;
    private static Object regLock = new Object();
    private static InstrumForwarderStats csaInsecureStats = null;
    private static InstrumForwarderStats csaSecureStats = null;
    private ObjectName publicAdaptorObjectName = null;
    private CommandStreamAdaptor publicAdaptor = null;
    private ObjectName secureAdaptorObjectName = null;
    private CommandStreamAdaptor secureAdaptor = null;

    public CommandStreamAdaptorModule(DeploymentDescriptor deploymentDescriptor) {
        super(deploymentDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCommand(String string, String string2, Command command) throws Exception {
        Object object = regLock;
        synchronized (object) {
            if (cmdReg == null) {
                cmdReg = new Registry();
            }
            cmdReg.registerCommand(string, string2, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterCommand(String string, String string2) throws Exception {
        Object object = regLock;
        synchronized (object) {
            if (cmdReg == null) {
                cmdReg = new Registry();
            }
            cmdReg.unregisterCommand(string, string2);
        }
    }

    protected void start() throws RuntimeException {
        logger.finer("starting command stream adaptor module...");
        CommandStreamAdaptorModule.logNSSVersionningInfo();
        csaInsecureStats = new InstrumForwarderStats();
        csaSecureStats = new InstrumForwarderStats();
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("populating the registry...");
            }
            CommandStreamAdaptorModule.populateRegistry(this.getMbs());
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("initializing the adaptors...");
            }
            this.initAdaptors();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Exception caught while starting the command-stream adaptor module : " + exception.getMessage(), exception);
            throw new RuntimeException(CommandStreamUtils.getMessage("module.start.failure", exception.getMessage()));
        }
        logger.finer("command stream adaptor module started");
    }

    protected void stop() throws RuntimeException {
        logger.finer("stopping the command stream adaptor module...");
        try {
            if (this.publicAdaptorObjectName != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("stopping the public adaptor...");
                }
                this.publicAdaptor.stop();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("unregistering the public adaptor MBean...");
                }
                this.getMbs().unregisterMBean(this.publicAdaptorObjectName);
                this.publicAdaptorObjectName = null;
            }
            if (this.secureAdaptorObjectName != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("stopping the secure adaptor...");
                }
                this.secureAdaptor.stop();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("unregistering the secure adaptor MBean...");
                }
                this.getMbs().unregisterMBean(this.secureAdaptorObjectName);
                this.secureAdaptorObjectName = null;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("unpopulating the registry...");
            }
            CommandStreamAdaptorModule.unpopulateRegistry();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Exception caught while stopping the command-stream adaptor module : " + exception.getMessage(), exception);
            throw new RuntimeException(CommandStreamUtils.getMessage("module.stop.failure", exception.getMessage()));
        }
        InstrumConfiguration.removeStatReference((String)"secure_command_stream_adaptor");
        csaSecureStats = null;
        InstrumConfiguration.removeStatReference((String)"public_command_stream_adaptor");
        csaInsecureStats = null;
        logger.finer("command stream adaptor module stopped");
    }

    private Registry getRegistry() {
        return cmdReg;
    }

    private static void populateRegistry(MBeanServer mBeanServer) throws Exception {
        CommandStreamAdaptorModule.registerCommand("com.sun.cacao", "echo", new EchoCommand());
        CommandStreamAdaptorModule.registerCommand("com.sun.cacao", "setLocale", new SetLocale());
        CommandStreamAdaptorModule.registerCommand("com.sun.cacao", "setEncoding", new SetEncoding());
        CommandStreamAdaptorModule.registerCommand("com.sun.cacao", "exit", new ExitCommand());
        CommandStreamAdaptorModule.registerCommand("com.sun.cacao", "last", new LastCommand());
        CommandStreamAdaptorModule.registerCommand("com.sun.cacao.jmx", "getAttribute", new GetAttribute(mBeanServer));
        CommandStreamAdaptorModule.registerCommand("com.sun.cacao.jmx", "setAttribute", new SetAttribute(mBeanServer));
        CommandStreamAdaptorModule.registerCommand("com.sun.cacao.jmx", "invoke", new Invoke(mBeanServer));
        CommandStreamAdaptorModule.registerCommand("com.sun.cacao.jmx", "queryNames", new QueryNames(mBeanServer));
    }

    private static void unpopulateRegistry() throws Exception {
        CommandStreamAdaptorModule.unregisterCommand("com.sun.cacao", "echo");
        CommandStreamAdaptorModule.unregisterCommand("com.sun.cacao", "setLocale");
        CommandStreamAdaptorModule.unregisterCommand("com.sun.cacao", "setEncoding");
        CommandStreamAdaptorModule.unregisterCommand("com.sun.cacao", "exit");
        CommandStreamAdaptorModule.unregisterCommand("com.sun.cacao", "last");
        CommandStreamAdaptorModule.unregisterCommand("com.sun.cacao.jmx", "getAttribute");
        CommandStreamAdaptorModule.unregisterCommand("com.sun.cacao.jmx", "setAttribute");
        CommandStreamAdaptorModule.unregisterCommand("com.sun.cacao.jmx", "invoke");
        CommandStreamAdaptorModule.unregisterCommand("com.sun.cacao.jmx", "queryNames");
    }

    private void initAdaptors() throws Exception {
        Map<Object, Object> map = this.getDeploymentDescriptor().getParameters();
        if (map == null) {
            map = new HashMap();
        }
        this.initPublicAdaptor(map);
        this.initSecureAdaptor(map);
    }

    private void initPublicAdaptor(Map map) throws Exception {
        String string = (String)map.get(PUBLIC_HOSTNAME_PARAMETER_KEY);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("reading [" + string + "] as listening hostname (aka network interface)");
        }
        String string2 = (String)map.get(PUBLIC_PORT_PARAMETER_KEY);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("reading [" + string2 + "] as listening port");
        }
        this.publicAdaptor = new CommandStreamAdaptor("public_command_stream_adaptor", this.getMbs(), this.getRegistry(), new ClearTextSocketHelper(), new PublicAccessAuthenticatorFactory(), csaInsecureStats);
        if (string != null && string.length() > 0) {
            this.publicAdaptor.setHostname(string);
        }
        if (string2 != null && string2.length() > 0) {
            int n = Integer.parseInt(string2);
            this.publicAdaptor.setPort(n);
            this.publicAdaptor.start();
            InstrumConfiguration.addStatReference((String)"public_command_stream_adaptor", (Object)csaInsecureStats);
            this.publicAdaptorObjectName = new ObjectNameFactory(this.getDomainName()).getObjectName(CommandStreamAdaptorMBean.class, "public_command_stream_adaptor");
            this.getMbs().registerMBean(this.publicAdaptor, this.publicAdaptorObjectName);
        }
    }

    private void initSecureAdaptor(Map map) throws Exception {
        String string;
        String string2 = (String)map.get(SECURE_HOSTNAME_PARAMETER_KEY);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("reading [" + string2 + "] as listening hostname (aka network interface)");
        }
        if ((string = (String)map.get(SECURE_PORT_PARAMETER_KEY)) == null || string.length() < 1) {
            string = Container.getProperty((String)"com.sun.cacao.commandstream.adaptor.port");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("reading [" + string + "] as listening port");
        }
        this.secureAdaptor = new CommandStreamAdaptor("secure_command_stream_adaptor", this.getMbs(), this.getRegistry(), new TLSSocketHelper(), new SaslPlainAuthenticatorFactory(), csaSecureStats);
        if (string2 != null && string2.length() > 0) {
            this.secureAdaptor.setHostname(string2);
        }
        if (string != null && string.length() > 0) {
            int n = Integer.parseInt(string);
            this.secureAdaptor.setPort(n);
            this.secureAdaptor.start();
            InstrumConfiguration.addStatReference((String)"secure_command_stream_adaptor", (Object)csaSecureStats);
            this.secureAdaptorObjectName = new ObjectNameFactory(this.getDomainName()).getObjectName(CommandStreamAdaptorMBean.class, "secure_command_stream_adaptor");
            this.getMbs().registerMBean(this.secureAdaptor, this.secureAdaptorObjectName);
        }
    }

    private static String formatSolarisVersionStr(String string) {
        int n = string.indexOf(10);
        try {
            return string.substring(0, n) + " vendor " + string.substring(n + 1);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static void logNSSVersionningInfo() {
        String string = System.getProperty("os.name");
        if (string != null) {
            if (string.equalsIgnoreCase("sunos")) {
                String string2 = "/usr/bin/pkgparam";
                String string3 = "SUNW_PRODVERS";
                String string4 = "VENDOR";
                String string5 = "SUNWpr";
                try {
                    InvocationStatus invocationStatus = InvokeCommand.execute((String[])new String[]{string2, string5, string3, string4}, null);
                    logger.info("Netscape Portable Runtime version " + CommandStreamAdaptorModule.formatSolarisVersionStr(invocationStatus.getStdout()));
                    string5 = "SUNWtls";
                    invocationStatus = InvokeCommand.execute((String[])new String[]{string2, string5, string3, string4}, null);
                    logger.info("Network Security Services (NSS) version " + CommandStreamAdaptorModule.formatSolarisVersionStr(invocationStatus.getStdout()));
                }
                catch (Exception exception) {
                    logger.info("No versioning information available for " + string5);
                }
            } else if (string.equalsIgnoreCase("linux")) {
                try {
                    InvocationStatus invocationStatus = InvokeCommand.execute((String[])new String[]{"/bin/rpm", "-q", "sun-nss", "--qf", "%{VERSION} vendor %{VENDOR}"}, null);
                    logger.info("Network Security Services (NSS) version " + invocationStatus.getStdout());
                }
                catch (InvocationException invocationException) {
                    logger.info("No versionning information available for NSS");
                }
            }
        }
    }
}

