/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream;

import com.sun.cacao.commandstream.CommandStreamAdaptorMBean;
import com.sun.cacao.commandstream.CommandStreamUtils;
import com.sun.cacao.commandstream.Registry;
import com.sun.cacao.commandstream.authentication.Authenticator;
import com.sun.cacao.commandstream.authentication.AuthenticatorFactory;
import com.sun.cacao.commandstream.shell.Shell;
import com.sun.cacao.commandstream.socket.SocketHelper;
import com.sun.cacao.common.instrum.InstrumConfiguration;
import com.sun.cacao.common.instrum.InstrumForwarderStats;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.security.auth.Subject;

public class CommandStreamAdaptor
implements CommandStreamAdaptorMBean {
    public static final char START_OF_EXIT_CODE = '?';
    public static final char START_OF_OUTPUT = '>';
    public static final char START_OF_ERROR = '<';
    public static final char END_OF_CONNECTION = '#';
    public static final char END_OF_STREAM = '!';
    public static final char ESCAPE = '~';
    public static final int DEFAULT_PORT = 0;
    public static final String DEFAULT_HOSTNAME = null;
    private static Logger logger = Logger.getLogger("com.sun.cacao.commandstream");
    private ServerRun serverRun = null;
    private Thread serverThread = null;
    private boolean stopRequested = false;
    private String name = null;
    private MBeanServer mbs = null;
    private Registry cmdReg = null;
    private int totalClientCount = 0;
    private SocketHelper socketHelper = null;
    private AuthenticatorFactory authFactory = null;
    private String hostname = DEFAULT_HOSTNAME;
    private int port = 0;
    private Logger iLogger = null;
    private InstrumForwarderStats stats = null;

    public CommandStreamAdaptor(String string, MBeanServer mBeanServer, Registry registry, SocketHelper socketHelper, AuthenticatorFactory authenticatorFactory, InstrumForwarderStats instrumForwarderStats) {
        this.name = string;
        this.mbs = mBeanServer;
        this.cmdReg = registry;
        this.socketHelper = socketHelper;
        this.authFactory = authenticatorFactory;
        this.stats = instrumForwarderStats;
        this.iLogger = Logger.getLogger(InstrumConfiguration.getInstrumLoggerName((String)"Command Stream", (String)"Adaptor"));
        this.iLogger.setLevel(null);
    }

    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public String getName() {
        return this.name;
    }

    public Registry getRegistry() {
        return this.cmdReg;
    }

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public int getTotalClientCount() {
        return this.totalClientCount;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public String execute(String string, String string2) throws Exception {
        String string3 = string + '\n' + (string2 == null ? "" : string2) + "com.sun.cacao:exit" + '\n';
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes("UTF-8"));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Shell shell = new Shell(this.mbs, this.cmdReg, this.stats, null);
        shell.run(byteArrayInputStream, byteArrayOutputStream);
        String string4 = byteArrayOutputStream.toString("UTF-8");
        return string4.substring(0, string4.indexOf("~?"));
    }

    public void start() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.finer("starting a command stream adaptor...");
            logger.finer("using [" + CommandStreamUtils.getDefaultEncoding() + "] as default encoding");
        }
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("creating a server socket...");
            }
            ServerSocket serverSocket = this.socketHelper.createServerSocket(this.hostname, this.port);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("starting the server thread...");
            }
            this.serverRun = new ServerRun(serverSocket);
            this.serverThread = new Thread(this.serverRun);
            this.serverThread.start();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown while starting the command stream adaptor", exception);
            throw exception;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("command stream adaptor started");
        }
    }

    public void stop() throws Exception {
        this.serverRun.stop();
        if (this.serverThread.isAlive()) {
            this.serverThread.interrupt();
        }
        this.serverRun = null;
        this.serverThread = null;
        this.stopRequested = false;
        this.totalClientCount = 0;
    }

    private void addClientConnection(String string) {
        if (string == null) {
            return;
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.finer("Connection opened for <" + string + ">");
        }
        this.stats.connectionAdd(string);
    }

    private void remClientConnection(String string) {
        if (string == null) {
            return;
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.finer("Connection closed for <" + string + ">");
        }
        this.stats.connectionRemove(string);
    }

    private synchronized int incrementTotalClientCount() {
        return ++this.totalClientCount;
    }

    private class ClientRun
    implements Runnable {
        private String clientName = null;
        private Socket socket = null;
        private Authenticator auth = null;
        private Subject subject;
        private InputStream sis = null;
        private OutputStream sos = null;
        private String clientKey = null;

        ClientRun(String string, Socket socket, Authenticator authenticator, Subject subject, String string2) {
            this.clientName = string;
            this.socket = socket;
            this.auth = authenticator;
            this.subject = subject;
            this.clientKey = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block102: {
                Object object2222;
                Throwable throwable;
                boolean bl;
                boolean bl2;
                boolean bl3;
                block96: {
                    block95: {
                        block94: {
                            block93: {
                                block92: {
                                    bl3 = false;
                                    bl2 = false;
                                    bl = false;
                                    throwable = null;
                                    this.socket.setKeepAlive(true);
                                    this.socket.setSoTimeout(1000);
                                    this.sis = new InterruptibleInputStream(this.socket.getInputStream());
                                    this.sos = new BufferedOutputStream(this.socket.getOutputStream());
                                    bl3 = true;
                                    this.auth.initialize(this.subject);
                                    if (this.auth.authenticate(this.sis, this.sos)) {
                                        this.subject = this.auth.getSubject();
                                        bl2 = true;
                                        try {
                                            Subject.doAs(this.subject, new PrivilegedAction(){

                                                public Object run() {
                                                    new Shell(CommandStreamAdaptor.this.mbs, CommandStreamAdaptor.this.cmdReg, CommandStreamAdaptor.this.stats, ClientRun.this.clientKey).run(ClientRun.this.sis, ClientRun.this.sos);
                                                    return null;
                                                }
                                            });
                                            bl = true;
                                        }
                                        catch (Throwable throwable2) {
                                            logger.log(Level.WARNING, "Throwable thrown while running client [" + this.clientName + "]", throwable2);
                                            throwable = throwable2;
                                        }
                                    }
                                    Object var7_8 = null;
                                    if (this.sos == null) break block92;
                                    object2222 = CommandStreamUtils.buildEndSequence();
                                    try {
                                        CommandStreamUtils.writeEncoded(this.sos, (String)object2222);
                                        this.sos.flush();
                                    }
                                    catch (Throwable throwable3) {
                                        if (!logger.isLoggable(Level.FINER)) break block92;
                                        logger.finer("exception thrown while sending the end sequence : " + throwable3.getMessage());
                                    }
                                }
                                if (this.sis != null) {
                                    try {
                                        while (this.sis.read() != -1) {
                                            if (!logger.isLoggable(Level.FINER)) continue;
                                            logger.finer("waiting for client [" + this.clientName + "] to close the connection...");
                                        }
                                    }
                                    catch (Throwable object2222) {
                                        if (!logger.isLoggable(Level.FINER)) break block93;
                                        logger.finer("exception thrown while waiting for the client to close the connection : " + ((Throwable)object2222).getMessage());
                                    }
                                }
                            }
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer("terminating client [" + this.clientName + "]");
                            }
                            this.auth.dispose();
                            if (this.sos != null) {
                                try {
                                    this.sos.close();
                                }
                                catch (Throwable object2222) {
                                    if (!logger.isLoggable(Level.FINER)) break block94;
                                    logger.finer("exception thrown while closing the socket output stream : " + ((Throwable)object2222).getMessage());
                                }
                            }
                        }
                        if (this.sis != null) {
                            try {
                                this.sis.close();
                            }
                            catch (Throwable object2222) {
                                if (!logger.isLoggable(Level.FINER)) break block95;
                                logger.finer("exception thrown while closing the socket input stream : " + ((Throwable)object2222).getMessage());
                            }
                        }
                    }
                    try {
                        this.socket.close();
                    }
                    catch (Throwable object2222) {
                        if (!logger.isLoggable(Level.FINER)) break block96;
                        logger.finer("exception thrown while closing the socket : " + ((Throwable)object2222).getMessage());
                    }
                }
                if (this.clientKey != null) {
                    object2222 = null;
                    if (!bl3) {
                        CommandStreamAdaptor.this.stats.incrFailedConnections(1);
                        object2222 = "Connection initialisation failed for ";
                    } else if (!bl2) {
                        CommandStreamAdaptor.this.stats.incrAuthenticationFailure(1);
                        object2222 = "Connection authentication failed for ";
                    } else if (!bl) {
                        CommandStreamAdaptor.this.stats.incrNumberOfFailedOperations();
                        object2222 = "Request failed for ";
                    }
                    if (object2222 != null && CommandStreamAdaptor.this.iLogger.isLoggable(Level.WARNING)) {
                        CommandStreamAdaptor.this.iLogger.warning((String)object2222 + this.clientKey);
                        if (throwable != null) {
                            CommandStreamAdaptor.this.iLogger.warning("\tFailure details :" + throwable.getMessage());
                        }
                    }
                    CommandStreamAdaptor.this.remClientConnection(this.clientKey);
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("client [" + this.clientName + "] terminated");
                }
                break block102;
                {
                    catch (SocketException socketException) {
                        Object object32222;
                        block101: {
                            block100: {
                                block99: {
                                    block98: {
                                        block97: {
                                            logger.log(Level.WARNING, "Possible unauthenticated access attempt", socketException);
                                            throwable = socketException;
                                            Object var7_9 = null;
                                            if (this.sos != null) {
                                                object32222 = CommandStreamUtils.buildEndSequence();
                                                try {
                                                    CommandStreamUtils.writeEncoded(this.sos, (String)object32222);
                                                    this.sos.flush();
                                                }
                                                catch (Throwable throwable4) {
                                                    if (!logger.isLoggable(Level.FINER)) break block97;
                                                    logger.finer("exception thrown while sending the end sequence : " + throwable4.getMessage());
                                                }
                                            }
                                        }
                                        if (this.sis != null) {
                                            try {
                                                while (this.sis.read() != -1) {
                                                    if (!logger.isLoggable(Level.FINER)) continue;
                                                    logger.finer("waiting for client [" + this.clientName + "] to close the connection...");
                                                }
                                            }
                                            catch (Throwable object32222) {
                                                if (!logger.isLoggable(Level.FINER)) break block98;
                                                logger.finer("exception thrown while waiting for the client to close the connection : " + ((Throwable)object32222).getMessage());
                                            }
                                        }
                                    }
                                    if (logger.isLoggable(Level.FINER)) {
                                        logger.finer("terminating client [" + this.clientName + "]");
                                    }
                                    this.auth.dispose();
                                    if (this.sos != null) {
                                        try {
                                            this.sos.close();
                                        }
                                        catch (Throwable object32222) {
                                            if (!logger.isLoggable(Level.FINER)) break block99;
                                            logger.finer("exception thrown while closing the socket output stream : " + ((Throwable)object32222).getMessage());
                                        }
                                    }
                                }
                                if (this.sis != null) {
                                    try {
                                        this.sis.close();
                                    }
                                    catch (Throwable object32222) {
                                        if (!logger.isLoggable(Level.FINER)) break block100;
                                        logger.finer("exception thrown while closing the socket input stream : " + ((Throwable)object32222).getMessage());
                                    }
                                }
                            }
                            try {
                                this.socket.close();
                            }
                            catch (Throwable object32222) {
                                if (!logger.isLoggable(Level.FINER)) break block101;
                                logger.finer("exception thrown while closing the socket : " + ((Throwable)object32222).getMessage());
                            }
                        }
                        if (this.clientKey != null) {
                            object32222 = null;
                            if (!bl3) {
                                CommandStreamAdaptor.this.stats.incrFailedConnections(1);
                                object32222 = "Connection initialisation failed for ";
                            } else if (!bl2) {
                                CommandStreamAdaptor.this.stats.incrAuthenticationFailure(1);
                                object32222 = "Connection authentication failed for ";
                            } else if (!bl) {
                                CommandStreamAdaptor.this.stats.incrNumberOfFailedOperations();
                                object32222 = "Request failed for ";
                            }
                            if (object32222 != null && CommandStreamAdaptor.this.iLogger.isLoggable(Level.WARNING)) {
                                CommandStreamAdaptor.this.iLogger.warning((String)object32222 + this.clientKey);
                                if (throwable != null) {
                                    CommandStreamAdaptor.this.iLogger.warning("\tFailure details :" + throwable.getMessage());
                                }
                            }
                            CommandStreamAdaptor.this.remClientConnection(this.clientKey);
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("client [" + this.clientName + "] terminated");
                        }
                        break block102;
                    }
                    catch (Exception exception) {
                        Object object42222;
                        block107: {
                            block106: {
                                block105: {
                                    block104: {
                                        block103: {
                                            logger.log(Level.WARNING, "Exception thrown while running client [" + this.clientName + "]", exception);
                                            throwable = exception;
                                            Object var7_10 = null;
                                            if (this.sos != null) {
                                                object42222 = CommandStreamUtils.buildEndSequence();
                                                try {
                                                    CommandStreamUtils.writeEncoded(this.sos, (String)object42222);
                                                    this.sos.flush();
                                                }
                                                catch (Throwable throwable5) {
                                                    if (!logger.isLoggable(Level.FINER)) break block103;
                                                    logger.finer("exception thrown while sending the end sequence : " + throwable5.getMessage());
                                                }
                                            }
                                        }
                                        if (this.sis != null) {
                                            try {
                                                while (this.sis.read() != -1) {
                                                    if (!logger.isLoggable(Level.FINER)) continue;
                                                    logger.finer("waiting for client [" + this.clientName + "] to close the connection...");
                                                }
                                            }
                                            catch (Throwable object42222) {
                                                if (!logger.isLoggable(Level.FINER)) break block104;
                                                logger.finer("exception thrown while waiting for the client to close the connection : " + ((Throwable)object42222).getMessage());
                                            }
                                        }
                                    }
                                    if (logger.isLoggable(Level.FINER)) {
                                        logger.finer("terminating client [" + this.clientName + "]");
                                    }
                                    this.auth.dispose();
                                    if (this.sos != null) {
                                        try {
                                            this.sos.close();
                                        }
                                        catch (Throwable object42222) {
                                            if (!logger.isLoggable(Level.FINER)) break block105;
                                            logger.finer("exception thrown while closing the socket output stream : " + ((Throwable)object42222).getMessage());
                                        }
                                    }
                                }
                                if (this.sis != null) {
                                    try {
                                        this.sis.close();
                                    }
                                    catch (Throwable object42222) {
                                        if (!logger.isLoggable(Level.FINER)) break block106;
                                        logger.finer("exception thrown while closing the socket input stream : " + ((Throwable)object42222).getMessage());
                                    }
                                }
                            }
                            try {
                                this.socket.close();
                            }
                            catch (Throwable object42222) {
                                if (!logger.isLoggable(Level.FINER)) break block107;
                                logger.finer("exception thrown while closing the socket : " + ((Throwable)object42222).getMessage());
                            }
                        }
                        if (this.clientKey != null) {
                            object42222 = null;
                            if (!bl3) {
                                CommandStreamAdaptor.this.stats.incrFailedConnections(1);
                                object42222 = "Connection initialisation failed for ";
                            } else if (!bl2) {
                                CommandStreamAdaptor.this.stats.incrAuthenticationFailure(1);
                                object42222 = "Connection authentication failed for ";
                            } else if (!bl) {
                                CommandStreamAdaptor.this.stats.incrNumberOfFailedOperations();
                                object42222 = "Request failed for ";
                            }
                            if (object42222 != null && CommandStreamAdaptor.this.iLogger.isLoggable(Level.WARNING)) {
                                CommandStreamAdaptor.this.iLogger.warning((String)object42222 + this.clientKey);
                                if (throwable != null) {
                                    CommandStreamAdaptor.this.iLogger.warning("\tFailure details :" + throwable.getMessage());
                                }
                            }
                            CommandStreamAdaptor.this.remClientConnection(this.clientKey);
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("client [" + this.clientName + "] terminated");
                        }
                    }
                }
                catch (Throwable throwable6) {
                    Object object52222;
                    block112: {
                        block111: {
                            block110: {
                                block109: {
                                    block108: {
                                        Object var7_11 = null;
                                        if (this.sos != null) {
                                            object52222 = CommandStreamUtils.buildEndSequence();
                                            try {
                                                CommandStreamUtils.writeEncoded(this.sos, (String)object52222);
                                                this.sos.flush();
                                            }
                                            catch (Throwable throwable7) {
                                                if (!logger.isLoggable(Level.FINER)) break block108;
                                                logger.finer("exception thrown while sending the end sequence : " + throwable7.getMessage());
                                            }
                                        }
                                    }
                                    if (this.sis != null) {
                                        try {
                                            while (this.sis.read() != -1) {
                                                if (!logger.isLoggable(Level.FINER)) continue;
                                                logger.finer("waiting for client [" + this.clientName + "] to close the connection...");
                                            }
                                        }
                                        catch (Throwable object52222) {
                                            if (!logger.isLoggable(Level.FINER)) break block109;
                                            logger.finer("exception thrown while waiting for the client to close the connection : " + ((Throwable)object52222).getMessage());
                                        }
                                    }
                                }
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.finer("terminating client [" + this.clientName + "]");
                                }
                                this.auth.dispose();
                                if (this.sos != null) {
                                    try {
                                        this.sos.close();
                                    }
                                    catch (Throwable object52222) {
                                        if (!logger.isLoggable(Level.FINER)) break block110;
                                        logger.finer("exception thrown while closing the socket output stream : " + ((Throwable)object52222).getMessage());
                                    }
                                }
                            }
                            if (this.sis != null) {
                                try {
                                    this.sis.close();
                                }
                                catch (Throwable object52222) {
                                    if (!logger.isLoggable(Level.FINER)) break block111;
                                    logger.finer("exception thrown while closing the socket input stream : " + ((Throwable)object52222).getMessage());
                                }
                            }
                        }
                        try {
                            this.socket.close();
                        }
                        catch (Throwable object52222) {
                            if (!logger.isLoggable(Level.FINER)) break block112;
                            logger.finer("exception thrown while closing the socket : " + ((Throwable)object52222).getMessage());
                        }
                    }
                    if (this.clientKey != null) {
                        object52222 = null;
                        if (!bl3) {
                            CommandStreamAdaptor.this.stats.incrFailedConnections(1);
                            object52222 = "Connection initialisation failed for ";
                        } else if (!bl2) {
                            CommandStreamAdaptor.this.stats.incrAuthenticationFailure(1);
                            object52222 = "Connection authentication failed for ";
                        } else if (!bl) {
                            CommandStreamAdaptor.this.stats.incrNumberOfFailedOperations();
                            object52222 = "Request failed for ";
                        }
                        if (object52222 != null && CommandStreamAdaptor.this.iLogger.isLoggable(Level.WARNING)) {
                            CommandStreamAdaptor.this.iLogger.warning((String)object52222 + this.clientKey);
                            if (throwable != null) {
                                CommandStreamAdaptor.this.iLogger.warning("\tFailure details :" + throwable.getMessage());
                            }
                        }
                        CommandStreamAdaptor.this.remClientConnection(this.clientKey);
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("client [" + this.clientName + "] terminated");
                    }
                    throw throwable6;
                }
            }
        }

        private class InterruptibleInputStream
        extends InputStream {
            private InputStream in = null;

            InterruptibleInputStream(InputStream inputStream) {
                this.in = inputStream;
            }

            public int read() throws IOException {
                while (true) {
                    if (CommandStreamAdaptor.this.isStopRequested()) {
                        CommandStreamUtils.throwInterruptedException();
                    }
                    try {
                        int n = this.in.read();
                        return n;
                    }
                    catch (IOException iOException) {
                        if (iOException instanceof InterruptedIOException || iOException.getClass().getName().equals("java.net.SocketTimeoutException")) continue;
                        throw iOException;
                    }
                    break;
                }
            }

            public int available() throws IOException {
                if (CommandStreamAdaptor.this.isStopRequested()) {
                    CommandStreamUtils.throwInterruptedException();
                }
                return this.in.available();
            }

            public void close() throws IOException {
                this.in.close();
            }

            public synchronized void mark(int n) {
                this.in.mark(n);
            }

            public boolean markSupported() {
                return this.in.markSupported();
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                while (true) {
                    if (CommandStreamAdaptor.this.isStopRequested()) {
                        CommandStreamUtils.throwInterruptedException();
                    }
                    try {
                        return this.in.read(byArray, n, n2);
                    }
                    catch (IOException iOException) {
                        if (iOException instanceof InterruptedIOException || iOException.getClass().getName().equals("java.net.SocketTimeoutException")) continue;
                        throw iOException;
                    }
                    break;
                }
            }

            public int read(byte[] byArray) throws IOException {
                while (true) {
                    if (CommandStreamAdaptor.this.isStopRequested()) {
                        CommandStreamUtils.throwInterruptedException();
                    }
                    try {
                        return this.in.read(byArray);
                    }
                    catch (IOException iOException) {
                        if (iOException instanceof InterruptedIOException || iOException.getClass().getName().equals("java.net.SocketTimeoutException")) continue;
                        throw iOException;
                    }
                    break;
                }
            }

            public synchronized void reset() throws IOException {
                if (CommandStreamAdaptor.this.isStopRequested()) {
                    CommandStreamUtils.throwInterruptedException();
                }
                this.in.reset();
            }

            public long skip(long l) throws IOException {
                if (CommandStreamAdaptor.this.isStopRequested()) {
                    CommandStreamUtils.throwInterruptedException();
                }
                return this.in.skip(l);
            }

            protected Object clone() throws CloneNotSupportedException {
                Object object = super.clone();
                ((InterruptibleInputStream)object).in = this.in;
                return object;
            }

            public boolean equals(Object object) {
                if (object instanceof InterruptibleInputStream) {
                    return this.in.equals(((InterruptibleInputStream)object).in);
                }
                return false;
            }

            public int hashCode() {
                return this.in.hashCode();
            }

            public String toString() {
                return this.in.toString();
            }
        }
    }

    private class ServerRun
    implements Runnable {
        private ServerSocket serverSocket = null;
        ThreadGroup clientThreads = null;

        ServerRun(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
            this.clientThreads = new ThreadGroup(CommandStreamAdaptor.this.getName());
        }

        public void run() {
            try {
                while (true) {
                    Socket socket = null;
                    try {
                        socket = this.serverSocket.accept();
                    }
                    catch (SocketException socketException) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("socket closed...");
                        }
                        break;
                    }
                    String string = null;
                    if (InstrumConfiguration.isInstrumActivated()) {
                        string = socket.getInetAddress().getHostAddress();
                        string = string + (58 + socket.getPort());
                        CommandStreamAdaptor.this.addClientConnection(string);
                    }
                    Subject subject = CommandStreamAdaptor.this.socketHelper.extractSubject(socket);
                    String string2 = CommandStreamAdaptor.this.getName() + CommandStreamAdaptor.this.incrementTotalClientCount();
                    Thread thread = new Thread(this.clientThreads, new ClientRun(string2, socket, CommandStreamAdaptor.this.authFactory.createAuthenticator(), subject, string));
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("starting the new client thread [" + string2 + "]...");
                    }
                    thread.start();
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Unexpected throwable while running server thread", throwable);
            }
        }

        public void stop() {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Throwable caught while closing server socket", throwable);
            }
            CommandStreamAdaptor.this.stopRequested = true;
            int n = 0;
            while (this.clientThreads.activeCount() > 0 && n++ < 10) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            if (this.clientThreads.activeCount() > 0) {
                this.clientThreads.interrupt();
            }
        }
    }
}

