/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream;

import com.sun.cacao.commandstream.CommandInputStream;
import com.sun.cacao.commandstream.CommandOutputMutex;
import java.io.IOException;
import java.io.OutputStream;

public class CommandOutputStream
extends OutputStream {
    protected OutputStream out = null;
    private CommandOutputMutex lock = null;
    private boolean usedForError = false;

    public CommandOutputStream(OutputStream outputStream, boolean bl, CommandOutputMutex commandOutputMutex) {
        this.out = outputStream;
        this.usedForError = bl;
        this.lock = commandOutputMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        boolean bl = this.lock.acquire(this.usedForError);
        if (bl != this.usedForError) {
            this.out.write(126);
            this.out.write(this.usedForError ? 60 : 62);
        }
        try {
            if (n == 126) {
                this.out.write(n);
            }
            this.out.write(n);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        this.lock.acquire();
        try {
            this.out.flush();
        }
        finally {
            this.lock.release();
        }
    }

    public int hashCode() {
        return this.out.hashCode();
    }

    protected Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        ((CommandOutputStream)object).out = this.out;
        return object;
    }

    public boolean equals(Object object) {
        if (object instanceof CommandInputStream) {
            return this.out.equals(((CommandOutputStream)object).out);
        }
        return false;
    }

    public String toString() {
        return this.out.toString();
    }
}

