/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.commandstream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class CommandInputStream
extends InputStream {
    private InputStream in = null;
    private boolean isClosed = false;

    public CommandInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int read() throws IOException {
        if (this.isClosed) {
            return -1;
        }
        int n = this.in.read();
        if (n == 126) {
            int n2 = this.in.read();
            if (n2 == 33) {
                this.isClosed = true;
                return -1;
            }
            return n2;
        }
        return n;
    }

    public int available() throws IOException {
        if (this.isClosed) {
            return 0;
        }
        return this.in.available();
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public synchronized void mark(int n) {
        this.in.mark(n);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public synchronized void reset() throws IOException {
        this.isClosed = false;
    }

    public long skip(long l) throws IOException {
        if (this.isClosed) {
            throw new EOFException();
        }
        return this.in.skip(l);
    }

    public int hashCode() {
        return this.in.hashCode();
    }

    protected Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        ((CommandInputStream)object).in = this.in;
        ((CommandInputStream)object).isClosed = this.isClosed;
        return object;
    }

    public boolean equals(Object object) {
        if (object instanceof CommandInputStream) {
            return this.in.equals(((CommandInputStream)object).in) && this.isClosed == ((CommandInputStream)object).isClosed;
        }
        return false;
    }

    public String toString() {
        return this.in.toString();
    }
}

