/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.logging;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class SyslogHandler
extends Handler {
    private LogManager manager = LogManager.getLogManager();
    private boolean open = true;
    private static final int LEVEL_OFF = Level.OFF.intValue();
    private static final int LEVEL_SEVERE = Level.SEVERE.intValue();
    private static final int LEVEL_WARNING = Level.WARNING.intValue();
    private static final int LEVEL_CONFIG = Level.CONFIG.intValue();
    protected static final int SYSLOG_DEBUG = 7;
    protected static final int SYSLOG_INFO = 6;
    protected static final int SYSLOG_NOTICE = 5;
    protected static final int SYSLOG_WARNING = 4;
    protected static final int SYSLOG_ERR = 3;
    protected static final int SYSLOG_CRIT = 2;
    protected static final int SYSLOG_ALERT = 1;
    protected static final int SYSLOG_EMERG = 0;

    private static native void doSyslog(String var0, String var1, int var2);

    public void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        int n = 0;
        int n2 = logRecord.getLevel().intValue();
        n = n2 == LEVEL_OFF ? 7 : (n2 >= LEVEL_SEVERE ? 2 : (n2 >= LEVEL_WARNING ? 4 : (n2 >= LEVEL_CONFIG ? 6 : 7)));
        String string2 = null;
        ResourceBundle resourceBundle = null;
        resourceBundle = logRecord.getResourceBundle();
        Object[] objectArray = logRecord.getParameters();
        string2 = string = logRecord.getMessage();
        if (resourceBundle != null) {
            try {
                string2 = MessageFormat.format(resourceBundle.getString(string), objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string2 = logRecord.getSourceClassName() + "." + logRecord.getSourceMethodName() + " : " + string2;
        SyslogHandler.doSyslog(string2, "cacao", n);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        this.open = false;
    }

    public boolean isLoggable(LogRecord logRecord) {
        if (!this.open) {
            return false;
        }
        return super.isLoggable(logRecord);
    }
}

