/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.logging;

import com.sun.cacao.common.instrum.InstrumLoggingFileFormater;
import com.sun.cacao.container.Container;
import com.sun.cacao.logging.SyslogHandler;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;

public class LoggingInit {
    private static Logger logger;
    private static Logger instrumLogger;
    private static Properties containerProperties;
    private static final String LOGGER_PROPERTIES = "logger.properties";
    private static final String LOG_DIRECTORY = "log.dir";
    private static final String LOG_FILE_PATTERN = "log.file.pattern";
    private static final String LOG_FILE_LIMIT = "log.file.limit";
    private static final String LOG_FILE_COUNT = "log.file.count";
    private static final String LOG_FILE_APPEND = "log.file.append";
    private static final String LOG_FILE_XML = "log.file.xml";
    private static final String LOG_FILE_LEVEL = "log.file.level";
    private static final String LOG_SYSLOG_LEVEL = "log.syslog.level";

    public LoggingInit() {
        LoggingInit.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        logger = Logger.getLogger("com.sun.cacao.logging");
        try {
            LogManager logManager = LogManager.getLogManager();
            logManager.reset();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(LoggingInit.getProperty(LOGGER_PROPERTIES));
                logManager.readConfiguration(fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            int n = Integer.valueOf(LoggingInit.getProperty(LOG_FILE_LIMIT));
            int n2 = Integer.valueOf(LoggingInit.getProperty(LOG_FILE_COUNT));
            boolean bl = Boolean.valueOf(LoggingInit.getProperty(LOG_FILE_APPEND));
            boolean bl2 = Boolean.valueOf(LoggingInit.getProperty(LOG_FILE_XML));
            String string = LoggingInit.getProperty(LOG_DIRECTORY) + File.separator + LoggingInit.getProperty(LOG_FILE_PATTERN);
            FileHandler fileHandler = new FileHandler(string, n, n2, bl);
            if (!bl2) {
                fileHandler.setFormatter(new SimpleFormatter());
            }
            try {
                Level level = Level.parse(LoggingInit.getProperty(LOG_FILE_LEVEL));
                fileHandler.setLevel(level);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.log(Level.SEVERE, "Unable to parse property:log.file.level", illegalArgumentException);
                System.out.println("Illegal argument ");
            }
            catch (NullPointerException nullPointerException) {
                logger.fine("Missing property : log.file.level");
            }
            Logger.getLogger("").addHandler(fileHandler);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "caught exception", exception);
        }
    }

    public static final void addSyslogHandler() {
        try {
            SyslogHandler syslogHandler = new SyslogHandler();
            try {
                Level level = Level.parse(LoggingInit.getProperty(LOG_SYSLOG_LEVEL));
                syslogHandler.setLevel(level);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.log(Level.WARNING, "Unable to parse property:log.syslog.level", illegalArgumentException);
            }
            catch (NullPointerException nullPointerException) {
                logger.fine("Missing property : log.syslog.level");
            }
            Logger.getLogger("").addHandler(syslogHandler);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "caught exception", exception);
        }
    }

    public static final void initInstrumLogging() {
        instrumLogger = Logger.getLogger("com.sun.cacao.instrum");
        try {
            int n = Integer.valueOf(LoggingInit.getProperty(LOG_FILE_LIMIT));
            int n2 = Integer.valueOf(LoggingInit.getProperty(LOG_FILE_COUNT));
            boolean bl = Boolean.valueOf(LoggingInit.getProperty(LOG_FILE_APPEND));
            boolean bl2 = Boolean.valueOf(LoggingInit.getProperty(LOG_FILE_XML));
            File file = new File(LoggingInit.getProperty(LOG_DIRECTORY) + File.separator + LoggingInit.getProperty(LOG_FILE_PATTERN));
            String string = file.getParent() + "/instrum-" + file.getName();
            FileHandler fileHandler = new FileHandler(string, n, n2, bl);
            instrumLogger.setUseParentHandlers(false);
            fileHandler.setLevel(Level.ALL);
            if (bl2) {
                fileHandler.setFormatter(new XMLFormatter());
            } else {
                fileHandler.setFormatter(new InstrumLoggingFileFormater());
            }
            instrumLogger.addHandler(fileHandler);
            instrumLogger.setLevel(Level.OFF);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "caught exception", exception);
        }
    }

    private static String getProperty(String string) {
        return Container.getProperty(string);
    }

    static {
        containerProperties = null;
    }
}

