/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.invocation;

import com.sun.cacao.invocation.InvocationException;
import com.sun.cacao.invocation.InvocationStatus;
import com.sun.cacao.invocation.StreamGobbler;
import com.sun.cacao.invocation.UserProcess;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InvokeCommand {
    private static Logger logger = Logger.getLogger("com.sun.cacao.invocation");
    private static Runtime runtime = Runtime.getRuntime();

    public static InvocationStatus[] execute(String[][] stringArray, String[] stringArray2) throws InvocationException {
        InvocationStatus[] invocationStatusArray = new InvocationStatus[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                invocationStatusArray[i] = InvokeCommand.execute(stringArray[i], stringArray2);
                continue;
            }
            catch (InvocationException invocationException) {
                invocationStatusArray[i] = invocationException.getInvocationStatusArray()[0];
                InvocationStatus[] invocationStatusArray2 = new InvocationStatus[i + 1];
                System.arraycopy(invocationStatusArray, 0, invocationStatusArray2, 0, i + 1);
                invocationException.setInvocationStatusArray(invocationStatusArray2);
                throw invocationException;
            }
        }
        return invocationStatusArray;
    }

    public static InvocationStatus execute(String[] stringArray, String[] stringArray2) throws InvocationException {
        return InvokeCommand.execute(stringArray, stringArray2, null);
    }

    public static InvocationStatus execute(String[] stringArray, String[] stringArray2, String string) throws InvocationException {
        InvocationStatus invocationStatus = new InvocationStatus();
        invocationStatus.setStdin(string);
        invocationStatus.setArgv(stringArray);
        invocationStatus.setEnvp(stringArray2);
        UserProcess userProcess = null;
        try {
            userProcess = new UserProcess(stringArray, stringArray2);
        }
        catch (IOException iOException) {
            throw new InvocationException(iOException.toString(), invocationStatus);
        }
        try {
            StreamGobbler streamGobbler = new StreamGobbler(userProcess.getErrorStream());
            StreamGobbler streamGobbler2 = new StreamGobbler(userProcess.getInputStream());
            if (string != null) {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(userProcess.getOutputStream()));
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.flush();
                userProcess.getOutputStream().flush();
                bufferedWriter.close();
            }
            userProcess.getOutputStream().close();
            try {
                userProcess.waitFor();
                streamGobbler.join();
                streamGobbler2.join();
            }
            catch (InterruptedException interruptedException) {
                logger.log(Level.FINE, "Interrupted process", interruptedException);
            }
            invocationStatus.setStdout(streamGobbler2.getResult());
            invocationStatus.setStderr(streamGobbler.getResult());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        invocationStatus.setExitValue(userProcess.exitValue());
        if (userProcess.exitValue() != 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.finer("Command execution returned " + invocationStatus.getExitValue());
            }
            throw new InvocationException("Non-zero exit status", invocationStatus);
        }
        return invocationStatus;
    }

    public static void main(String[] stringArray) {
        try {
            InvocationStatus invocationStatus = InvokeCommand.execute(stringArray, null);
            System.out.println(invocationStatus.toString());
            System.exit(invocationStatus.getExitValue());
        }
        catch (Exception exception) {
            System.err.println("Caught exception " + exception.getMessage());
            exception.printStackTrace();
        }
        System.exit(-1);
    }
}

