/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.element;

import com.sun.cacao.AttributeChangeRequestNotification;
import com.sun.cacao.agent.auth.SecureNotificationBroadcasterSupport;
import com.sun.cacao.common.instrum.InstrumConfiguration;
import com.sun.cacao.element.AdministrativeStateEnum;
import com.sun.cacao.element.AvailabilityStatusEnum;
import com.sun.cacao.element.ElementMBean;
import com.sun.cacao.element.OperationalStateEnum;
import com.sun.cacao.element.UsageStateEnum;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;

public abstract class ElementSupport
extends SecureNotificationBroadcasterSupport
implements ElementMBean {
    private static Logger logger = Logger.getLogger("com.sun.cacao.element");
    private ObjectName myName = null;
    private AdministrativeStateEnum administrativeState;
    private OperationalStateEnum operationalState;
    private UsageStateEnum usageState = UsageStateEnum.IDLE;
    private HashSet availabilityStatusSet = new HashSet();
    private long sequenceNumber = 0L;

    public ObjectName getObjectName() {
        return this.myName;
    }

    protected void setObjectName(ObjectName objectName) {
        this.myName = objectName;
    }

    public ElementSupport(ObjectName objectName) {
        this.administrativeState = AdministrativeStateEnum.LOCKED;
        this.operationalState = OperationalStateEnum.ENABLED;
        this.myName = objectName;
    }

    public synchronized AdministrativeStateEnum getAdministrativeState() {
        return this.administrativeState;
    }

    protected abstract void start() throws RuntimeException;

    protected abstract void stop() throws RuntimeException;

    public void lock() throws Exception {
        this.setAdministrativeState(AdministrativeStateEnum.LOCKED);
    }

    public void unlock() throws Exception {
        this.setAdministrativeState(AdministrativeStateEnum.UNLOCKED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAdministrativeState(AdministrativeStateEnum administrativeStateEnum) throws IllegalArgumentException {
        block26: {
            if (administrativeStateEnum == null) {
                throw new IllegalArgumentException("null value");
            }
            if (InstrumConfiguration.isInstrumActivated()) {
                if (administrativeStateEnum == AdministrativeStateEnum.LOCKED && this.myName != null) {
                    this.sendNotification(new AttributeChangeRequestNotification("com.sun.cacao.AttributeChangeRequest.requested", (Object)this.myName, AdministrativeStateEnum.LOCKED, this.generateSequenceNumber()));
                }
                if (administrativeStateEnum == AdministrativeStateEnum.UNLOCKED && this.myName != null) {
                    this.sendNotification(new AttributeChangeRequestNotification("com.sun.cacao.AttributeChangeRequest.requested", (Object)this.myName, AdministrativeStateEnum.UNLOCKED, this.generateSequenceNumber()));
                }
            }
            if (this.administrativeState != administrativeStateEnum) {
                AttributeChangeNotification attributeChangeNotification;
                AdministrativeStateEnum administrativeStateEnum2 = this.administrativeState;
                try {
                    if (administrativeStateEnum == AdministrativeStateEnum.LOCKED) {
                        this.administrativeState = AdministrativeStateEnum.SHUTTING_DOWN;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Administrative state change to SHUTTING_DOWN : " + this.getObjectName());
                        }
                        if (this.myName != null) {
                            attributeChangeNotification = new AttributeChangeNotification(this.myName, this.generateSequenceNumber(), System.currentTimeMillis(), "Administrative state change", "AdministrativeState", administrativeStateEnum2.getClass().getName(), administrativeStateEnum2, this.administrativeState);
                            this.sendNotification(attributeChangeNotification);
                        }
                    } else {
                        this.administrativeState = administrativeStateEnum;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Administrative state change to " + administrativeStateEnum + " : " + this.getObjectName());
                    }
                    if (administrativeStateEnum == AdministrativeStateEnum.UNLOCKED) {
                        if (this.getOperationalState() != OperationalStateEnum.ENABLED) break block26;
                        try {
                            this.start();
                        }
                        catch (Throwable throwable) {
                            if (this.myName != null && InstrumConfiguration.isInstrumActivated()) {
                                this.sendNotification(new AttributeChangeRequestNotification("com.sun.cacao.AttributeChangeRequest.failed", (Object)this.myName, AdministrativeStateEnum.UNLOCKED, this.generateSequenceNumber()));
                            }
                            logger.log(Level.WARNING, "caught throwable when starting : " + throwable.getMessage(), throwable);
                            try {
                                this.setOperationalState(OperationalStateEnum.DISABLED);
                                break block26;
                            }
                            catch (Throwable throwable2) {
                                logger.log(Level.WARNING, "caught throwable when disabling : " + throwable2.getMessage(), throwable2);
                            }
                        }
                        break block26;
                    }
                    administrativeStateEnum2 = this.administrativeState;
                    if (this.getOperationalState() == OperationalStateEnum.ENABLED) {
                        try {
                            this.stop();
                            this.administrativeState = AdministrativeStateEnum.LOCKED;
                        }
                        catch (Throwable throwable) {
                            if (this.myName != null && InstrumConfiguration.isInstrumActivated()) {
                                this.sendNotification(new AttributeChangeRequestNotification("com.sun.cacao.AttributeChangeRequest.failed", (Object)this.myName, AdministrativeStateEnum.LOCKED, this.generateSequenceNumber()));
                            }
                            logger.log(Level.WARNING, "caught throwable when stopping : " + throwable.getMessage(), throwable);
                            this.administrativeState = AdministrativeStateEnum.LOCKED;
                            administrativeStateEnum = AdministrativeStateEnum.LOCKED;
                            try {
                                this.setOperationalState(OperationalStateEnum.DISABLED);
                                break block26;
                            }
                            catch (Throwable throwable3) {
                                logger.log(Level.WARNING, "caught throwable when disabling : " + throwable3.getMessage(), throwable3);
                            }
                        }
                        break block26;
                    }
                    this.administrativeState = AdministrativeStateEnum.LOCKED;
                }
                finally {
                    if (this.myName != null) {
                        attributeChangeNotification = new AttributeChangeNotification(this.myName, this.generateSequenceNumber(), System.currentTimeMillis(), "Administrative state change", "AdministrativeState", administrativeStateEnum2.getClass().getName(), administrativeStateEnum2, this.administrativeState);
                        this.sendNotification(attributeChangeNotification);
                    }
                }
            }
        }
    }

    public OperationalStateEnum getOperationalState() {
        return this.operationalState;
    }

    protected void setOperationalState(OperationalStateEnum operationalStateEnum) throws IllegalArgumentException {
        if (operationalStateEnum == null) {
            throw new IllegalArgumentException("null value");
        }
        Set set = this.getAvailabilityStatusSet();
        if (set != null && set.size() != 0 && operationalStateEnum == OperationalStateEnum.ENABLED) {
            logger.fine("Cannot change operational state to " + operationalStateEnum + " : for " + this.getObjectName() + " availability status is not empty");
            throw new IllegalArgumentException("cannot set operational state to ENABLE when availability status is not empty");
        }
        if (this.operationalState != operationalStateEnum) {
            OperationalStateEnum operationalStateEnum2 = this.operationalState;
            this.operationalState = operationalStateEnum;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Operational state change to " + operationalStateEnum + " : " + this.getObjectName());
            }
            AttributeChangeNotification attributeChangeNotification = null;
            if (this.myName != null) {
                attributeChangeNotification = new AttributeChangeNotification(this.myName, this.generateSequenceNumber(), System.currentTimeMillis(), "Operational state change", "OperationalState", operationalStateEnum2.getClass().getName(), operationalStateEnum2, operationalStateEnum);
            }
            if (operationalStateEnum == OperationalStateEnum.ENABLED) {
                if (this.getAdministrativeState() == AdministrativeStateEnum.UNLOCKED) {
                    try {
                        this.start();
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.WARNING, "caught throwable when starting : " + throwable.getMessage(), throwable);
                        if (this.myName != null) {
                            this.sendNotification(attributeChangeNotification);
                        }
                        try {
                            this.setOperationalState(OperationalStateEnum.DISABLED);
                        }
                        catch (Throwable throwable2) {
                            logger.log(Level.WARNING, "caught throwable when disabling : " + throwable2.getMessage(), throwable2);
                        }
                        throw new RuntimeException("Problem when starting a module");
                    }
                }
                if (this.myName != null) {
                    this.sendNotification(attributeChangeNotification);
                }
            } else if (operationalStateEnum == OperationalStateEnum.DISABLED) {
                if (this.getAdministrativeState() == AdministrativeStateEnum.UNLOCKED) {
                    try {
                        this.stop();
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.WARNING, " Error in stop() method.", throwable);
                        if (this.myName != null) {
                            this.sendNotification(attributeChangeNotification);
                        }
                        throw new RuntimeException("Problem when stopping a module");
                    }
                }
                if (this.myName != null) {
                    this.sendNotification(attributeChangeNotification);
                }
            }
        }
    }

    public UsageStateEnum getUsageState() {
        return this.usageState;
    }

    public void setUsageState(UsageStateEnum usageStateEnum) {
        UsageStateEnum usageStateEnum2 = this.usageState;
        if (usageStateEnum2 == usageStateEnum) {
            return;
        }
        this.usageState = usageStateEnum;
        if (this.myName != null) {
            AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this.myName, this.generateSequenceNumber(), System.currentTimeMillis(), "Usage state change", "usageState", usageStateEnum2.getClass().getName(), usageStateEnum2, usageStateEnum);
            this.sendNotification(attributeChangeNotification);
        }
        if (usageStateEnum == UsageStateEnum.IDLE && this.getAdministrativeState() == AdministrativeStateEnum.SHUTTING_DOWN) {
            this.setAdministrativeState(AdministrativeStateEnum.LOCKED);
        }
    }

    public boolean availabilityStatusSetContains(AvailabilityStatusEnum availabilityStatusEnum) {
        return this.availabilityStatusSet.contains(availabilityStatusEnum);
    }

    public boolean availabilityStatusSetRemove(AvailabilityStatusEnum availabilityStatusEnum) {
        Set set = (Set)this.availabilityStatusSet.clone();
        boolean bl = this.availabilityStatusSet.remove(availabilityStatusEnum);
        if (bl && this.myName != null) {
            AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this.myName, this.generateSequenceNumber(), System.currentTimeMillis(), "Availability Status Set state change", "AvailabilityStatusSet", set.getClass().getName(), set, this.availabilityStatusSet);
            this.sendNotification(attributeChangeNotification);
        }
        return bl;
    }

    public boolean availabilityStatusSetAdd(AvailabilityStatusEnum availabilityStatusEnum) {
        Set set = (Set)this.availabilityStatusSet.clone();
        boolean bl = this.availabilityStatusSet.add(availabilityStatusEnum);
        if (bl && this.myName != null) {
            AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this.myName, this.generateSequenceNumber(), System.currentTimeMillis(), "Availability Status Set state change", "AvailabilityStatusSet", set.getClass().getName(), set, this.availabilityStatusSet);
            this.sendNotification(attributeChangeNotification);
        }
        return bl;
    }

    public Set getAvailabilityStatusSet() {
        return (Set)this.availabilityStatusSet.clone();
    }

    protected synchronized long generateSequenceNumber() {
        return this.sequenceNumber++;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = null;
        mBeanNotificationInfoArray = new MBeanNotificationInfo[4];
        String[] stringArray = new String[]{"jmx.attribute.change"};
        String[] stringArray2 = new String[]{"com.sun.cacao.Elementlifecycle.lock.start", "com.sun.cacao.Elementlifecycle.lock.failed", "com.sun.cacao.Elementlifecycle.unlock.start", "com.sun.cacao.Elementlifecycle.unlock.failed"};
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(stringArray, "javax.management.AttributeChangeNotification", "Element administrative state change");
        mBeanNotificationInfoArray[1] = new MBeanNotificationInfo(stringArray, "javax.management.AttributeChangeNotification", "Element operational state change");
        mBeanNotificationInfoArray[2] = new MBeanNotificationInfo(stringArray, "javax.management.AttributeChangeNotification", "Element availability state change");
        mBeanNotificationInfoArray[3] = new MBeanNotificationInfo(stringArray2, "com.sun.cacao.ElementLifecycleNotification", "Element lifecycle state change");
        return mBeanNotificationInfoArray;
    }
}

