/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.container;

import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.container.DeploymentDescriptorHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {
    private static Logger logger = Logger.getLogger("com.sun.cacao.container");
    private SAXParserFactory factory = SAXParserFactory.newInstance();
    private String versionNames = null;

    public Parser() throws FactoryConfigurationError {
        this.factory.setValidating(true);
        this.factory.setNamespaceAware(false);
    }

    public Parser(String string) throws FactoryConfigurationError {
        this();
        this.versionNames = string;
    }

    public DeploymentDescriptor getDeploymentDescriptor(InputStream inputStream) throws IllegalArgumentException, SAXException, IOException {
        logger.finer("Create a deployment descriptor from input stream.");
        SAXParser sAXParser = null;
        try {
            sAXParser = this.factory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("ParserConfigurationException: " + parserConfigurationException.getMessage());
        }
        DeploymentDescriptorHandler deploymentDescriptorHandler = new DeploymentDescriptorHandler(this.versionNames);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId("");
        sAXParser.parse(inputSource, (DefaultHandler)deploymentDescriptorHandler);
        DeploymentDescriptor deploymentDescriptor = deploymentDescriptorHandler.getDeploymentDescriptor().getCopy();
        deploymentDescriptorHandler = null;
        return deploymentDescriptor;
    }

    public DeploymentDescriptor getDeploymentDescriptor(String string) throws IllegalArgumentException, SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Create a deployment descriptor from the xml file " + string);
        }
        return this.getDeploymentDescriptor(new FileInputStream(string));
    }
}

