/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.container;

import com.sun.cacao.Dependency;
import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.Enum;
import com.sun.cacao.agent.JmxClient;
import com.sun.cacao.container.Container;
import com.sun.cacao.element.AdministrativeStateEnum;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DeploymentDescriptorHandler
extends DefaultHandler {
    private static final String MODULE_ELEMENT = "module";
    private static final String MODULE_CLASS_ELEMENT = "module-class";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String DEPENDENCIES_ELEMENT = "module-dependencies";
    private static final String DEPENDENCY_ELEMENT = "instance-dependency";
    private static final String NAME_ELEMENT = "name";
    private static final String VERSION_ELEMENT = "version";
    private static final String PRIVATE_PATH_ELEMENT = "private-path";
    private static final String PUBLIC_PATH_ELEMENT = "public-path";
    private static final String LIBRARY_PATH_ELEMENT = "library-path";
    private static final String PATH_ELEMENT = "path-element";
    private static final String SUPPORTED_VERSION_ELEMENT = "cacao-version-supported";
    private static final String HEAP_ELEMENT = "heap-requirements-kilobytes";
    private static final String DATA_DRIVEN_ELEMENT = "mbean-instances-descriptor";
    private static final String PARAMETERS_ELEMENT = "parameters";
    private static final String PARAMETER_ELEMENT = "parameter";
    private static final String PARAMETER_NAME_ELEMENT = "param-name";
    private static final String PARAMETER_VALUE_ELEMENT = "param-value";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String STATE_ATTRIBUTE = "initial-administrative-state";
    private static final String DEPENDENCY_TYPE_ATTRIBUTE = "dependency-type";
    private static final String IGNORED_STARTUP_ATTRIBUTE = "ignored-at-startup";
    private static final String ENABLE_ON_DEMAND_ATTRIBUTE = "enable-on-demand";
    private static final String ALLOW_MORE_RECENT_ATTRIBUTE = "allow-more-recent";
    private static final String DEFAULT_VERSION = "1.0";
    private static final String STRONG_DEPENDENCY = "STRONG_DEPENDENCY";
    private static final String WEAK_DEPENDENCY = "WEAK_DEPENDENCY";
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String MODULE_DTD_1_0_URI = "urn:sun:n1:cacao:module:dtd:1_0";
    private static final String MODULE_DTD_URI = "urn:sun:n1:cacao:module:dtd:1_1";
    private static Logger logger = Logger.getLogger("com.sun.cacao.container");
    private String versionNames = null;
    private DeploymentDescriptor descriptor = null;
    private String text = "";
    private List dependencies = null;
    private String dependencyModuleName;
    private String dependencyVersion;
    private boolean dependencyWeak;
    private boolean dependencyVersionAllow;
    private Properties parameters = null;
    private String parameterName;
    private String parameterValue;
    private String pathType = null;
    private List paths = null;

    public DeploymentDescriptorHandler(String string) {
        this.versionNames = string;
        this.descriptor = new DeploymentDescriptor();
    }

    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.descriptor;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        String string3 = JmxClient.getStringParameter(null, "use.j2me");
        if (Boolean.valueOf(string3).booleanValue()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("no XML validation with J2ME SAX parser");
            }
            return null;
        }
        if (string2.toLowerCase().equals(MODULE_DTD_1_0_URI) || string2.toLowerCase().equals(MODULE_DTD_URI) || string2.equals("file:///opt/module.dtd") || string2.equals("file:///opt/sun/module.dtd") || string2.equals("../module.dtd")) {
            InputStream inputStream;
            if ((string2.equals("file:///opt/module.dtd") || string2.equals("file:///opt/sun/module.dtd") || string2.equals("../module.dtd")) && logger.isLoggable(Level.FINE)) {
                logger.fine("Support for DTD paths other than a URN have been deprecated; Please use the URN \"urn:sun:n1:cacao:module:dtd:1_1\"");
            }
            if ((inputStream = this.getClass().getClassLoader().getResourceAsStream("com/sun/cacao/module.dtd")) != null) {
                return new InputSource(inputStream);
            }
            throw new SAXException("Module DTD not found in local classloader");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Support for DTD paths other than a URN have been deprecated; Please use the URN \"urn:sun:n1:cacao:module:dtd:1_1\"");
        }
        return null;
    }

    public void endDocument() {
        if (this.descriptor.getModuleClass() == null) {
            if (!this.descriptor.getCacaoVersion().equals(DEFAULT_VERSION)) {
                this.descriptor.setModuleClass("com.sun.cacao.noentrypoint.NoEntryPointModule");
                LinkedList<URL> linkedList = this.descriptor.getPublicPaths();
                if (linkedList == null) {
                    linkedList = new LinkedList<URL>();
                }
                URL uRL = null;
                String string = "file:" + Container.getProperty("cacao.jar.dir") + System.getProperty("file.separator") + "cacao_noentrypoint.jar";
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Failed to parse URL: " + string);
                }
                linkedList.add(uRL);
                this.descriptor.setPublicPaths(linkedList);
            } else {
                throw new IllegalArgumentException("For module compatible with1.0, a module class must be provided.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.text = "";
        if (string3.equals(MODULE_ELEMENT)) {
            this.setModuleAttributes(attributes);
            return;
        } else if (string3.equals(DEPENDENCIES_ELEMENT)) {
            this.dependencies = new LinkedList();
            return;
        } else if (string3.equals(DEPENDENCY_ELEMENT)) {
            this.dependencyModuleName = null;
            this.dependencyVersion = null;
            this.dependencyWeak = true;
            String string4 = attributes.getValue(DEPENDENCY_TYPE_ATTRIBUTE);
            if (string4 == null || !string4.equals(STRONG_DEPENDENCY)) return;
            this.dependencyWeak = false;
            return;
        } else if (string3.equals("version")) {
            String string5 = attributes.getValue(ALLOW_MORE_RECENT_ATTRIBUTE);
            if (string5 != null) {
                if (string5.equalsIgnoreCase(YES)) {
                    this.dependencyVersionAllow = true;
                    return;
                } else {
                    if (!string5.equalsIgnoreCase(NO)) throw new IllegalArgumentException("Invalid value for attribute allow-more-recent: " + string5 + " (\"yes\" or \"no\" expected)");
                    this.dependencyVersionAllow = false;
                }
                return;
            } else {
                this.dependencyVersionAllow = false;
            }
            return;
        } else if (string3.equals(PARAMETERS_ELEMENT)) {
            this.parameters = new Properties();
            return;
        } else if (string3.equals(PARAMETER_ELEMENT)) {
            this.parameterName = null;
            this.parameterValue = null;
            return;
        } else if (string3.equals(PUBLIC_PATH_ELEMENT)) {
            this.pathType = PUBLIC_PATH_ELEMENT;
            this.paths = new LinkedList();
            return;
        } else if (string3.equals(PRIVATE_PATH_ELEMENT)) {
            this.pathType = PRIVATE_PATH_ELEMENT;
            this.paths = new LinkedList();
            return;
        } else {
            if (!string3.equals(LIBRARY_PATH_ELEMENT)) return;
            this.pathType = LIBRARY_PATH_ELEMENT;
            this.paths = new LinkedList();
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string3.equals(DESCRIPTION_ELEMENT)) {
            this.descriptor.setDescription(this.text);
        } else if (string3.equals(MODULE_CLASS_ELEMENT)) {
            if (this.text == null || this.text.equals("")) {
                throw new IllegalArgumentException("Missing module's class name");
            }
            this.descriptor.setModuleClass(this.text);
        } else if (string3.equals(SUPPORTED_VERSION_ELEMENT)) {
            if (this.text == null || this.text.equals("")) {
                this.text = DEFAULT_VERSION;
            }
            this.checkFrameworkVersion(this.text);
            this.descriptor.setCacaoVersion(this.text);
        } else if (string3.equals(HEAP_ELEMENT)) {
            int n = 0;
            try {
                n = Integer.parseInt(this.text);
                if (n < 0) {
                    throw new IllegalArgumentException("Negative heap value is not supported: " + n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid value for heap: " + n);
            }
            this.descriptor.setHeap(n);
        } else if (string3.equals(DATA_DRIVEN_ELEMENT)) {
            if (this.text == null || this.text.equals("")) {
                throw new IllegalArgumentException("Missing a value for mbean-instances-descriptorelement");
            }
            this.descriptor.setMbeanInstancesDescriptor(this.text);
        } else if (string3.equals("name")) {
            this.dependencyModuleName = this.text;
        } else if (string3.equals("version")) {
            this.dependencyVersion = this.text;
            this.checkModuleVersion(this.dependencyVersion);
        } else if (string3.equals(DEPENDENCY_ELEMENT)) {
            if (this.dependencyVersion == null) {
                this.dependencyVersion = DEFAULT_VERSION;
            }
            this.dependencies.add(new Dependency(this.dependencyModuleName, this.dependencyVersion, this.dependencyVersionAllow, this.dependencyWeak));
        } else if (string3.equals(DEPENDENCIES_ELEMENT)) {
            this.descriptor.setDependencies(this.dependencies);
        } else if (string3.equals(PARAMETER_NAME_ELEMENT)) {
            this.parameterName = this.text;
        } else if (string3.equals(PARAMETER_VALUE_ELEMENT)) {
            if (this.text == null) {
                this.text = "";
            }
            this.parameterValue = this.text;
        } else if (string3.equals(PARAMETER_ELEMENT)) {
            if (this.parameterName == null || this.parameterName.equals("")) {
                throw new IllegalArgumentException("Missing a parameter name in parameters section");
            }
            this.parameters.setProperty(this.parameterName, this.parameterValue);
        } else if (string3.equals(PARAMETERS_ELEMENT)) {
            this.descriptor.setParameters(this.parameters);
        } else if (string3.equals(PATH_ELEMENT)) {
            if (this.pathType.equals(LIBRARY_PATH_ELEMENT)) {
                this.paths.add(this.text);
            } else {
                URL uRL = null;
                try {
                    uRL = new URL(this.text);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Invalid URL: " + this.text);
                }
                if (!uRL.getProtocol().equals("file")) {
                    throw new IllegalArgumentException("Protocol not supported: " + uRL.getProtocol() + "(" + this.text + ")");
                }
                this.paths.add(uRL);
            }
        } else if (string3.equals(PUBLIC_PATH_ELEMENT)) {
            this.descriptor.setPublicPaths(this.paths);
        } else if (string3.equals(PRIVATE_PATH_ELEMENT)) {
            this.descriptor.setPrivatePaths(this.paths);
        } else if (string3.equals(LIBRARY_PATH_ELEMENT)) {
            this.descriptor.setLibraryPaths(this.paths);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        this.text = this.text + string.trim();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(sAXParseException.getMessage());
        }
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning(sAXParseException.getMessage());
        }
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning(sAXParseException.getMessage());
        }
        throw sAXParseException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setModuleAttributes(Attributes attributes) {
        String string = attributes.getValue("name");
        this.descriptor.setName(string);
        string = attributes.getValue("version");
        if (string == null) {
            string = DEFAULT_VERSION;
        } else {
            this.checkModuleVersion(string);
        }
        this.descriptor.setVersion(string);
        AdministrativeStateEnum administrativeStateEnum = AdministrativeStateEnum.UNLOCKED;
        string = attributes.getValue(STATE_ATTRIBUTE);
        if (string != null) {
            administrativeStateEnum = (AdministrativeStateEnum)Enum.getEnum(AdministrativeStateEnum.class, string);
        }
        this.descriptor.setInitialAdministrativeState(administrativeStateEnum);
        string = attributes.getValue(IGNORED_STARTUP_ATTRIBUTE);
        if (string != null) {
            if (string.equalsIgnoreCase(YES)) {
                this.descriptor.setIgnoredAtStartup(true);
            } else {
                if (!string.equalsIgnoreCase(NO)) throw new IllegalArgumentException("Invalid value for attribute ignored-at-startup: " + string + " (\"yes\" or \"no\" expected)");
                this.descriptor.setIgnoredAtStartup(false);
            }
        } else {
            this.descriptor.setIgnoredAtStartup(false);
        }
        string = attributes.getValue(ENABLE_ON_DEMAND_ATTRIBUTE);
        if (string != null) {
            if (string.equalsIgnoreCase(YES)) {
                this.descriptor.setEnableOnDemand(true);
                return;
            } else {
                if (!string.equalsIgnoreCase(NO)) throw new IllegalArgumentException("Invalid value for attribute enable-on-demand: " + string + " (\"yes\" or \"no\" expected)");
                this.descriptor.setEnableOnDemand(false);
            }
            return;
        } else {
            this.descriptor.setEnableOnDemand(false);
        }
    }

    private void checkModuleVersion(String string) throws IllegalArgumentException {
        boolean bl = true;
        int n = -1;
        int n2 = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 2) {
            bl = false;
        } else {
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Version number, " + string + " does not follow X.Y syntax with X " + "and Y integer for module version");
        }
        if (n < 1) {
            throw new IllegalArgumentException("For module version, " + string + " major number should be superior or equal to 1.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("For module version, " + string + " minor number should be superior or equal to 0.");
        }
    }

    private void checkFrameworkVersion(String string) throws IllegalArgumentException {
        this.checkModuleVersion(string);
        Set set = new HashSet();
        set = this.versionNames == null ? Container.getSupportedVersions() : Container.getSupportedVersions(this.versionNames);
        if (!set.contains(string)) {
            throw new IllegalArgumentException("Version " + string + " is not supported by the current version of cacao.");
        }
    }
}

