/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.container;

import com.sun.cacao.Dependency;
import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.ModuleManagerMBean;
import com.sun.cacao.ObjectNameFactoryInterface;
import com.sun.cacao.container.Container;
import com.sun.cacao.container.ModuleManagerNotificationFilter;
import com.sun.cacao.element.AdministrativeStateEnum;
import com.sun.cacao.element.AvailabilityStatusEnum;
import com.sun.cacao.element.ElementSupport;
import com.sun.cacao.element.OperationalStateEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.OperationsException;

public abstract class DependenciesSupport
extends ElementSupport
implements NotificationListener,
MBeanRegistration {
    private static Logger logger = Logger.getLogger("com.sun.cacao.container");
    private static final String mbeanServerNotificationKey = "JMImplementation:type=MBeanServerDelegate";
    protected DeploymentDescriptor descriptor;

    public DependenciesSupport(DeploymentDescriptor deploymentDescriptor, ObjectName objectName) {
        super(objectName);
        this.descriptor = deploymentDescriptor;
        try {
            NotificationFilter notificationFilter = this.getFilter();
            ObjectName objectName2 = new ObjectName(mbeanServerNotificationKey);
            this.getMbs().addNotificationListener(objectName2, this, notificationFilter, null);
        }
        catch (OperationsException operationsException) {
            this.disableWithDependencyFailure();
        }
    }

    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.descriptor.getCopy();
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
        ObjectName objectName;
        List list = this.getValidDependenciesObjectName();
        try {
            objectName = new ObjectName(mbeanServerNotificationKey);
            list.add(objectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            objectName = (ObjectName)iterator.next();
            try {
                this.getMbs().removeNotificationListener(objectName, this);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                logger.log(Level.FINEST, "Cannot remove as listener of " + objectName);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {
                logger.log(Level.FINEST, "Was not registered as listener of " + objectName);
            }
        }
    }

    public void postDeregister() {
    }

    public void handleNotification(Notification notification, Object object) {
        logger.finer("Handle a notification for " + this.descriptor.getName());
        String string = notification.getType();
        if (string.equals("jmx.attribute.change")) {
            AttributeChangeNotification attributeChangeNotification = (AttributeChangeNotification)notification;
            String string2 = attributeChangeNotification.getAttributeName();
            if (string2.equals("AdministrativeState")) {
                if (attributeChangeNotification.getNewValue() == AdministrativeStateEnum.LOCKED) {
                    if (!this.areDependenciesOk(false)) {
                        this.disableWithDependencyFailure();
                    }
                } else if (attributeChangeNotification.getNewValue() == AdministrativeStateEnum.UNLOCKED) {
                    if (this.areDependenciesOk(false)) {
                        try {
                            this.enableAndClearDependencyFailure();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            logger.finest("Unauthorized  set operational state to enable for " + this.descriptor.getName());
                        }
                    }
                } else {
                    logger.finest("Receive a shutting down notification");
                }
            } else if (string2.equals("OperationalState")) {
                if (attributeChangeNotification.getNewValue() == OperationalStateEnum.DISABLED) {
                    if (!this.areDependenciesOk(false)) {
                        this.disableWithDependencyFailure();
                    }
                } else if (this.areDependenciesOk(false)) {
                    try {
                        this.enableAndClearDependencyFailure();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.finest("Unauthorized set operational state to enable for " + this.descriptor.getName());
                    }
                }
            }
        } else if (string.equals("JMX.mbean.registered")) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("A new module on which " + this.descriptor.getName() + " depends, has been added");
            }
            try {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName objectName = mBeanServerNotification.getMBeanName();
                logger.finer("New module to listen to is " + objectName);
                this.getMbs().addNotificationListener(objectName, this, null, null);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                logger.info("Cannot listen to notification for " + this.descriptor.getName());
            }
            if (this.areDependenciesOk(false)) {
                try {
                    this.enableAndClearDependencyFailure();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.finest("Cannot set operational state to enable for " + this.descriptor.getName());
                }
            }
        }
    }

    protected boolean areDependenciesOk(boolean bl) {
        List list = this.descriptor.getDependencies();
        boolean bl2 = true;
        if (list == null) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            if (this.isDependencyOk(dependency, bl)) continue;
            if (!bl) {
                return false;
            }
            bl2 = false;
        }
        return bl2;
    }

    protected abstract ObjectName getDependencyObjectName(String var1);

    private boolean isDependencyOk(Dependency dependency, boolean bl) {
        Iterator iterator = Container.getStarted().iterator();
        logger.finer("isDependencyOk for " + this.getObjectName() + " dependency is " + dependency);
        while (iterator.hasNext()) {
            DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)iterator.next();
            String string = dependency.getModuleName();
            if (!deploymentDescriptor.getName().equals(string)) continue;
            try {
                ObjectName objectName = this.getDependencyObjectName(deploymentDescriptor.getName());
                if (this.isValidDependency(dependency)) {
                    boolean bl2 = true;
                    if (!this.isElementOk(objectName)) {
                        bl2 = false;
                    }
                    if (bl) {
                        logger.finer(this.getObjectName() + " listens to " + objectName);
                        this.getMbs().addNotificationListener(objectName, this, null, null);
                    }
                    return bl2;
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Cannot check dependency", exception);
                throw new RuntimeException(exception.getMessage());
            }
            return true;
        }
        return false;
    }

    protected boolean isValidDependency(Dependency dependency) {
        return true;
    }

    protected void disableWithDependencyFailure() {
        try {
            this.setOperationalState(OperationalStateEnum.DISABLED);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.FINEST, "Set to disable and we should not have thefollowing exception ", illegalArgumentException);
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "We have a problem to stop the module ", throwable);
        }
        this.availabilityStatusSetAdd(AvailabilityStatusEnum.DEPENDENCY);
        logger.fine("Operational State of ModuleManager " + this.descriptor.getName() + " is set to DISABLED");
    }

    protected void enableAndClearDependencyFailure() {
        this.availabilityStatusSetRemove(AvailabilityStatusEnum.DEPENDENCY);
        try {
            this.setOperationalState(OperationalStateEnum.ENABLED);
        }
        catch (Throwable throwable) {
            logger.finest("Cannot set operational state to enable for " + this.descriptor.getName());
        }
    }

    protected ObjectName getModuleManagerObjectName(String string) {
        ObjectNameFactoryInterface objectNameFactoryInterface = Container.getCacaoObjectNameFactory();
        return objectNameFactoryInterface.getObjectName(ModuleManagerMBean.class, string);
    }

    protected List getValidDependenciesObjectName() {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        List list = this.descriptor.getDependencies();
        if (list != null && list.size() != 0) {
            Iterator iterator = this.descriptor.getDependencies().iterator();
            while (iterator.hasNext()) {
                Dependency dependency = (Dependency)iterator.next();
                if (!this.isValidDependency(dependency)) continue;
                try {
                    arrayList.add(this.getDependencyObjectName(dependency.getModuleName()));
                }
                catch (Throwable throwable) {
                    logger.warning("In getValidDependency problem for obtaining objectName for " + dependency.getModuleName());
                }
            }
        }
        return arrayList;
    }

    protected NotificationFilter getFilter() {
        List list = this.getValidDependenciesObjectName();
        logger.finer("Module " + this.descriptor.getName() + " is waiting  for creation/deletion of " + list);
        ModuleManagerNotificationFilter moduleManagerNotificationFilter = new ModuleManagerNotificationFilter(list);
        return moduleManagerNotificationFilter;
    }

    private boolean isElementOk(ObjectName objectName) {
        MBeanServer mBeanServer = Container.getMbs();
        try {
            AdministrativeStateEnum administrativeStateEnum = (AdministrativeStateEnum)mBeanServer.getAttribute(objectName, "AdministrativeState");
            OperationalStateEnum operationalStateEnum = (OperationalStateEnum)mBeanServer.getAttribute(objectName, "OperationalState");
            return operationalStateEnum != OperationalStateEnum.DISABLED && administrativeStateEnum != AdministrativeStateEnum.LOCKED;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected MBeanServer getMbs() {
        return Container.getMbs();
    }
}

