/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.container;

import com.sun.cacao.Cacao;
import com.sun.cacao.CacaoMBean;
import com.sun.cacao.Dependency;
import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.ModuleLifecycleManager;
import com.sun.cacao.ModuleLifecycleManagerMBean;
import com.sun.cacao.ModuleManager;
import com.sun.cacao.ModuleManagerMBean;
import com.sun.cacao.ObjectNameFactory;
import com.sun.cacao.ObjectNameFactoryInterface;
import com.sun.cacao.agent.JmxAgent;
import com.sun.cacao.agent.auth.AccessControl;
import com.sun.cacao.agent.auth.AccessControlMBean;
import com.sun.cacao.agent.auth.AssertMechanism;
import com.sun.cacao.agent.trust.CacaoTrustStore;
import com.sun.cacao.agent.trust.CacaoTrustStoreMBean;
import com.sun.cacao.common.instrum.InstrumConfiguration;
import com.sun.cacao.common.instrum.InstrumStats;
import com.sun.cacao.common.instrum.InstrumTimes;
import com.sun.cacao.container.ModuleInformation;
import com.sun.cacao.container.Parser;
import com.sun.cacao.logging.LoggingInit;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.IntrospectionException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.xml.parsers.FactoryConfigurationError;
import org.xml.sax.SAXException;

public class Container {
    public static final String CACAO_PROPERTIES = "cacao.properties";
    public static final String VERSION_KEY = "cacao.version";
    public static final String VERSION_SUPPORTED_KEY = "cacao.version.compatibility.list";
    public static final String MBEAN_SRV_DELEGATE_ON = "JMImplementation:type=MBeanServerDelegate";
    public static final String RC_FILE_PREFIX = "rc.file.prefix";
    public static final String CACAO_JAR_DIR = "cacao.jar.dir";
    public static final String USE_J2ME = "use.j2me";
    public static final String CACAO_LIB_DIR = "cacao.lib.dir";
    public static final String SUEXEC_PATH_PROPERTY = "suexec.path";
    public static final String SNMP_ADAPTOR_PORT = "com.sun.cacao.snmp.adaptor.port";
    public static final String SNMP_TRAP_PORT = "com.sun.cacao.snmp.adaptor.trap.port";
    public static final String COMMANDSTREAM_ADAPTOR_PORT = "com.sun.cacao.commandstream.adaptor.port";
    public static final String CACAO_INSTANCE_NAME = "cacao.instance.name";
    public static final String CACAO_DEFAULT_INSTANCE_NAME = "default";
    private static Logger logger = Logger.getLogger("com.sun.cacao.container");
    public static final String CONTAINER_DOMAIN_NAME = "com.sun.cacao";
    private static final String VERSION_1_0 = "1.0";
    private static final String COMPATIBILITY_MODULE_NAME = "com.sun.cacao.compatibility1.0";
    private static boolean isShuttingDown = false;
    private static boolean isEmbeddedInstance = true;
    private static Cacao cacaoMBean = null;
    private static String version;
    private static final String DEFAULT_VERSION_MSG = "Unknown - see package version";
    private static Properties containerProperties;
    private static List started;
    private static Map name2ModuleInformation;
    private static String propertyFile;
    private static String privatePropertyfile;
    private static Parser parser;
    private static Set supportedVersions;
    private static InstrumStats deploys;
    private static InstrumStats undeploys;
    private static long startDurationTime;
    private static final String MBEAN_SERVER_PROPERTY_KEY = "javax.management.builder.initial";
    private static final String JDMK_MBEAN_SERVER = "com.sun.jdmk.JdmkMBeanServerBuilder";
    private static ObjectNameFactoryInterface objectNameFactory;
    private static MBeanServer mbs;

    public static String getProperty(String string) {
        return containerProperties.getProperty(string);
    }

    public static synchronized void start(File file, String string) throws IllegalArgumentException, IntrospectionException, Exception {
        Object object;
        if (Container.getMbs() != null) {
            throw new Exception("Cacao is already running");
        }
        if (string == null) {
            throw new IllegalArgumentException("Password must be different from null");
        }
        System.setProperty(CACAO_PROPERTIES, file.getPath());
        System.setProperty(MBEAN_SERVER_PROPERTY_KEY, JDMK_MBEAN_SERVER);
        try {
            String string2;
            containerProperties = new Properties();
            object = new FileInputStream(file.getPath());
            containerProperties.load((InputStream)object);
            Enumeration<?> enumeration = containerProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                String string3 = containerProperties.getProperty(string2);
                if (string3 == null) continue;
                containerProperties.setProperty(string2, string3.trim());
            }
            string2 = Container.getProperty("com.sun.cacao.jmxmp.connector.port");
            if (string2 == null || string2.equals("") || string2.equals("-1")) {
                throw new Exception("JMXMP port invalid value");
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot load properties file");
        }
        LoggingInit.init();
        try {
            parser = new Parser();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            logger.severe("No module could be loaded (deployment parser cannot be loaded).");
        }
        logger.info("Cacao properties : " + containerProperties.toString());
        LoggingInit.initInstrumLogging();
        startDurationTime = InstrumTimes.getNsTime();
        deploys = new InstrumStats();
        undeploys = new InstrumStats();
        try {
            object = Container.getCacaoLibraryDir() + "/libcacao_cacao.so";
            Runtime.getRuntime().load((String)object);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.log(Level.WARNING, "Unable to load cacao native runtime library" + unsatisfiedLinkError);
            throw unsatisfiedLinkError;
        }
        try {
            LoggingInit.addSyslogHandler();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Unable to start Cacao syslogging");
        }
        logger.info("Cacao starting... version: " + Container.getVersion());
        logger.info("Java version " + System.getProperty("java.version") + " vendor " + System.getProperty("java.vendor") + " OS: " + System.getProperty("os.name") + " arch: " + System.getProperty("os.arch"));
        AssertMechanism.setPassword(string);
        object = AssertMechanism.createSubject("root", true);
        Subject.doAs((Subject)object, new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                Container.init();
                return null;
            }
        });
    }

    public static synchronized void stop() {
        if (Container.getMbs() == null) {
            return;
        }
        Container.stopModulesAndConnectors();
        ObjectNameFactoryInterface objectNameFactoryInterface = Container.getCacaoObjectNameFactory();
        try {
            mbs.unregisterMBean(objectNameFactoryInterface.getObjectName(CacaoMBean.class, null));
            mbs.unregisterMBean(objectNameFactoryInterface.getObjectName(AccessControlMBean.class, null));
            mbs.unregisterMBean(objectNameFactoryInterface.getObjectName(ModuleLifecycleManagerMBean.class, null));
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Should never fail to unregister cacao's MBeans", exception);
        }
        JmxAgent.cleanMBeanServer();
        mbs = null;
    }

    public static String getCacaoLibraryDir() {
        String string;
        String string2 = Container.getProperty(CACAO_LIB_DIR);
        if (System.getProperty("os.name").equals("SunOS") && ((string = System.getProperty("os.arch")).equals("sparcv9") || string.equals("amd64"))) {
            string2 = string2 + "/" + string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string;
        block10: {
            String string2 = "Container should be called with no arguments,\nsetting cacao.properties to point to config file";
            propertyFile = System.getProperty(CACAO_PROPERTIES);
            if (stringArray.length != 0 || propertyFile == null) {
                System.err.println(string2);
                System.exit(1);
            }
            string = null;
            String string3 = System.getProperty("com.sun.cacao.ssl.keystore.password.file");
            try {
                Closeable closeable;
                if (string3 != null && string3.length() > 0) {
                    logger.warning("reading secret password from " + string3);
                    closeable = null;
                    try {
                        closeable = new FileInputStream(string3);
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)closeable);
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                        string = bufferedReader.readLine();
                        break block10;
                    }
                    finally {
                        if (closeable != null) {
                            ((InputStream)closeable).close();
                        }
                    }
                }
                string3 = "stdin";
                closeable = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader((Reader)closeable);
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                String string4 = "Unable to read secret from " + string3;
                logger.log(Level.SEVERE, string4, iOException);
                System.err.println(string4);
                System.exit(1);
            }
        }
        try {
            isEmbeddedInstance = false;
            Container.start(new File(propertyFile), string);
        }
        catch (Exception exception) {
            System.err.println("Unable to start cacao error " + exception.getMessage());
            System.exit(1);
        }
    }

    public static ObjectNameFactoryInterface getCacaoObjectNameFactory() {
        if (objectNameFactory == null) {
            objectNameFactory = new ObjectNameFactory(CONTAINER_DOMAIN_NAME);
        }
        return objectNameFactory;
    }

    private static void init() throws IntrospectionException, Exception {
        Object object;
        mbs = JmxAgent.createMBeanServer();
        try {
            object = new ObjectName(MBEAN_SRV_DELEGATE_ON);
            StringBuffer stringBuffer = new StringBuffer("JMX version ");
            stringBuffer.append((String)mbs.getAttribute((ObjectName)object, "SpecificationVersion"));
            stringBuffer.append(" vendor ");
            stringBuffer.append((String)mbs.getAttribute((ObjectName)object, "SpecificationVendor"));
            logger.info(stringBuffer.toString());
        }
        catch (Exception exception) {
            logger.info("ERROR while retrieving JMX versionning information " + exception.toString());
        }
        try {
            logger.info("JDMK version 5.1-b34 vendor Sun Microsystems");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cacaoMBean = new Cacao();
        Container.createContainerMBeans();
        Security.addProvider((java.security.Provider)new Provider());
        JmxAgent.registerAdaptorsAndConnectors();
        Container.registerModules();
        if (!JmxAgent.startAdaptorsAndConnectors()) {
            object = "Cacao Initialization failure : cannot start JMXMP";
            logger.severe((String)object);
            Container.stop();
            if (isEmbeddedInstance) {
                throw new Exception("JMXMP connector activation failure");
            }
            System.err.println((String)object);
            System.exit(0);
        }
        cacaoMBean.sendLifecycleNotification("com.sun.cacao.lifecycle.started");
        logger.info("Cacao Initialization completed");
        startDurationTime = InstrumTimes.getNsTime() - startDurationTime;
    }

    public static List getStarted() {
        return started;
    }

    public static void registerModules() {
        File file;
        String[] stringArray;
        if (parser == null) {
            return;
        }
        String string = Container.getProperty(RC_FILE_PREFIX);
        if (string == null) {
            logger.warning("Unable to find Cacao module directory path : rc.file.prefix");
        }
        if ((stringArray = (file = new File(string)).list()) == null) {
            stringArray = new String[]{};
        }
        ArrayList<DeploymentDescriptor> arrayList = new ArrayList<DeploymentDescriptor>();
        ArrayList<DeploymentDescriptor> arrayList2 = new ArrayList<DeploymentDescriptor>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (stringArray[i].endsWith(".xml")) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Deployment descriptor file name: " + stringArray[i]);
                    }
                    DeploymentDescriptor deploymentDescriptor = parser.getDeploymentDescriptor(string + System.getProperty("file.separator") + stringArray[i]);
                    logger.fine("Get the descriptor " + deploymentDescriptor);
                    if (!deploymentDescriptor.getIgnoredAtStartup()) {
                        if (deploymentDescriptor.getName().startsWith("com.sun.cacao.") && !deploymentDescriptor.getName().startsWith("com.sun.cacao.examples.")) {
                            arrayList.add(deploymentDescriptor);
                            continue;
                        }
                        arrayList2.add(deploymentDescriptor);
                        continue;
                    }
                    logger.fine("Ignore at startup descriptor " + deploymentDescriptor.getName());
                    continue;
                }
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("Not a deployment descriptor file name: " + stringArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.warning("Cannot create deployment descriptor " + stringArray[i] + " because " + illegalArgumentException.getMessage());
                continue;
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Cannot create module" + stringArray[i] + "caught exception : " + exception.getMessage(), exception);
            }
        }
        Container.startModulesInOrder(arrayList);
        Container.startModulesInOrder(arrayList2);
    }

    private static void startModulesInOrder(List list) {
        Object object;
        Iterator iterator;
        boolean bl = true;
        while (bl) {
            bl = false;
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (DeploymentDescriptor)iterator.next();
                if (!Container.isStartable((DeploymentDescriptor)object)) continue;
                iterator.remove();
                try {
                    bl = true;
                    Container.unsynchronizedDeployModule((DeploymentDescriptor)object);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Unable to load module " + ((DeploymentDescriptor)object).getModuleClass() + ":" + exception.getMessage(), exception);
                }
            }
        }
        if (!list.isEmpty()) {
            iterator = list.iterator();
            object = "";
            while (iterator.hasNext()) {
                DeploymentDescriptor deploymentDescriptor = null;
                try {
                    deploymentDescriptor = (DeploymentDescriptor)iterator.next();
                    object = deploymentDescriptor.getName() + " " + (String)object;
                    Container.unsynchronizedDeployModule(deploymentDescriptor);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Cannot start module manager for " + deploymentDescriptor.getName(), exception);
                }
            }
            logger.warning("Dependencies problem for modules: " + (String)object);
        }
    }

    public static boolean isShuttingDown() {
        return isShuttingDown;
    }

    public static synchronized void shutDown() {
        Container.stopModulesAndConnectors();
        System.exit(0);
    }

    private static void stopModulesAndConnectors() {
        String string;
        DeploymentDescriptor deploymentDescriptor;
        Iterator iterator;
        cacaoMBean.sendLifecycleNotification("com.sun.cacao.lifecycle.shutdown");
        ArrayList<DeploymentDescriptor> arrayList = new ArrayList<DeploymentDescriptor>();
        ArrayList arrayList2 = new ArrayList(started);
        ArrayList<DeploymentDescriptor> arrayList3 = new ArrayList<DeploymentDescriptor>();
        isShuttingDown = true;
        boolean bl = true;
        while (bl) {
            bl = false;
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                deploymentDescriptor = (DeploymentDescriptor)iterator.next();
                string = deploymentDescriptor.getName();
                if (Container.hasDependency(string)) continue;
                try {
                    bl = true;
                    Container.unsynchronizedUndeployModule(string, false);
                    started.remove(deploymentDescriptor);
                    arrayList.add(deploymentDescriptor);
                    logger.info("Shutdown " + string);
                }
                catch (Throwable throwable) {
                    logger.log(Level.WARNING, "Cannot shutdown module " + string + " properly.", throwable);
                    arrayList3.add(deploymentDescriptor);
                }
            }
            arrayList2.removeAll(arrayList);
            arrayList2.removeAll(arrayList3);
        }
        if (!arrayList2.isEmpty()) {
            logger.fine("Shutdown module with cycle");
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                deploymentDescriptor = (DeploymentDescriptor)iterator.next();
                string = deploymentDescriptor.getName();
                try {
                    Container.unsynchronizedUndeployModule(string, false);
                    started.remove(deploymentDescriptor);
                    arrayList.add(deploymentDescriptor);
                    logger.info("Shutdown " + string);
                }
                catch (Throwable throwable) {
                    logger.log(Level.WARNING, "Cannot shutdown module " + string + " properly.", throwable);
                }
            }
        }
        JmxAgent.stopAdaptorsAndConnectors();
        InstrumConfiguration.removeStatReference("deploys_stats");
        InstrumConfiguration.removeStatReference("undeploys_stats");
    }

    private static boolean hasCycle(String string) {
        ModuleInformation moduleInformation = (ModuleInformation)name2ModuleInformation.get(string);
        Set set = moduleInformation.getRelyingModule();
        if (set == null || set.size() == 0) {
            return false;
        }
        return Container.usesModule(set, string);
    }

    private static boolean usesModule(Set set, String string) {
        if (string == null || set == null || set.isEmpty()) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string.equals(string2)) {
                return true;
            }
            ModuleInformation moduleInformation = (ModuleInformation)name2ModuleInformation.get(string2);
            Set set2 = moduleInformation.getRelyingModule();
            if (!Container.usesModule(set2, string)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDependency(String string) {
        ModuleInformation moduleInformation = (ModuleInformation)name2ModuleInformation.get(string);
        Set set = moduleInformation.getRelyingModule();
        return set != null && set.size() != 0;
    }

    public static void abort() {
        logger.info("Abort execution of Cacao container");
        System.exit(0);
    }

    public static ObjectName deployModule(URL uRL) throws SAXException, IOException, InstanceAlreadyExistsException, RuntimeException {
        DeploymentDescriptor deploymentDescriptor = parser.getDeploymentDescriptor(uRL.openStream());
        return Container.deployModule(deploymentDescriptor);
    }

    public static synchronized ObjectName deployModule(DeploymentDescriptor deploymentDescriptor) throws RuntimeException, InstanceAlreadyExistsException {
        return Container.unsynchronizedDeployModule(deploymentDescriptor);
    }

    private static ObjectName unsynchronizedDeployModule(DeploymentDescriptor deploymentDescriptor) throws RuntimeException, InstanceAlreadyExistsException {
        long l = InstrumTimes.getNsTime();
        logger.fine("Add the descriptor " + deploymentDescriptor);
        ModuleManager moduleManager = null;
        try {
            ObjectName objectName = Container.getCacaoObjectNameFactory().getObjectName(ModuleManagerMBean.class, deploymentDescriptor.getName());
            name2ModuleInformation.put(deploymentDescriptor.getName(), new ModuleInformation(deploymentDescriptor));
            moduleManager = new ModuleManager(deploymentDescriptor, objectName);
            started.add(deploymentDescriptor);
            mbs.registerMBean(moduleManager, objectName);
            Container.addModuleDependencies(deploymentDescriptor);
            moduleManager.unlock();
            deploys.incrNumberOfOperations();
            deploys.updateTimes(InstrumTimes.getNsTime() - l);
            return objectName;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            deploys.incrNumberOfAbortedOperations();
            logger.log(Level.FINE, "Error in deployModule ", instanceAlreadyExistsException);
            if (moduleManager == null) {
                name2ModuleInformation.remove(deploymentDescriptor.getName());
                started.remove(deploymentDescriptor);
            }
            throw new RuntimeException("Instance already exists.");
        }
        catch (Exception exception) {
            deploys.incrNumberOfFailedOperations();
            logger.log(Level.FINE, "Error in deployModule ", exception);
            if (moduleManager == null) {
                name2ModuleInformation.remove(deploymentDescriptor.getName());
                started.remove(deploymentDescriptor);
            }
            throw new RuntimeException(deploymentDescriptor.getName() + " cannot be deployed. " + exception.getMessage());
        }
    }

    public static synchronized void undeployModule(String string) throws RuntimeException {
        Container.unsynchronizedUndeployModule(string, true);
    }

    private static void unsynchronizedUndeployModule(String string, boolean bl) throws RuntimeException {
        long l = InstrumTimes.getNsTime();
        ModuleInformation moduleInformation = (ModuleInformation)name2ModuleInformation.get(string);
        if (moduleInformation == null) {
            undeploys.incrNumberOfAbortedOperations();
            logger.info("Module instance " + string + " not found.");
            throw new RuntimeException("Module instance " + string + " not found.");
        }
        if (bl && !Container.hasCycle(string) && Container.hasDependency(string)) {
            undeploys.incrNumberOfAbortedOperations();
            logger.info("Cannot undeploy module some modules relies on it.");
            throw new RuntimeException(string + " cannot be undeployed. ");
        }
        try {
            ObjectName objectName = Container.getCacaoObjectNameFactory().getObjectName(ModuleManagerMBean.class, string);
            mbs = Container.getMbs();
            mbs.invoke(objectName, "lock", null, null);
            mbs.unregisterMBean(objectName);
            name2ModuleInformation.remove(string);
            Container.cleanModuleDependencies(string);
            started.remove(moduleInformation.getDeploymentDescriptor());
            undeploys.incrNumberOfOperations();
            undeploys.updateTimes(InstrumTimes.getNsTime() - l);
        }
        catch (Exception exception) {
            undeploys.incrNumberOfFailedOperations();
            logger.info("Cannot undeploy module " + string + ": " + exception.getMessage());
            throw new RuntimeException(string + " cannot be undeployed. " + exception.getMessage());
        }
    }

    public static Map getModuleInformation() {
        return name2ModuleInformation;
    }

    public static ModuleInformation getModuleInformation(String string) {
        return (ModuleInformation)name2ModuleInformation.get(string);
    }

    private static void addModuleDependencies(DeploymentDescriptor deploymentDescriptor) {
        String string;
        Object object;
        List list;
        Serializable serializable;
        String string2 = deploymentDescriptor.getName();
        Iterator iterator = started.iterator();
        while (iterator.hasNext()) {
            serializable = (DeploymentDescriptor)iterator.next();
            list = ((DeploymentDescriptor)serializable).getDependencies();
            if (list == null) continue;
            object = ((DeploymentDescriptor)serializable).getDependencies().iterator();
            while (object.hasNext()) {
                Dependency dependency = (Dependency)object.next();
                string = dependency.getModuleName();
                if (!string.equals(string2)) continue;
                ModuleInformation moduleInformation = (ModuleInformation)name2ModuleInformation.get(string2);
                if (moduleInformation != null) {
                    moduleInformation.addReference(((DeploymentDescriptor)serializable).getName());
                    logger.finer("Add reference on " + string2 + " for " + ((DeploymentDescriptor)serializable).getName());
                    continue;
                }
                logger.warning("Cannot add a dependency on " + ((DeploymentDescriptor)serializable).getName() + " for " + string2);
            }
        }
        list = deploymentDescriptor.getDependencies();
        if (list == null) {
            return;
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            serializable = (Dependency)iterator.next();
            string = ((Dependency)serializable).getModuleName();
            object = (ModuleInformation)name2ModuleInformation.get(string);
            if (object == null) continue;
            ((ModuleInformation)object).addReference(deploymentDescriptor.getName());
        }
    }

    private static void cleanModuleDependencies(String string) {
        Collection collection = name2ModuleInformation.values();
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModuleInformation moduleInformation = (ModuleInformation)iterator.next();
            moduleInformation.removeReference(string);
        }
    }

    private static boolean isStartable(DeploymentDescriptor deploymentDescriptor) {
        List list = deploymentDescriptor.getDependencies();
        if (list == null) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            if (Container.checkDependency(dependency)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkDependency(Dependency dependency) throws RuntimeException {
        Iterator iterator = started.iterator();
        while (iterator.hasNext()) {
            DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)iterator.next();
            String string = dependency.getModuleName();
            if (!deploymentDescriptor.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static long getStartDurationTime() {
        return startDurationTime;
    }

    public static MBeanServer getMbs() {
        return mbs;
    }

    public static Properties getProperties() {
        return containerProperties;
    }

    public static String getVersion() {
        if (version == null && (version = Container.getProperty(VERSION_KEY)) == null) {
            version = DEFAULT_VERSION_MSG;
        }
        return version;
    }

    public static Set getSupportedVersions() {
        if (supportedVersions == null) {
            String string = Container.getProperty(VERSION_SUPPORTED_KEY);
            supportedVersions = Container.getSupportedVersions(string);
            logger.fine("Cacao framework supports the following version of cacao " + supportedVersions);
        }
        return supportedVersions;
    }

    protected static Set getSupportedVersions(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            hashSet.add(string2);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static void createContainerMBeans() {
        try {
            ObjectNameFactoryInterface objectNameFactoryInterface = Container.getCacaoObjectNameFactory();
            mbs.registerMBean(cacaoMBean, objectNameFactoryInterface.getObjectName(CacaoMBean.class, null));
            mbs.registerMBean(new AccessControl(), objectNameFactoryInterface.getObjectName(AccessControlMBean.class, null));
            mbs.registerMBean(new ModuleLifecycleManager(), objectNameFactoryInterface.getObjectName(ModuleLifecycleManagerMBean.class, null));
            mbs.registerMBean(new CacaoTrustStore(), objectNameFactoryInterface.getObjectName(CacaoTrustStoreMBean.class, null));
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Cannot register container MBean", exception);
        }
        InstrumConfiguration.addStatReference("deploys_stats", deploys);
        InstrumConfiguration.addStatReference("undeploys_stats", undeploys);
    }

    static {
        containerProperties = null;
        started = Collections.synchronizedList(new ArrayList());
        name2ModuleInformation = Collections.synchronizedMap(new HashMap());
        deploys = null;
        undeploys = null;
        startDurationTime = 0L;
        objectNameFactory = null;
    }
}

