/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.common.instrum;

import com.sun.cacao.common.instrum.InstrumConfiguration;
import com.sun.cacao.common.instrum.InstrumStatsMBean;

public class InstrumStats
implements InstrumStatsMBean {
    private Object synch = new Integer(3);
    private long succeedRequest;
    private long failedRequest;
    private long abortedRequest;
    private long totalDuration;
    private int numberOfTotalDurationReset;
    private long maxDuration;
    private long minDuration;

    public InstrumStats() {
        this.resetValues();
    }

    private void resetValues() {
        this.succeedRequest = 0L;
        this.abortedRequest = 0L;
        this.failedRequest = 0L;
        this.totalDuration = 0L;
        this.numberOfTotalDurationReset = 0;
        this.maxDuration = 0L;
        this.minDuration = 0L;
    }

    public long getOperationsCount() {
        return this.succeedRequest;
    }

    public long getFailedOperationsCount() {
        return this.failedRequest;
    }

    public long getAbortedOperationsCount() {
        return this.abortedRequest;
    }

    public long getOperationsDurationTime() {
        return this.totalDuration;
    }

    public long getOperationsAverageDurationTime() {
        if (this.succeedRequest != 0L) {
            return this.totalDuration / this.succeedRequest;
        }
        return 0L;
    }

    public long getOperationsMinDurationTime() {
        return this.minDuration;
    }

    public long getOperationsMaxDurationTime() {
        return this.maxDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        if (!InstrumConfiguration.isInstrumActivated()) {
            return;
        }
        Object object = this.synch;
        synchronized (object) {
            this.resetValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimes(long l) {
        if (!InstrumConfiguration.isInstrumActivated()) {
            return;
        }
        Object object = this.synch;
        synchronized (object) {
            if (l <= 0L) {
                return;
            }
            if (this.minDuration == 0L || l < this.minDuration) {
                this.minDuration = l;
            }
            if (this.maxDuration == 0L || l > this.maxDuration) {
                this.maxDuration = l;
            }
            this.totalDuration += l;
            if (this.totalDuration < 0L) {
                ++this.numberOfTotalDurationReset;
                this.totalDuration = l + this.totalDuration;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrNumberOfOperations() {
        if (!InstrumConfiguration.isInstrumActivated()) {
            return;
        }
        Object object = this.synch;
        synchronized (object) {
            ++this.succeedRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrNumberOfOperations(long l) {
        if (!InstrumConfiguration.isInstrumActivated()) {
            return;
        }
        Object object = this.synch;
        synchronized (object) {
            this.succeedRequest += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrNumberOfFailedOperations() {
        if (!InstrumConfiguration.isInstrumActivated()) {
            return;
        }
        Object object = this.synch;
        synchronized (object) {
            ++this.failedRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrNumberOfFailedOperations(long l) {
        if (!InstrumConfiguration.isInstrumActivated()) {
            return;
        }
        Object object = this.synch;
        synchronized (object) {
            this.failedRequest += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrNumberOfAbortedOperations() {
        if (!InstrumConfiguration.isInstrumActivated()) {
            return;
        }
        Object object = this.synch;
        synchronized (object) {
            ++this.abortedRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrNumberOfAbortedOperations(long l) {
        if (!InstrumConfiguration.isInstrumActivated()) {
            return;
        }
        Object object = this.synch;
        synchronized (object) {
            this.abortedRequest += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeStats(InstrumStats instrumStats) {
        if (!InstrumConfiguration.isInstrumActivated()) {
            return;
        }
        Object object = this.synch;
        synchronized (object) {
            this.abortedRequest += instrumStats.abortedRequest;
            this.failedRequest += instrumStats.failedRequest;
            this.succeedRequest += instrumStats.succeedRequest;
            this.totalDuration += instrumStats.totalDuration;
            this.numberOfTotalDurationReset += instrumStats.numberOfTotalDurationReset;
            if (instrumStats.maxDuration > this.maxDuration) {
                this.maxDuration = instrumStats.maxDuration;
            }
            if (this.minDuration == 0L) {
                this.minDuration = instrumStats.minDuration;
            } else if (instrumStats.minDuration != 0L && instrumStats.minDuration < this.minDuration) {
                this.minDuration = instrumStats.minDuration;
            }
        }
    }
}

