/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.common.instrum;

import com.sun.cacao.common.instrum.InstrumTimes;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class InstrumLoggingFileFormater
extends SimpleFormatter {
    private static String[] strLevel = new String[]{"ALL    ", "CONFIG ", "FINE   ", "FINER  ", "FINEST ", "INFO   ", "OFF    ", "SEVERE ", "WARNING", "UNKNOWN"};
    private static Map taggedName = new HashMap();
    static final int LEVEL_ALL_VALUE = Level.ALL.intValue();
    static final int LEVEL_CONFIG_VALUE = Level.CONFIG.intValue();
    static final int LEVEL_FINE_VALUE = Level.FINE.intValue();
    static final int LEVEL_FINER_VALUE = Level.FINER.intValue();
    static final int LEVEL_FINEST_VALUE = Level.FINEST.intValue();
    static final int LEVEL_INFO_VALUE = Level.INFO.intValue();
    static final int LEVEL_OFF_VALUE = Level.OFF.intValue();
    static final int LEVEL_SEVERE_VALUE = Level.SEVERE.intValue();
    static final int LEVEL_WARNING_VALUE = Level.WARNING.intValue();
    private static final short LOGGER_TAG_PADDING = 40;

    private String levelToPaddedStr(Level level) {
        int n = level.intValue();
        if (n == LEVEL_ALL_VALUE) {
            return strLevel[0];
        }
        if (n == LEVEL_CONFIG_VALUE) {
            return strLevel[1];
        }
        if (n == LEVEL_FINE_VALUE) {
            return strLevel[2];
        }
        if (n == LEVEL_FINER_VALUE) {
            return strLevel[3];
        }
        if (n == LEVEL_FINEST_VALUE) {
            return strLevel[4];
        }
        if (n == LEVEL_INFO_VALUE) {
            return strLevel[5];
        }
        if (n == LEVEL_OFF_VALUE) {
            return strLevel[6];
        }
        if (n == LEVEL_SEVERE_VALUE) {
            return strLevel[7];
        }
        if (n == LEVEL_WARNING_VALUE) {
            return strLevel[8];
        }
        return strLevel[9];
    }

    private String formatLoggerTag(String string) {
        int n = 40 - string.length();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.replace('.', ' ').toUpperCase();
        if (n < 0) {
            stringBuffer.append(string2.substring(0, 39));
        } else {
            stringBuffer.append(string2);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTaggedName(String string) {
        String string2 = null;
        Map map = taggedName;
        synchronized (map) {
            if (taggedName.containsKey(string)) {
                return (String)taggedName.get(string);
            }
            if (string.compareTo("com.sun.cacao.instrum") <= 0) {
                taggedName.put(string, string);
                return string;
            }
            string2 = this.formatLoggerTag(string.substring("com.sun.cacao.instrum".length() + 1, string.length()));
            taggedName.put(string, string2);
            return string2;
        }
    }

    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(InstrumTimes.formatTime(logRecord.getMillis()));
        stringBuffer.append(">>");
        stringBuffer.append(this.levelToPaddedStr(logRecord.getLevel()));
        stringBuffer.append(">>");
        String string = logRecord.getLoggerName();
        if (string != null) {
            stringBuffer.append(this.getTaggedName(string));
        } else {
            stringBuffer.append("Unknown");
        }
        stringBuffer.append(">>");
        stringBuffer.append(logRecord.getMessage());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

