/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.common.instrum;

import com.sun.cacao.common.instrum.InstrumConfiguration;
import com.sun.cacao.common.instrum.InstrumForwarderStatsMBean;
import com.sun.cacao.common.instrum.InstrumStats;
import java.util.HashSet;
import java.util.Set;

public class InstrumForwarderStats
extends InstrumStats
implements InstrumForwarderStatsMBean {
    protected Set connections;
    private int failedConnections = 0;
    private int failedAuthentication = 0;
    private Object failedAuthenticationSynch = new Integer(1);

    public InstrumForwarderStats() {
        this.connections = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionAdd(String string) {
        if (InstrumConfiguration.isInstrumActivated()) {
            Set set = this.connections;
            synchronized (set) {
                this.connections.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionRemove(String string) {
        if (InstrumConfiguration.isInstrumActivated()) {
            Set set = this.connections;
            synchronized (set) {
                this.connections.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrFailedConnections(int n) {
        if (InstrumConfiguration.isInstrumActivated()) {
            Set set = this.connections;
            synchronized (set) {
                this.failedConnections += n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getConnections() {
        if (InstrumConfiguration.isInstrumActivated()) {
            Set set = this.connections;
            synchronized (set) {
                if (this.connections.size() > 0) {
                    return this.connections.toArray();
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsCount() {
        Set set = this.connections;
        synchronized (set) {
            return this.connections.size();
        }
    }

    public int getFailedConnectionsCount() {
        return this.failedConnections;
    }

    public int getAuthenticationFailureCount() {
        return this.failedAuthentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrAuthenticationFailure(int n) {
        if (InstrumConfiguration.isInstrumActivated()) {
            Object object = this.failedAuthenticationSynch;
            synchronized (object) {
                this.failedAuthentication += n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        super.resetStats();
        Object object = this.connections;
        synchronized (object) {
            this.failedConnections = 0;
        }
        object = this.failedAuthenticationSynch;
        synchronized (object) {
            this.failedAuthentication = 0;
        }
    }
}

