/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent.trust;

import com.sun.cacao.agent.JmxClient;
import com.sun.cacao.invocation.InvocationException;
import com.sun.cacao.invocation.InvocationStatus;
import com.sun.cacao.invocation.InvokeCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.logging.Logger;
import sun.misc.BASE64Encoder;

public class TrustUtils {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent.trust");
    private static final String RFC1421_HEADER = "-----BEGIN CERTIFICATE-----";
    private static final String RFC1421_FOOTER = "-----END CERTIFICATE-----";
    private static final String RFC1421_NEWLINE = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadTrustStore() throws IOException, GeneralSecurityException {
        char[] cArray = JmxClient.getStringParameter(null, "com.sun.cacao.ssl.truststore.password").toCharArray();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        String string = "com.sun.cacao.ssl.truststore.file";
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(JmxClient.getStringParameter(null, string));
            keyStore.load(fileInputStream, cArray);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTrustStore(KeyStore keyStore) throws IOException, GeneralSecurityException {
        char[] cArray = JmxClient.getStringParameter(null, "com.sun.cacao.ssl.truststore.password").toCharArray();
        File file = File.createTempFile("cacao-truststore-", ".tmp");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            keyStore.store(fileOutputStream, cArray);
        }
        finally {
            fileOutputStream.close();
        }
        String string = JmxClient.getStringParameter(null, "com.sun.cacao.ssl.truststore.file");
        String[] stringArray = new String[]{"/bin/cp", file.getAbsolutePath(), string};
        InvocationStatus invocationStatus = null;
        try {
            invocationStatus = InvokeCommand.execute(stringArray, null);
        }
        catch (InvocationException invocationException) {
            invocationStatus = invocationException.getInvocationStatusArray()[0];
            logger.info("truststore copy command failed : exception -> [" + invocationException.getMessage() + "], " + "stdout -> [" + invocationStatus.getStdout() + "], " + "stderr -> [" + invocationStatus.getStderr() + "]");
        }
        finally {
            file.delete();
        }
        Integer n = invocationStatus.getExitValue();
        if (n == null || n != 0) {
            throw new IOException("system command to replace truststore failed : stdout -> [" + invocationStatus.getStdout() + "], " + "stderr -> [" + invocationStatus.getStderr() + "]");
        }
    }

    public static String encodeRFC1421(Certificate certificate) throws CertificateEncodingException {
        return "-----BEGIN CERTIFICATE-----\r\n" + TrustUtils.encodeBase64(certificate) + RFC1421_NEWLINE + RFC1421_FOOTER + RFC1421_NEWLINE;
    }

    private static String encodeBase64(Certificate certificate) throws CertificateEncodingException {
        return new BASE64Encoder().encode(certificate.getEncoded());
    }
}

