/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent.trust;

import com.sun.cacao.agent.trust.CacaoTrustStoreMBean;
import com.sun.cacao.agent.trust.TrustUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacaoTrustStore
implements CacaoTrustStoreMBean {
    private static Logger logger = Logger.getLogger("com.sun.cacao");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertificate(String string, String string2) throws IOException, CertificateException, GeneralSecurityException {
        Certificate certificate;
        Object object;
        Object object2;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("adding a trusted certificate under alias [" + string + "]...");
        }
        try {
            object2 = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            object = CertificateFactory.getInstance("X.509");
            certificate = ((CertificateFactory)object).generateCertificate((InputStream)object2);
            ((ByteArrayInputStream)object2).close();
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Certificate problem", exception);
            }
            throw new CertificateException(exception.getMessage());
        }
        try {
            object2 = this;
            synchronized (object2) {
                object = TrustUtils.loadTrustStore();
                if (((KeyStore)object).containsAlias(string)) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Entry [" + string + "] already exists -> throw exception");
                    }
                    throw new IllegalArgumentException("Entry [" + string + "] already exists");
                }
                ((KeyStore)object).setCertificateEntry(string, certificate);
                TrustUtils.saveTrustStore((KeyStore)object);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("trusted certificate added under alias [" + string + "]");
                }
            }
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "i/o or format problem", iOException);
            }
            throw iOException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cannot read/write certificate(s)", generalSecurityException);
            }
            throw generalSecurityException;
        }
    }

    public Map getCertificates() throws IOException, GeneralSecurityException {
        try {
            KeyStore keyStore = TrustUtils.loadTrustStore();
            Enumeration<String> enumeration = keyStore.aliases();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                Certificate certificate = keyStore.getCertificate(string);
                hashMap.put(string, TrustUtils.encodeRFC1421(certificate));
            }
            return hashMap;
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "i/o or format problem", iOException);
            }
            throw iOException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cannot read certificate", generalSecurityException);
            }
            throw generalSecurityException;
        }
    }
}

