/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent.trust;

import com.sun.cacao.agent.JmxClient;
import com.sun.cacao.agent.trust.TrustUtils;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CacaoTrustManager
implements X509TrustManager {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent.trust");
    private X509TrustManager[] tms = null;
    private long lastModifDate = 0L;
    private boolean initialized = false;
    private X509Certificate[] acceptedIssuers = null;

    public synchronized void init() throws IOException, GeneralSecurityException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("cacao trust manager initializing...");
        }
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.lastModifDate = this.getTrustStoreLastModified();
        this.tms = this.createTrustManagers();
        this.initialized = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("cacao trust manager initialized");
        }
    }

    public synchronized X509Certificate[] getAcceptedIssuers() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("processing request to return accepted CAs...");
        }
        this.reloadTrustStore();
        if (this.acceptedIssuers == null) {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            if (this.tms != null) {
                for (int i = 0; i < this.tms.length; ++i) {
                    X509Certificate[] x509CertificateArray = this.tms[i].getAcceptedIssuers();
                    if (x509CertificateArray == null) continue;
                    for (int j = 0; j < x509CertificateArray.length; ++j) {
                        arrayList.add(x509CertificateArray[j]);
                    }
                }
            }
            this.acceptedIssuers = arrayList.toArray(new X509Certificate[arrayList.size()]);
        }
        return this.acceptedIssuers;
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (string == null || x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("processing request to validate a client certificate...");
        }
        this.reloadTrustStore();
        if (this.tms != null) {
            for (int i = 0; i < this.tms.length; ++i) {
                try {
                    this.tms[i].checkClientTrusted(x509CertificateArray, string);
                    return;
                }
                catch (CertificateException certificateException) {
                    continue;
                }
            }
        }
        String string2 = x509CertificateArray[0] == null ? "null" : x509CertificateArray[0].getSubjectDN().getName();
        throw new CertificateException("no trust found for [" + string2 + "]");
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (string == null || x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("processing request to validate a server certificate...");
        }
        this.reloadTrustStore();
        if (this.tms != null) {
            for (int i = 0; i < this.tms.length; ++i) {
                try {
                    this.tms[i].checkServerTrusted(x509CertificateArray, string);
                    return;
                }
                catch (CertificateException certificateException) {
                    continue;
                }
            }
        }
        String string2 = x509CertificateArray[0] == null ? "null" : x509CertificateArray[0].getSubjectDN().getName();
        throw new CertificateException("no trust found for [" + string2 + "]");
    }

    private X509TrustManager[] createTrustManagers() throws IOException, GeneralSecurityException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(TrustUtils.loadTrustStore());
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        X509TrustManager[] x509TrustManagerArray = null;
        if (trustManagerArray != null) {
            x509TrustManagerArray = new X509TrustManager[trustManagerArray.length];
            for (int i = 0; i < x509TrustManagerArray.length; ++i) {
                x509TrustManagerArray[i] = (X509TrustManager)trustManagerArray[i];
            }
        }
        return x509TrustManagerArray;
    }

    private long getTrustStoreLastModified() {
        String string = JmxClient.getStringParameter(null, "com.sun.cacao.ssl.truststore.file");
        File file = new File(string);
        return file.lastModified();
    }

    private void reloadTrustStore() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized yet");
        }
        try {
            long l = this.getTrustStoreLastModified();
            if (l != this.lastModifDate) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("truststore modified, reloading...");
                }
                this.tms = this.createTrustManagers();
                this.lastModifDate = l;
                this.acceptedIssuers = null;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("truststore reloaded");
                }
            }
        }
        catch (Exception exception) {
            logger.warning("error while verifying/reloading truststore : " + exception.getMessage());
        }
    }
}

