/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent.auth;

import com.sun.cacao.agent.auth.CallbackInfo;
import com.sun.cacao.agent.auth.Credential;
import com.sun.cacao.agent.auth.Mechanism;
import com.sun.cacao.invocation.InvocationException;
import com.sun.cacao.invocation.InvokeCommand;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public abstract class SystemMechanism
implements Mechanism {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent.auth");

    public abstract String getName();

    public boolean isIdentityAsserted() {
        return false;
    }

    protected abstract void configurePrincipals(CallbackInfo var1, String[] var2, String[] var3) throws SecurityException;

    public CallbackInfo parse(String string, String string2, String[] stringArray, String[] stringArray2) throws SecurityException {
        Subject subject = new Subject();
        subject.getPublicCredentials().add(new Credential(string));
        subject.getPrivateCredentials().add(new Credential(string2));
        CallbackInfo callbackInfo = new CallbackInfo(subject, false);
        this.configurePrincipals(callbackInfo, stringArray, stringArray2);
        try {
            Subject.doAs(callbackInfo.getSubject(), new PrivilegedAction(){

                public Object run() {
                    try {
                        InvokeCommand.execute(new String[0], new String[0]);
                    }
                    catch (InvocationException invocationException) {
                        throw new SecurityException("unable to validate Subject :" + invocationException.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            logger.log(Level.FINE, "Authentication refused, caught exception", securityException);
            throw securityException;
        }
        return callbackInfo;
    }
}

