/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent.auth;

import com.sun.cacao.agent.auth.AccessControlActionEnum;
import com.sun.cacao.agent.auth.AccessControlDispatcher;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class SecureNotificationBroadcasterSupport
implements NotificationEmitter {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent.auth");
    private List listenerList = Collections.EMPTY_LIST;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Object object2 = this.lock;
        synchronized (object2) {
            ArrayList<ListenerInfo> arrayList = new ArrayList<ListenerInfo>(this.listenerList.size() + 1);
            arrayList.addAll(this.listenerList);
            arrayList.add(new ListenerInfo(notificationListener, notificationFilter, object));
            this.listenerList = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Object object = this.lock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList(this.listenerList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ListenerInfo listenerInfo = (ListenerInfo)arrayList.get(i);
                if (listenerInfo.listener != notificationListener) continue;
                arrayList.remove(i);
            }
            if (arrayList.size() == this.listenerList.size()) {
                throw new ListenerNotFoundException("Listener not registered");
            }
            this.listenerList = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        boolean bl = false;
        Object object2 = this.lock;
        synchronized (object2) {
            ArrayList arrayList = new ArrayList(this.listenerList);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ListenerInfo listenerInfo = (ListenerInfo)arrayList.get(i);
                if (listenerInfo.listener != notificationListener) continue;
                bl = true;
                if (listenerInfo.filter != notificationFilter || listenerInfo.handback != object) continue;
                arrayList.remove(i);
                this.listenerList = arrayList;
                return;
            }
        }
        if (bl) {
            throw new ListenerNotFoundException("Listener not registered with this filter and handback");
        }
        throw new ListenerNotFoundException("Listener not registered");
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Notification notification) {
        List list;
        if (notification == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            list = this.listenerList;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ListenerInfo listenerInfo = (ListenerInfo)list.get(i);
            if (listenerInfo.filter != null && !listenerInfo.filter.isNotificationEnabled(notification)) continue;
            try {
                if (notification.getSource() != null && notification.getSource() instanceof ObjectName) {
                    final ObjectName objectName = (ObjectName)notification.getSource();
                    Subject.doAs(listenerInfo.subject, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            AccessControlDispatcher.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.ADD_NOTIFICATION_LISTENER);
                            return null;
                        }
                    });
                }
                this.handleNotification(listenerInfo.listener, notification, listenerInfo.handback);
                continue;
            }
            catch (SecurityException securityException) {
                logger.fine("Not sending notification to target for security reasons : " + notification);
                continue;
            }
            catch (Exception exception) {
                logger.fine("sendNotification: exception from listener: " + exception);
            }
        }
    }

    protected void handleNotification(NotificationListener notificationListener, Notification notification, Object object) {
        notificationListener.handleNotification(notification, object);
    }

    private static class ListenerInfo {
        public NotificationListener listener;
        NotificationFilter filter;
        Object handback;
        Subject subject;

        public ListenerInfo(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
            Subject subject;
            this.listener = notificationListener;
            this.filter = notificationFilter;
            this.handback = object;
            AccessControlContext accessControlContext = AccessController.getContext();
            this.subject = subject = Subject.getSubject(accessControlContext);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ListenerInfo)) {
                return false;
            }
            return this.listener == ((ListenerInfo)object).listener;
        }

        public int hashCode() {
            return this.listener.hashCode() + 1;
        }
    }
}

