/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent.auth;

import com.sun.cacao.agent.auth.AccessControlActionEnum;
import com.sun.cacao.agent.auth.AccessControlDispatcher;
import com.sun.cacao.agent.auth.AccessController;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class RootAccessController
implements AccessController {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent.auth");
    private static Set readActions = new HashSet();
    private Map principalCache = new WeakHashMap();

    public RootAccessController() {
        readActions.add("getAttribute");
        readActions.add("getClassLoader");
        readActions.add("getClassLoaderFor");
        readActions.add("getClassLoaderRepository");
        readActions.add("getDomains");
        readActions.add("getMBeanInfo");
        readActions.add("getObjectInstance");
        readActions.add("isInstanceOf");
        readActions.add("queryMBeans");
        readActions.add("queryNames");
    }

    public boolean checkMBeanPermission(Principal principal, ClassLoader classLoader, String string, String string2, ObjectName objectName, AccessControlActionEnum accessControlActionEnum) throws SecurityException {
        Boolean bl = (Boolean)this.principalCache.get(principal);
        if (bl == null) {
            bl = this.isRoot(principal.getName());
            this.principalCache.put(principal, bl);
        }
        Properties properties = null;
        try {
            properties = AccessControlDispatcher.getPropertiesForClass(string, "rootacl", classLoader);
        }
        catch (Exception exception) {
            logger.log(Level.FINER, "root authorization failure - cannot find properties for : " + string, exception);
            return false;
        }
        String string3 = accessControlActionEnum.toString();
        if (properties == null) {
            if (bl.booleanValue()) {
                return true;
            }
            boolean bl2 = readActions.contains(string3);
            return bl2;
        }
        String string4 = null;
        if (string2 != null) {
            string4 = properties.getProperty(string3 + "." + string2);
        }
        if (string4 == null) {
            string4 = properties.getProperty(string3);
        }
        if (string4 == null) {
            return false;
        }
        if ("root".equals(string4 = string4.trim())) {
            if (bl.booleanValue()) {
                return true;
            }
            throw new SecurityException("User must be root to perform action '" + string3 + "'");
        }
        if ("any".equals(string4)) {
            return true;
        }
        if ("none".equals(string4)) {
            throw new SecurityException("User does not have rights to perform action '" + string3 + "'");
        }
        String string5 = "Unrecognised ROOT property valuefor :" + string + " : " + accessControlActionEnum + " : " + string2;
        logger.warning(string5);
        throw new SecurityException(string5);
    }

    private native boolean isRoot(String var1);
}

