/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent.auth;

import com.sun.cacao.agent.auth.CallbackInfo;
import com.sun.cacao.agent.auth.Mechanism;
import com.sun.jdmk.security.sasl.AuthenticateCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;

public class CacaoCallbackHandler
implements CallbackHandler {
    public static final String SEPARATOR = "\u0001";
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent.auth");
    private static ThreadLocal threadLocal = new ThreadLocal();
    private static Map mechanisms = new HashMap();

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Object object;
            if (callbackArray[i] instanceof AuthenticateCallback) {
                object = (AuthenticateCallback)callbackArray[i];
                String string = object.getAuthenticationID();
                char[] cArray = object.getPassword();
                String string2 = new String(cArray);
                for (int j = 0; j < cArray.length; ++j) {
                    cArray[j] = 32;
                }
                cArray = null;
                object.setAuthenticated(false);
                if (string != null && string2 != null) {
                    String[] stringArray = this.toArray(string, SEPARATOR);
                    String[] stringArray2 = this.toArray(string2, SEPARATOR);
                    Mechanism mechanism = (Mechanism)mechanisms.get(stringArray[0]);
                    CallbackInfo callbackInfo = null;
                    if (mechanism == null) {
                        logger.fine("Unrecognised mechanism: " + stringArray[0]);
                        return;
                    }
                    callbackInfo = mechanism.parse(string, string2, stringArray, stringArray2);
                    if (mechanism.isIdentityAsserted() != callbackInfo.isIdentityAsserted()) {
                        logger.info("Inconsistency between Mechanism and CallbackInfo: Mechanism identity assertion is " + mechanism.isIdentityAsserted() + " and CallbackInfo identity assertion is " + callbackInfo.isIdentityAsserted());
                    }
                    object.setAuthenticated(true);
                    CacaoCallbackHandler.setThreadLocalCallbackInfo(callbackInfo);
                    continue;
                }
                throw new SecurityException("username or password is null");
            }
            if (callbackArray[i] instanceof AuthorizeCallback) {
                object = (AuthorizeCallback)callbackArray[i];
                ((AuthorizeCallback)object).setAuthorizedID(((AuthorizeCallback)object).getAuthorizationID());
                ((AuthorizeCallback)object).setAuthorized(true);
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i]);
        }
    }

    public static CallbackInfo getThreadLocalCallbackInfo() {
        return (CallbackInfo)threadLocal.get();
    }

    public static void setThreadLocalCallbackInfo(CallbackInfo callbackInfo) {
        threadLocal.set(callbackInfo);
    }

    public static Map getMechanisms() {
        return mechanisms;
    }

    private String[] toArray(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }
}

