/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent.auth;

import com.sun.cacao.agent.auth.AccessControlActionEnum;
import com.sun.cacao.agent.auth.AccessControlDispatcher;
import com.sun.cacao.agent.auth.CallbackInfo;
import com.sun.cacao.agent.auth.Credential;
import com.sun.cacao.agent.auth.Mechanism;
import com.sun.cacao.agent.auth.UserPrincipal;
import javax.security.auth.Subject;

public class AssertMechanism
implements Mechanism {
    private static String password = null;
    public static final String MECHANISM_NAME = "com.sun.cacao.assert";

    public static void setPassword(String string) {
        password = string;
    }

    public boolean isIdentityAsserted() {
        return true;
    }

    public String getName() {
        return MECHANISM_NAME;
    }

    public CallbackInfo parse(String string, String string2, String[] stringArray, String[] stringArray2) throws SecurityException {
        if (stringArray.length != 2 || stringArray2.length != 1) {
            throw new SecurityException("invalid user credentials");
        }
        try {
            Subject subject = AssertMechanism.createSubject(stringArray[1], true);
            CallbackInfo callbackInfo = new CallbackInfo(subject, true);
            return callbackInfo;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SecurityException("Invalid username");
        }
    }

    public static Subject createSubject(String string, boolean bl) {
        if (AssertMechanism.getUid(string) == -1L) {
            throw new IllegalArgumentException("unknown username");
        }
        Subject subject = new Subject();
        if (bl) {
            subject.getPrincipals().add(new UserPrincipal(string));
        }
        subject.getPublicCredentials().add(new Credential(AssertMechanism.encodeAuthenticationId(string)));
        subject.getPrivateCredentials().add(new Credential(AssertMechanism.encodePassword(AssertMechanism.getPassword())));
        return subject;
    }

    private static native long getUid(String var0);

    public static String encodeAuthenticationId(String string) {
        return "com.sun.cacao.assert\u0001" + string;
    }

    public static String getPassword() {
        AccessControlDispatcher.checkMBeanPermission(AssertMechanism.class.getClassLoader(), AssertMechanism.class.getName(), "obtainPassword", null, AccessControlActionEnum.INVOKE);
        return password;
    }

    public static String encodePassword(String string) {
        return string;
    }
}

