/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent.auth;

import com.sun.cacao.agent.DispatchInterceptor;
import com.sun.cacao.agent.auth.AccessControlActionEnum;
import com.sun.cacao.agent.auth.AccessController;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlContext;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AccessControlDispatcher {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent.auth");
    private static Map principalMap = new HashMap();
    private static Map classLoaderMap = new WeakHashMap();

    public static Map getPrincipalMap() {
        return principalMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMBeanPermission(ClassLoader classLoader, String string, String string2, ObjectName objectName, AccessControlActionEnum accessControlActionEnum) throws SecurityException {
        if (objectName == null) {
            return;
        }
        AccessControlContext accessControlContext = java.security.AccessController.getContext();
        Subject subject = Subject.getSubject(accessControlContext);
        if (subject == null) {
            return;
        }
        try {
            if (string == null) {
                string = DispatchInterceptor.internalGetMBeanInfo(objectName).getClassName();
                if (classLoader == null) {
                    classLoader = DispatchInterceptor.internalGetClassLoaderFor(objectName);
                }
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "caught exception doing security on " + objectName + " : " + accessControlActionEnum, throwable);
            SecurityException securityException = new SecurityException("security lookup problem ");
            securityException.initCause(throwable);
            throw securityException;
        }
        Set<Principal> set = subject.getPrincipals();
        Iterator<Principal> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map map;
            Principal principal = iterator.next();
            Map map2 = map = AccessControlDispatcher.getPrincipalMap();
            synchronized (map2) {
                LinkedList linkedList = (LinkedList)map.get(principal.getClass());
                if (linkedList != null) {
                    try {
                        Iterator iterator2 = linkedList.iterator();
                        while (iterator2.hasNext()) {
                            AccessController accessController = (AccessController)iterator2.next();
                            if (!accessController.checkMBeanPermission(principal, classLoader, string, string2, objectName, accessControlActionEnum)) continue;
                            return;
                        }
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }
        }
        throw new SecurityException("permission not granted");
    }

    public static Properties getPropertiesForClass(String string, String string2, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        HashMap<String, Properties> hashMap = (HashMap<String, Properties>)classLoaderMap.get(classLoader);
        Properties properties = null;
        String string3 = string + string2;
        if (hashMap != null && (properties = (Properties)hashMap.get(string3)) == null && hashMap.containsKey(string3)) {
            return null;
        }
        if (properties == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.fine("Unable to find class named : " + string);
                return null;
            }
            InputStream inputStream = null;
            while (inputStream == null) {
                String string4 = clazz.getName().replace('.', System.getProperty("file.separator").charAt(0)) + "." + string2 + ".properties";
                try {
                    inputStream = classLoader.getResourceAsStream(string4);
                }
                catch (Exception exception) {
                    inputStream = null;
                }
                if (inputStream != null || (clazz = clazz.getSuperclass()) != null) continue;
                break;
            }
            if (inputStream != null) {
                properties = new Properties();
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    logger.warning("IOException reading " + string2 + " properties file " + "for class: " + string);
                    return null;
                }
            }
            if (hashMap != null) {
                hashMap.put(string3, properties);
            } else {
                hashMap = new HashMap<String, Properties>();
                hashMap.put(string3, properties);
                classLoaderMap.put(classLoader, hashMap);
            }
        }
        return properties;
    }
}

