/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent;

import com.sun.cacao.ObjectNameFactoryInterface;
import com.sun.cacao.agent.VirtualMBeanDomainDispatcher;
import com.sun.cacao.agent.VirtualMBeanInterceptorMBean;
import com.sun.cacao.agent.auth.AccessControlDispatcher;
import com.sun.cacao.element.ElementSupport;
import com.sun.jdmk.JdmkMBeanServer;
import com.sun.jdmk.interceptor.MBeanServerInterceptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.StandardMBean;

public abstract class VirtualMBeanInterceptor
extends ElementSupport
implements MBeanServerInterceptor,
VirtualMBeanInterceptorMBean {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent");
    private static final String logTag = "VirtualMBeanInterceptor";
    private final MBeanInfo mbInfo;
    private ObjectName myObjectName = null;
    private Set attributeNamesSet;
    private final MBeanServerDelegate forwarder;
    private final Class mBeanInterface;
    private final ObjectNameFactoryInterface objectNameFactory;
    private final VirtualMBeanDomainDispatcher dispatcher;
    private static final String DESC = "desc";
    private static final String DESC_ATTR = "desc.attribute.";
    private static final String DESC_OP = "desc.operation.";
    private static final String DESC_ATTR_TEXT = "VirtualMBean attribute exposed for management";
    private static final String DESC_OP_TEXT = "VirtualMBean operation exposed for management";
    private static final String DESC_CLASS_TEXT = "VirtualMBean exposed for management";

    public ObjectNameFactoryInterface getObjectNameFactory() {
        return this.objectNameFactory;
    }

    private void checkInitialization() throws IllegalArgumentException {
        if (this.forwarder == null) {
            throw new IllegalArgumentException("Bad initialization: MBeanServerDelegate must not be null.");
        }
    }

    private final synchronized MBeanServerDelegate forwarder() {
        return this.forwarder;
    }

    public String getMBeanClassName() {
        return this.getClass().getName();
    }

    private final void sendMBeanServerNotifications(String string) {
        String[] stringArray = this.getInstances();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                ObjectName objectName = this.objectNameFactory.getObjectName(this.getMBeanInterface(), stringArray[i]);
                ObjectName objectName2 = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                MBeanServerNotification mBeanServerNotification = new MBeanServerNotification(string, (Object)objectName2, 0L, objectName);
                MBeanServerDelegate mBeanServerDelegate = this.forwarder();
                mBeanServerDelegate.sendNotification(mBeanServerNotification);
                continue;
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "caught exception", exception);
            }
        }
    }

    public Class getMBeanInterface() {
        return this.mBeanInterface;
    }

    public VirtualMBeanInterceptor(VirtualMBeanDomainDispatcher virtualMBeanDomainDispatcher, Class clazz) {
        super(null);
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        int n;
        this.forwarder = ((JdmkMBeanServer)virtualMBeanDomainDispatcher.getMBeanServer()).getMBeanServerDelegate();
        this.dispatcher = virtualMBeanDomainDispatcher;
        this.objectNameFactory = virtualMBeanDomainDispatcher.getObjectNameFactory();
        this.mBeanInterface = clazz;
        this.checkInitialization();
        Method[] methodArray = null;
        try {
            methodArray = clazz.getMethods();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "caught exception", exception);
        }
        Properties properties = AccessControlDispatcher.getPropertiesForClass(this.getClass().getName(), "description", this.getClass().getClassLoader());
        if (properties == null) {
            properties = new Properties();
        }
        ArrayList<MBeanAttributeInfo> arrayList = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanOperationInfo> arrayList2 = new ArrayList<MBeanOperationInfo>();
        this.attributeNamesSet = new HashSet();
        for (n = 0; n < methodArray.length; ++n) {
            String string;
            MBeanParameterInfo[] mBeanParameterInfoArray;
            mBeanAttributeInfoArray = methodArray[n].getName();
            Class<?>[] classArray = methodArray[n].getParameterTypes();
            Class<?> clazz2 = methodArray[n].getReturnType();
            if (mBeanAttributeInfoArray.startsWith("get") && mBeanAttributeInfoArray.length() > 3 && classArray.length == 0 && !clazz2.equals(Void.TYPE)) {
                mBeanParameterInfoArray = mBeanAttributeInfoArray.substring(3);
                string = properties.getProperty(DESC_ATTR + (String)mBeanParameterInfoArray, DESC_ATTR_TEXT);
                arrayList.add(new MBeanAttributeInfo((String)mBeanParameterInfoArray, clazz2.getName(), string, true, false, false));
                this.attributeNamesSet.add(mBeanParameterInfoArray);
                continue;
            }
            if (mBeanAttributeInfoArray.startsWith("is") && mBeanAttributeInfoArray.length() > 2 && classArray.length == 0 && clazz2.equals(Boolean.TYPE)) {
                mBeanParameterInfoArray = mBeanAttributeInfoArray.substring(2);
                string = properties.getProperty(DESC_ATTR + (String)mBeanParameterInfoArray, DESC_ATTR_TEXT);
                arrayList.add(new MBeanAttributeInfo((String)mBeanParameterInfoArray, clazz2.getName(), string, true, false, false));
                this.attributeNamesSet.add(mBeanParameterInfoArray);
                continue;
            }
            if (mBeanAttributeInfoArray.startsWith("set") && mBeanAttributeInfoArray.length() > 3 && classArray.length == 0 && !clazz2.equals(Void.TYPE)) {
                logger.severe("set operations are not supported");
                continue;
            }
            mBeanParameterInfoArray = new MBeanParameterInfo[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                String string2 = properties.getProperty(DESC_OP + (String)mBeanAttributeInfoArray + "." + i, "p" + (i + 1));
                String string3 = properties.getProperty(DESC_OP + (String)mBeanAttributeInfoArray + "." + string2);
                mBeanParameterInfoArray[i] = new MBeanParameterInfo(string2, classArray[i].getName(), string3);
            }
            string = properties.getProperty(DESC_OP + (String)mBeanAttributeInfoArray, DESC_OP_TEXT);
            arrayList2.add(new MBeanOperationInfo((String)mBeanAttributeInfoArray, string, mBeanParameterInfoArray, clazz2.getName(), 1));
        }
        n = arrayList.size();
        mBeanAttributeInfoArray = new MBeanAttributeInfo[n];
        for (int i = 0; i < n; ++i) {
            mBeanAttributeInfoArray[i] = (MBeanAttributeInfo)arrayList.get(i);
        }
        n = arrayList2.size();
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[n];
        for (int i = 0; i < n; ++i) {
            mBeanOperationInfoArray[i] = (MBeanOperationInfo)arrayList2.get(i);
        }
        String string = properties.getProperty(DESC, DESC_CLASS_TEXT);
        this.mbInfo = new MBeanInfo(this.getClass().getName(), string, mBeanAttributeInfoArray, null, mBeanOperationInfoArray, null);
    }

    public Map obtainBulkAttributes(String[] stringArray, QueryExp queryExp) {
        String[] stringArray2 = this.getInstances();
        if (stringArray2 == null) {
            return new HashMap();
        }
        if (stringArray == null) {
            stringArray = this.attributeNamesSet.toArray(new String[0]);
        }
        HashMap hashMap = new HashMap(stringArray2.length);
        for (int i = 0; i < stringArray2.length; ++i) {
            Serializable serializable;
            if (queryExp != null) {
                serializable = this.objectNameFactory.getObjectName(this.mBeanInterface, stringArray2[i]);
                try {
                    if (!queryExp.apply((ObjectName)serializable)) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                serializable = this.getAttributes(stringArray2[i], stringArray);
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>(((ArrayList)serializable).size());
                Iterator iterator = ((ArrayList)serializable).iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    hashMap2.put(attribute.getName(), attribute.getValue());
                }
                hashMap.put(stringArray2[i], hashMap2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashMap;
    }

    protected void start() {
        logger.entering(logTag, "start");
        this.dispatcher.addInterceptor(this);
        if (this.myObjectName == null) {
            this.myObjectName = this.objectNameFactory.getObjectName(VirtualMBeanInterceptor.class, this.getMBeanInterface().getName());
        }
        try {
            this.dispatcher.getMBeanServer().registerMBean(new StandardMBean(this, VirtualMBeanInterceptorMBean.class), this.myObjectName);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Unexpected exception registering MBean", exception);
        }
        this.sendMBeanServerNotifications("JMX.mbean.registered");
    }

    protected void stop() {
        logger.entering(logTag, "stop");
        if (this.myObjectName != null) {
            try {
                this.dispatcher.getMBeanServer().unregisterMBean(this.myObjectName);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Unexpected exception unregistering MBean", exception);
            }
            this.myObjectName = null;
        }
        this.dispatcher.removeInterceptor(this);
        this.sendMBeanServerNotifications("JMX.mbean.unregistered");
    }

    public abstract String[] getInstances();

    public final void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        throw new InstanceNotFoundException("No broadcaster by that name");
    }

    public final void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        throw new InstanceNotFoundException("No broadcaster by that name");
    }

    public final ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new MBeanRegistrationException(null, "Create MBean not allowed.");
    }

    public final ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new MBeanRegistrationException(null, "Create MBean not allowed.");
    }

    public final Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            if (string == null) {
                throw new AttributeNotFoundException("null");
            }
            AttributeList attributeList = this.getAttributes(objectName, new String[]{string});
            if (attributeList.isEmpty()) {
                throw new AttributeNotFoundException(string + " (returned attribute list was empty)");
            }
            if (attributeList.size() != 1) {
                throw new AttributeNotFoundException("Returned attribute expected to contain only one element, (" + attributeList.size() + " found)");
            }
            Attribute attribute = (Attribute)attributeList.get(0);
            if (!attribute.getName().equals(string)) {
                throw new AttributeNotFoundException(string + " (not found in the returned attribute list)");
            }
            return attribute.getValue();
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (Exception exception) {
            throw new MBeanException(exception, "Failed to get " + string);
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new InstanceNotFoundException("null");
        }
        try {
            return this.getAttributes(this.objectNameFactory.getInstanceName(objectName), stringArray);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "caught exception", iOException);
            return null;
        }
    }

    public abstract AttributeList getAttributes(String var1, String[] var2) throws InstanceNotFoundException, ReflectionException, IOException;

    public final ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.getClass().getClassLoader();
    }

    public final ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.getClass().getClassLoader();
    }

    public final String getDefaultDomain() {
        return null;
    }

    public final String[] getDomains() {
        Set set = this.queryNames(null, null);
        HashSet<String> hashSet = new HashSet<String>(1);
        String[] stringArray = set.iterator();
        while (stringArray.hasNext()) {
            ObjectName objectName = (ObjectName)stringArray.next();
            String string = objectName.getDomain();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
        }
        stringArray = new String[hashSet.size()];
        return hashSet.toArray(stringArray);
    }

    public final ClassLoader getMBeanClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.getClass().getClassLoader();
    }

    public Integer getMBeanCount() {
        return new Integer(this.queryNames(null, null).size());
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbInfo;
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new InstanceNotFoundException("null");
        }
        if (this.isRegistered(objectName)) {
            return new ObjectInstance(objectName, this.getMBeanClassName());
        }
        throw new InstanceNotFoundException(this.objectNameFactory.getInstanceName(objectName) + " not registered.");
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (objectName == null) {
            throw new InstanceNotFoundException("null");
        }
        if (this.isRegistered(objectName)) {
            try {
                return this.invoke(this.objectNameFactory.getInstanceName(objectName), string, objectArray, stringArray);
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "caught exception", iOException);
            }
        } else {
            throw new InstanceNotFoundException(this.objectNameFactory.getInstanceName(objectName) + " not registered.");
        }
        return null;
    }

    public abstract Object invoke(String var1, String var2, Object[] var3, String[] var4) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException;

    public final boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException("Mbean not registered : " + objectName);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, true, this.getClass().getClassLoader());
        }
        catch (Exception exception) {
            return false;
        }
        return clazz.isInstance(this);
    }

    public boolean isRegistered(ObjectName objectName) throws RuntimeOperationsException {
        try {
            return this.isRegistered(this.objectNameFactory.getInstanceName(objectName));
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "caught exception", iOException);
            return false;
        }
    }

    public abstract boolean isRegistered(String var1) throws IOException;

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        Set set = this.queryNames(objectName, queryExp);
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>(set.size());
        String string = this.getMBeanClassName();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            hashSet.add(new ObjectInstance(objectName2, string));
        }
        return hashSet;
    }

    public final Set queryNames(ObjectName objectName, QueryExp queryExp) {
        String[] stringArray = this.getInstances();
        if (stringArray == null) {
            return new HashSet();
        }
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            ObjectName objectName2 = this.objectNameFactory.getObjectName(this.mBeanInterface, stringArray[i]);
            if (objectName != null && !objectName.apply(objectName2)) continue;
            try {
                if (queryExp != null && !queryExp.apply(objectName2)) continue;
                hashSet.add(objectName2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashSet;
    }

    public final ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        throw new MBeanRegistrationException(null, "Register MBean not allowed.");
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new InstanceNotFoundException("No broadcaster by that name");
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new InstanceNotFoundException("No broadcaster by that name");
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new InstanceNotFoundException("No broadcaster by that name");
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new InstanceNotFoundException("No broadcaster by that name");
    }

    public final void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new MBeanException(null, "setAttribute() not allowed");
    }

    public final AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        throw new InstanceNotFoundException("setAttributes() not allowed");
    }

    public final void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        throw new MBeanRegistrationException(null, "Unregister MBean not allowed.");
    }
}

