/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent;

import com.sun.cacao.ObjectNameFactoryInterface;
import com.sun.cacao.agent.DispatchInterceptor;
import com.sun.cacao.agent.DomainDispatcher;
import com.sun.cacao.agent.VirtualMBeanInterceptor;
import com.sun.cacao.element.ElementSupport;
import com.sun.jdmk.JdmkMBeanServer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class VirtualMBeanDomainDispatcher
extends ElementSupport
implements DomainDispatcher {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent");
    private MBeanServer mbs;
    private String domain;
    private ObjectNameFactoryInterface objectNameFactory;
    private Map interceptors = new HashMap();

    public VirtualMBeanDomainDispatcher(MBeanServer mBeanServer, ObjectNameFactoryInterface objectNameFactoryInterface) {
        super(null);
        this.mbs = mBeanServer;
        this.domain = objectNameFactoryInterface.getDomain();
        this.objectNameFactory = objectNameFactoryInterface;
    }

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    protected void start() {
        logger.fine("starting virtualmbeandomain dispatcher - registering");
        DispatchInterceptor dispatchInterceptor = (DispatchInterceptor)((JdmkMBeanServer)this.mbs).getMBeanServerInterceptor();
        dispatchInterceptor.addDomainDispatcher(this);
    }

    protected void stop() {
        logger.fine("stopping virtualmbeandomain dispatcher - registering");
        DispatchInterceptor dispatchInterceptor = (DispatchInterceptor)((JdmkMBeanServer)this.mbs).getMBeanServerInterceptor();
        dispatchInterceptor.removeDomainDispatcher(this);
    }

    public Collection getInterceptors(ObjectName objectName) {
        if (objectName == null) {
            return this.interceptors.values();
        }
        String string = this.objectNameFactory.getTypeName(objectName);
        if (string == null || string.equals("*")) {
            return this.interceptors.values();
        }
        HashSet hashSet = new HashSet();
        VirtualMBeanInterceptor virtualMBeanInterceptor = (VirtualMBeanInterceptor)this.interceptors.get(string);
        if (virtualMBeanInterceptor != null) {
            hashSet.add(this.interceptors.get(string));
        }
        return hashSet;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectNameFactoryInterface getObjectNameFactory() {
        return this.objectNameFactory;
    }

    public VirtualMBeanInterceptor addInterceptor(VirtualMBeanInterceptor virtualMBeanInterceptor) {
        Class clazz = virtualMBeanInterceptor.getMBeanInterface();
        return this.interceptors.put(this.objectNameFactory.getTypeName(clazz), virtualMBeanInterceptor);
    }

    public VirtualMBeanInterceptor removeInterceptor(VirtualMBeanInterceptor virtualMBeanInterceptor) {
        ObjectNameFactoryInterface objectNameFactoryInterface = virtualMBeanInterceptor.getObjectNameFactory();
        String string = objectNameFactoryInterface.getDomain();
        if (!string.equals(this.domain)) {
            throw new IllegalArgumentException("Incompatible domain");
        }
        Class clazz = virtualMBeanInterceptor.getMBeanInterface();
        return (VirtualMBeanInterceptor)this.interceptors.remove(objectNameFactoryInterface.getTypeName(clazz));
    }
}

