/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent;

import com.sun.cacao.ObjectNameFactoryInterface;
import com.sun.cacao.agent.MBeanServerInvocationHandler;
import com.sun.cacao.agent.auth.AssertMechanism;
import com.sun.cacao.agent.auth.CacaoCallbackHandler;
import com.sun.cacao.agent.auth.Credential;
import com.sun.cacao.agent.auth.Mechanism;
import com.sun.cacao.agent.auth.RoleMechanism;
import com.sun.cacao.agent.auth.UserMechanism;
import com.sun.cacao.agent.trust.NoServerX509TrustManager;
import com.sun.cacao.agent.trust.TrustUtils;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.Subject;

public class JmxClient {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent");
    private static final String CACAO_PROPERTIES_FILE = "com.sun.cacao.properties.file";
    public static final String KEY_MANAGER_FACTORY_KEY = "com.sun.cacao.ssl.key.manager.factory";
    public static final String KEYSTORE_FILE_KEY = "com.sun.cacao.ssl.keystore.file";
    public static final String KEYSTORE_PASSWORD_KEY = "com.sun.cacao.ssl.keystore.password";
    public static final String KEYSTORE_PASSWORD_FILE_KEY = "com.sun.cacao.ssl.keystore.password.file";
    public static final String TRUST_MANAGER_FACTORY_KEY = "com.sun.cacao.ssl.trust.manager.factory";
    public static final String TRUST_MANAGER_ARRAY_KEY = "com.sun.cacao.ssl.trust.manager.array";
    public static final String TRUSTSTORE_FILE_KEY = "com.sun.cacao.ssl.truststore.file";
    public static final String TRUSTSTORE_PASSWORD_KEY = "com.sun.cacao.ssl.truststore.password";
    public static final String JMXMP_CONNECTOR_PORT = "com.sun.cacao.jmxmp.connector.port";
    public static final String INSECURE_HTML_ADAPTOR_PORT = "com.sun.cacao.insecure.html.adaptor.port";
    public static final String INSECURE_JMXMP_CONNECTOR_PORT = "com.sun.cacao.insecure.jmxmp.connector.port";
    public static final String CACAO_INSTANCE_NAME = "cacao.instance.name";
    private static final String CONTAINER_PROPERTIES_RESOURCE = "com/sun/cacao/container/Container.properties";
    public static final String JMXMP_PROTOCOL = "cacao-jmxmp";
    public static final String RMI_PROTOCOL = "cacao-rmi";
    public static final String SASLID_KEY = "saslid";
    public static final String SASLPASS_KEY = "saslpass";
    public static final String WELLKNOWN_KEY = "wellknown";
    public static final String TRUSTSERVER_KEY = "trustserver";
    public static final String USERNAME_KEY = "username";
    public static final String USERPASS_KEY = "userpass";
    public static final String ROLENAME_KEY = "rolename";
    public static final String ROLEPASS_KEY = "rolepass";
    public static final String BASE_MAP_KEY = "com.sun.cacao.";
    private static Map globalDefaultMap;

    public static JMXConnector getJmxClientConnection(String string, Map map) throws SecurityException, IOException {
        AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = Subject.getSubject(accessControlContext);
        if (subject == null) {
            throw new SecurityException("Cannot obtain Subject from thread context");
        }
        Set set = subject.getPublicCredentials(Credential.class);
        Set set2 = subject.getPrivateCredentials(Credential.class);
        if (set.size() != 1 || set2.size() != 1) {
            throw new SecurityException("Cannot get unique credentials");
        }
        String string2 = ((Credential)set.iterator().next()).getValue();
        String string3 = ((Credential)set2.iterator().next()).getValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\u0001");
        Mechanism mechanism = (Mechanism)CacaoCallbackHandler.getMechanisms().get(stringTokenizer.nextToken());
        if (mechanism == null) {
            throw new IllegalArgumentException("Invalid JAAS credentials");
        }
        if (mechanism.isIdentityAsserted()) {
            if (!map.containsKey(KEYSTORE_PASSWORD_KEY)) {
                map.put(KEYSTORE_PASSWORD_KEY, string3);
            }
            return JmxClient.getWellknownJmxClientConnection(string, map, string2, string3);
        }
        return JmxClient.getUnknownJmxClientConnection(string, map, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMXConnector getWellknownJmxClientConnection(String string, Map hashMap, String string2, String string3) throws SecurityException, IOException {
        int n = JmxClient.getIntParameter(hashMap, JMXMP_CONNECTOR_PORT);
        Object var5_5 = null;
        JMXServiceURL jMXServiceURL = new JMXServiceURL("service:jmx:jmxmp://" + string + ":" + n);
        try {
            Closeable closeable;
            Object object;
            Object object2;
            Object object3;
            String[] stringArray;
            Object object4;
            TrustManager[] trustManagerArray = null;
            if (hashMap != null && hashMap.containsKey(TRUST_MANAGER_ARRAY_KEY)) {
                try {
                    trustManagerArray = (TrustManager[])hashMap.get(TRUST_MANAGER_ARRAY_KEY);
                }
                catch (Exception exception) {
                    logger.warning("Unable to parse value in connectionEnv for com.sun.cacao.ssl.trust.manager.array : " + hashMap.get(TRUST_MANAGER_ARRAY_KEY));
                }
            } else {
                object4 = null;
                if (hashMap != null && hashMap.containsKey(TRUST_MANAGER_FACTORY_KEY)) {
                    try {
                        object4 = (TrustManagerFactory)hashMap.get(TRUST_MANAGER_FACTORY_KEY);
                    }
                    catch (Exception exception) {
                        logger.warning("Unable to parse value in connectionEnv for com.sun.cacao.ssl.trust.manager.factory : " + hashMap.get(TRUST_MANAGER_FACTORY_KEY));
                    }
                } else {
                    stringArray = JmxClient.getStringParameter(hashMap, TRUSTSTORE_FILE_KEY);
                    object3 = JmxClient.getStringParameter(hashMap, TRUSTSTORE_PASSWORD_KEY);
                    object2 = ((String)object3).toCharArray();
                    object = KeyStore.getInstance("JKS");
                    closeable = null;
                    try {
                        closeable = new FileInputStream((String)stringArray);
                        ((KeyStore)object).load((InputStream)closeable, (char[])object2);
                    }
                    catch (Exception exception) {
                        SecurityException securityException = new SecurityException("Unable to read truststore");
                        securityException.initCause(exception);
                        throw securityException;
                    }
                    finally {
                        if (closeable != null) {
                            ((FileInputStream)closeable).close();
                        }
                    }
                    object4 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    ((TrustManagerFactory)object4).init((KeyStore)object);
                }
                trustManagerArray = ((TrustManagerFactory)object4).getTrustManagers();
            }
            object4 = null;
            if (hashMap != null && hashMap.containsKey(KEY_MANAGER_FACTORY_KEY)) {
                try {
                    object4 = (KeyManagerFactory)hashMap.get(KEY_MANAGER_FACTORY_KEY);
                }
                catch (Exception exception) {
                    logger.warning("Unable to parse value in connectionEnv for com.sun.cacao.ssl.key.manager.factory : " + hashMap.get(KEY_MANAGER_FACTORY_KEY));
                }
            } else {
                stringArray = JmxClient.getStringParameter(hashMap, KEYSTORE_FILE_KEY);
                object3 = JmxClient.getStringParameter(hashMap, KEYSTORE_PASSWORD_KEY);
                if (object3 == null) {
                    object2 = JmxClient.getStringParameter(hashMap, KEYSTORE_PASSWORD_FILE_KEY);
                    object = null;
                    try {
                        object = new FileInputStream((String)object2);
                        closeable = new InputStreamReader((InputStream)object);
                        BufferedReader bufferedReader = new BufferedReader((Reader)closeable);
                        object3 = bufferedReader.readLine();
                    }
                    catch (Exception exception) {
                        SecurityException securityException = new SecurityException("Unable to read keystore");
                        securityException.initCause(exception);
                        throw securityException;
                    }
                    finally {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                }
                object2 = ((String)object3).toCharArray();
                object = KeyStore.getInstance("JKS");
                closeable = null;
                try {
                    closeable = new FileInputStream((String)stringArray);
                    ((KeyStore)object).load((InputStream)closeable, (char[])object2);
                }
                finally {
                    if (closeable != null) {
                        ((FileInputStream)closeable).close();
                    }
                }
                object4 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                ((KeyManagerFactory)object4).init((KeyStore)object, (char[])object2);
            }
            stringArray = new String[]{string2, string3};
            object3 = SSLContext.getInstance("TLSv1");
            ((SSLContext)object3).init(((KeyManagerFactory)object4).getKeyManagers(), trustManagerArray, null);
            object2 = ((SSLContext)object3).getSocketFactory();
            if (hashMap == null) {
                hashMap = new HashMap<String, char[]>();
            }
            hashMap.put("jmx.remote.tls.socket.factory", (char[])object2);
            hashMap.put("jmx.remote.profiles", (char[])"TLS SASL/PLAIN");
            hashMap.put("jmx.remote.credentials", (char[])stringArray);
            Security.addProvider(new com.sun.security.sasl.Provider());
            object = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
            return object;
        }
        catch (GeneralSecurityException generalSecurityException) {
            SecurityException securityException = new SecurityException("Unable to read credentials");
            securityException.initCause(generalSecurityException);
            throw securityException;
        }
    }

    public static JMXConnector getWellknownJmxClientConnection(String string, Map map, String string2) throws SecurityException, IOException {
        if (string2 == null) {
            string2 = System.getProperty("user.name", "root");
        }
        return JmxClient.getWellknownJmxClientConnection(string, map, AssertMechanism.encodeAuthenticationId(string2), "ignored");
    }

    public static final synchronized JMXConnector getUnknownJmxClientConnection(String string, String string2, String string3, String string4, String string5, Map map) throws SecurityException, IOException {
        String string6;
        String string7;
        if (string3 == null || string3.length() == 0) {
            if (string == null || string.length() == 0) {
                throw new SecurityException("Illegal anonymous access");
            }
            string7 = UserMechanism.encodeAuthenticationId(string);
            string6 = UserMechanism.encodePassword(string2);
        } else {
            string7 = RoleMechanism.encodeAuthenticationId(string, string3);
            string6 = RoleMechanism.encodePassword(string2, string4);
        }
        return JmxClient.getUnknownJmxClientConnection(string5, map, string7, string6);
    }

    public static final synchronized JMXConnector getUnknownJmxClientConnection(String string, Map hashMap, String string2, String string3) throws SecurityException, IOException {
        int n = JmxClient.getIntParameter(hashMap, JMXMP_CONNECTOR_PORT);
        Object var5_5 = null;
        JMXServiceURL jMXServiceURL = new JMXServiceURL("service:jmx:jmxmp://" + string + ":" + n);
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            TrustManager[] trustManagerArray = null;
            if (hashMap != null && hashMap.containsKey(TRUST_MANAGER_ARRAY_KEY)) {
                try {
                    trustManagerArray = (TrustManager[])hashMap.get(TRUST_MANAGER_ARRAY_KEY);
                }
                catch (Exception exception) {
                    logger.warning("Unable to parse value in connectionEnv for com.sun.cacao.ssl.trust.manager.array : " + hashMap.get(TRUST_MANAGER_ARRAY_KEY));
                }
            } else {
                object4 = null;
                if (hashMap != null && hashMap.containsKey(TRUST_MANAGER_FACTORY_KEY)) {
                    try {
                        object4 = (String[])hashMap.get(TRUST_MANAGER_FACTORY_KEY);
                    }
                    catch (Exception exception) {
                        logger.warning("Unable to parse value in connectionEnv for com.sun.cacao.ssl.trust.manager.factory : " + hashMap.get(TRUST_MANAGER_FACTORY_KEY));
                    }
                } else {
                    object3 = JmxClient.getStringParameter(hashMap, TRUSTSTORE_FILE_KEY);
                    object2 = JmxClient.getStringParameter(hashMap, TRUSTSTORE_PASSWORD_KEY);
                    object = ((String)object2).toCharArray();
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream((String)object3);
                        keyStore.load(fileInputStream, (char[])object);
                    }
                    catch (Exception exception) {
                        SecurityException securityException = new SecurityException("Unable to read truststore");
                        securityException.initCause(exception);
                        throw securityException;
                    }
                    finally {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    object4 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    ((TrustManagerFactory)object4).init(keyStore);
                }
                trustManagerArray = ((TrustManagerFactory)object4).getTrustManagers();
            }
            object4 = new String[]{string2, string3};
            object3 = SSLContext.getInstance("TLSv1");
            ((SSLContext)object3).init(null, trustManagerArray, null);
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            object2 = ((SSLContext)object3).getSocketFactory();
            hashMap.put("jmx.remote.tls.socket.factory", object2);
            hashMap.put("jmx.remote.profiles", "TLS SASL/PLAIN");
            hashMap.put("jmx.remote.credentials", object4);
            Security.addProvider(new com.sun.security.sasl.Provider());
            object = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
            return object;
        }
        catch (GeneralSecurityException generalSecurityException) {
            SecurityException securityException = new SecurityException("Unable to read credentials");
            securityException.initCause(generalSecurityException);
            throw securityException;
        }
    }

    public static Object getMBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectNameFactoryInterface objectNameFactoryInterface, Class clazz, String string, boolean bl) throws IOException {
        return JmxClient.getMBeanProxy(mBeanServerConnection, objectNameFactoryInterface, clazz, string, bl, false);
    }

    public static Object getMBeanSnapshotProxy(MBeanServerConnection mBeanServerConnection, ObjectNameFactoryInterface objectNameFactoryInterface, Class clazz, String string) throws IOException {
        return JmxClient.getMBeanProxy(mBeanServerConnection, objectNameFactoryInterface, clazz, string, false, true);
    }

    public static Object getMBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectNameFactoryInterface objectNameFactoryInterface, Class clazz, String string, boolean bl, boolean bl2) throws IOException {
        try {
            return JmxClient.getMBeanProxy(mBeanServerConnection, objectNameFactoryInterface, clazz, string, bl, bl2, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Object getMBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectNameFactoryInterface objectNameFactoryInterface, Class clazz, String string, boolean bl, boolean bl2, boolean bl3) throws IOException, IllegalArgumentException {
        ObjectName objectName = objectNameFactoryInterface.getObjectName(clazz, string);
        if (bl3 && !mBeanServerConnection.isRegistered(objectName)) {
            throw new IllegalArgumentException("Wrong object name");
        }
        return MBeanServerInvocationHandler.newProxyInstance(mBeanServerConnection, objectName, clazz, bl, bl2);
    }

    private static Set getMBeanObjectNames(MBeanServerConnection mBeanServerConnection, ObjectNameFactoryInterface objectNameFactoryInterface, Class clazz, QueryExp queryExp) throws IOException {
        ObjectName objectName = objectNameFactoryInterface.getObjectNamePattern(clazz);
        return mBeanServerConnection.queryNames(objectName, queryExp);
    }

    public static Set getInstanceNames(MBeanServerConnection mBeanServerConnection, ObjectNameFactoryInterface objectNameFactoryInterface, Class clazz, QueryExp queryExp) throws IOException {
        Set set = JmxClient.getMBeanObjectNames(mBeanServerConnection, objectNameFactoryInterface, clazz, queryExp);
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            treeSet.add(objectNameFactoryInterface.getInstanceName(objectName));
        }
        return treeSet;
    }

    public static Map getAttributeValues(MBeanServerConnection mBeanServerConnection, ObjectNameFactoryInterface objectNameFactoryInterface, Class clazz, String string, String string2, QueryExp queryExp) throws IOException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        Set set = null;
        if (string == null) {
            set = JmxClient.getInstanceNames(mBeanServerConnection, objectNameFactoryInterface, clazz, queryExp);
        } else {
            set = new HashSet<String>();
            set.add(string);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            ObjectName objectName = objectNameFactoryInterface.getObjectName(clazz, string3);
            try {
                treeMap.put(string3, mBeanServerConnection.getAttribute(objectName, string2));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (string == null) continue;
                throw instanceNotFoundException;
            }
        }
        return treeMap;
    }

    public static List getMBeanProxies(MBeanServerConnection mBeanServerConnection, ObjectNameFactoryInterface objectNameFactoryInterface, Class clazz, boolean bl, QueryExp queryExp) throws IOException {
        Set set = JmxClient.getMBeanObjectNames(mBeanServerConnection, objectNameFactoryInterface, clazz, queryExp);
        ArrayList<Object> arrayList = new ArrayList<Object>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            Object object = MBeanServerInvocationHandler.newProxyInstance(mBeanServerConnection, objectName, clazz, false, bl);
            arrayList.add(object);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDaemonCertificateChain(String string, Map hashMap) throws MalformedURLException, CertificateException {
        JMXServiceURL jMXServiceURL = new JMXServiceURL(string);
        NoServerX509TrustManager noServerX509TrustManager = new NoServerX509TrustManager();
        if (hashMap == null) {
            hashMap = new HashMap<String, TrustManager[]>();
        }
        hashMap.put(TRUST_MANAGER_ARRAY_KEY, new TrustManager[]{noServerX509TrustManager});
        JMXConnector jMXConnector = null;
        Throwable throwable = null;
        try {
            jMXConnector = JMXConnectorFactory.newJMXConnector(jMXServiceURL, hashMap);
            jMXConnector.connect();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            if (jMXConnector != null) {
                try {
                    jMXConnector.close();
                }
                catch (Throwable throwable3) {}
            }
        }
        X509Certificate[] x509CertificateArray = noServerX509TrustManager.getRejectedCertificateChain();
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            String[] stringArray = new String[x509CertificateArray.length];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                stringArray[i] = TrustUtils.encodeRFC1421(x509CertificateArray[i]);
            }
            return stringArray;
        }
        CertificateException certificateException = new CertificateException("unable to get the cert chain: " + throwable.getMessage());
        certificateException.initCause(throwable);
        throw certificateException;
    }

    public static String getStringParameter(Map map, String string) {
        return (String)JmxClient.getParameter(map, string);
    }

    public static int getIntParameter(Map map, String string) {
        Object object = JmxClient.getParameter(map, string);
        if (object == null) {
            if (!string.equals(INSECURE_HTML_ADAPTOR_PORT) && !string.equals(INSECURE_JMXMP_CONNECTOR_PORT)) {
                logger.fine("Unable to find parameter for " + string);
            }
            throw new IllegalArgumentException("Invalid configuration map for key : " + string);
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return new Integer((String)object);
        }
        logger.warning("Invalid environment variable type for " + string + " : " + object.getClass());
        throw new IllegalArgumentException("Invalid environment map variable type  for key : " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getParameter(Map object, String string) {
        InputStream inputStream;
        Properties properties;
        Object object2;
        if (globalDefaultMap == null) {
            try {
                object2 = System.getProperty("cacao.properties");
                if (object2 == null) {
                    properties = new Properties();
                    inputStream = null;
                    try {
                        inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(CONTAINER_PROPERTIES_RESOURCE);
                        properties.load(inputStream);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    object2 = properties.getProperty(CACAO_PROPERTIES_FILE);
                }
                properties = new Properties();
                inputStream = null;
                try {
                    inputStream = new FileInputStream((String)object2);
                    properties.load(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        ((FileInputStream)inputStream).close();
                    }
                }
                globalDefaultMap = properties;
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "caught exception", exception);
                throw new IllegalArgumentException("Cannot load default properties file");
            }
        }
        object2 = globalDefaultMap;
        if (object != null && object.containsKey(CACAO_PROPERTIES_FILE)) {
            properties = new Properties();
            try {
                inputStream = null;
                try {
                    inputStream = new FileInputStream((String)object.get(CACAO_PROPERTIES_FILE));
                    properties.load(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        ((FileInputStream)inputStream).close();
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "caught exception", exception);
                throw new IllegalArgumentException("Cannot load properties file specified in map");
            }
            object2 = properties;
        }
        if (object == null) {
            object = object2;
        }
        if ((properties = object.get(string)) == null) {
            properties = object2.get(string);
        }
        return properties;
    }

    static {
        Security.addProvider((java.security.Provider)new Provider());
        globalDefaultMap = null;
    }
}

