/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent;

import com.sun.cacao.agent.DispatchInterceptor;
import com.sun.cacao.agent.JmxClient;
import com.sun.cacao.agent.auth.AccessControlDispatcher;
import com.sun.cacao.agent.auth.AssertMechanism;
import com.sun.cacao.agent.auth.CacaoCallbackHandler;
import com.sun.cacao.agent.auth.Mechanism;
import com.sun.cacao.agent.auth.RoleMechanism;
import com.sun.cacao.agent.auth.RolePrincipal;
import com.sun.cacao.agent.auth.RootAccessController;
import com.sun.cacao.agent.auth.ThreadLocalAuthenticator;
import com.sun.cacao.agent.auth.UserMechanism;
import com.sun.cacao.agent.auth.UserPrincipal;
import com.sun.cacao.agent.trust.CacaoTrustManager;
import com.sun.cacao.common.instrum.InstrumDefaultForwarder;
import com.sun.cacao.common.instrum.InstrumDefaultForwarderMBean;
import com.sun.cacao.container.Container;
import com.sun.jdmk.JdmkMBeanServer;
import com.sun.jdmk.comm.CommunicatorServerMBean;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jdmk.interceptor.MBeanServerInterceptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.IntrospectionException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServerMBean;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.jmxmp.JMXMPConnectorServer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class JmxAgent {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent");
    private static MBeanServer mBeanServer;
    private static JMXMPConnectorServer jmxmpConnectorServer;
    private static JMXMPConnectorServer insecureJmxmpConnectorServer;
    private static HtmlAdaptorServer htmlAdaptor;
    private static MBeanServerInterceptor initialInterceptor;
    private static String password;
    private static KeyStore keyStore;
    private static KeyStore trustStore;
    private static KeyManagerFactory keyMgrFactory;
    private static TrustManager[] trustManagers;
    private static Object keyLock;
    private static Object trustLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMasterPassword() throws Exception {
        Object object = keyLock;
        synchronized (object) {
            if (password == null) {
                password = AssertMechanism.getPassword();
            }
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore() throws Exception {
        Object object = keyLock;
        synchronized (object) {
            if (keyStore == null) {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                String string = "com.sun.cacao.ssl.keystore.file";
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(JmxClient.getStringParameter(null, string));
                    keyStore.load(fileInputStream, JmxAgent.getMasterPassword().toCharArray());
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                JmxAgent.keyStore = keyStore;
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyManagerFactory getKeyManagerFactory() throws Exception {
        Object object = keyLock;
        synchronized (object) {
            if (keyMgrFactory == null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(JmxAgent.getKeyStore(), JmxAgent.getMasterPassword().toCharArray());
                keyMgrFactory = keyManagerFactory;
            }
        }
        return keyMgrFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrustManager[] getTrustManagers() throws Exception {
        Object object = trustLock;
        synchronized (object) {
            if (trustManagers == null) {
                CacaoTrustManager cacaoTrustManager = new CacaoTrustManager();
                cacaoTrustManager.init();
                trustManagers = new TrustManager[]{cacaoTrustManager};
            }
        }
        return trustManagers;
    }

    public static synchronized MBeanServer getMBeanServer() {
        return mBeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer createMBeanServer() throws IntrospectionException {
        Object object;
        Object object2;
        Class[] classArray;
        MBeanServer mBeanServer = null;
        try {
            classArray = Class.forName("java.lang.management.ManagementFactory");
            object2 = classArray.getMethod("getPlatformMBeanServer", null);
            mBeanServer = (MBeanServer)((Method)object2).invoke(null, null);
        }
        catch (Throwable throwable) {
            logger.fine("No platform MBean Server available");
        }
        if (mBeanServer == null && (classArray = MBeanServerFactory.createMBeanServer()) != (mBeanServer = (MBeanServer)(object2 = MBeanServerFactory.findMBeanServer(null)).get(0))) {
            MBeanServerFactory.releaseMBeanServer((MBeanServer)classArray);
        }
        if (!(mBeanServer instanceof JdmkMBeanServer)) {
            throw new IntrospectionException("MBeanServer does not support JdmkMBeanServer");
        }
        classArray = new Class[]{UserPrincipal.class, RolePrincipal.class};
        object2 = new RootAccessController();
        Map map = AccessControlDispatcher.getPrincipalMap();
        for (int i = 0; i < classArray.length; ++i) {
            object = map;
            synchronized (object) {
                LinkedList<Object> linkedList = (LinkedList<Object>)map.get(classArray[i]);
                if (linkedList == null) {
                    linkedList = new LinkedList<Object>();
                    linkedList.addLast(object2);
                    map.put(classArray[i], linkedList);
                } else {
                    linkedList.addLast(object2);
                }
                continue;
            }
        }
        logger.finer("Get the default MBeanInterceptor");
        MBeanServerInterceptor mBeanServerInterceptor = ((JdmkMBeanServer)mBeanServer).getMBeanServerInterceptor();
        logger.finer("Create the DispatchInterceptor");
        object = new DispatchInterceptor(mBeanServer, mBeanServerInterceptor);
        logger.finest("Set DispatchInterceptor as default interceptor");
        ((JdmkMBeanServer)mBeanServer).setMBeanServerInterceptor((MBeanServerInterceptor)object);
        JmxAgent.mBeanServer = mBeanServer;
        initialInterceptor = mBeanServerInterceptor;
        return mBeanServer;
    }

    public static void cleanMBeanServer() throws RuntimeException {
        if (mBeanServer == null) {
            logger.finest("Not need to clean MBeanServer");
            return;
        }
        try {
            ((JdmkMBeanServer)mBeanServer).setMBeanServerInterceptor(initialInterceptor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warning("Initial interceptor is null");
            mBeanServer = null;
            throw illegalArgumentException;
        }
        mBeanServer = null;
    }

    private static void createHTMLAdaptor() throws IOException {
        int n = 0;
        try {
            n = JmxClient.getIntParameter(null, "com.sun.cacao.insecure.html.adaptor.port");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        logger.severe("Opening an insecure html adaptor on port " + n);
        try {
            ObjectName objectName = null;
            objectName = Container.getCacaoObjectNameFactory().getObjectName(CommunicatorServerMBean.class, "html");
            htmlAdaptor = new HtmlAdaptorServer(n);
            JmxAgent.getMBeanServer().registerMBean(htmlAdaptor, objectName);
        }
        catch (Exception exception) {
            logger.warning("unable to register HTML adaptor:" + exception.getMessage());
            logger.log(Level.WARNING, "caught exception", exception);
            htmlAdaptor = null;
        }
    }

    private static void createJMXMPConnector() {
        try {
            Mechanism[] mechanismArray = new Mechanism[]{new UserMechanism(), new RoleMechanism(), new AssertMechanism()};
            for (int i = 0; i < mechanismArray.length; ++i) {
                CacaoCallbackHandler.getMechanisms().put(mechanismArray[i].getName(), mechanismArray[i]);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            SSLContext sSLContext = SSLContext.getInstance("TLSv1");
            Security.addProvider((Provider)new com.sun.jdmk.security.sasl.Provider());
            hashMap.put("jmx.remote.profiles", "TLS SASL/PLAIN");
            hashMap.put("jmx.remote.authenticator", new ThreadLocalAuthenticator());
            sSLContext.init(JmxAgent.getKeyManagerFactory().getKeyManagers(), JmxAgent.getTrustManagers(), null);
            int n = JmxClient.getIntParameter(null, "com.sun.cacao.jmxmp.connector.port");
            hashMap.put("jmx.remote.sasl.callback.handler", new CacaoCallbackHandler());
            hashMap.put("jmx.remote.tls.want.client.authentication", "true");
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            hashMap.put("jmx.remote.tls.socket.factory", sSLSocketFactory);
            JMXServiceURL jMXServiceURL = new JMXServiceURL("service:jmx:jmxmp://localhost:" + n);
            jmxmpConnectorServer = new JMXMPConnectorServer(jMXServiceURL, hashMap, JmxAgent.getMBeanServer());
            ObjectName objectName = Container.getCacaoObjectNameFactory().getObjectName(JMXConnectorServerMBean.class, "jmxmp");
            JmxAgent.getMBeanServer().registerMBean(jmxmpConnectorServer, objectName);
        }
        catch (Exception exception) {
            logger.warning("unable to register JMXMP connector:" + exception.getMessage());
            logger.log(Level.WARNING, "caught exception", exception);
            jmxmpConnectorServer = null;
        }
    }

    private static void createInsecureJMXMPConnector() {
        int n;
        try {
            n = JmxClient.getIntParameter(null, "com.sun.cacao.insecure.jmxmp.connector.port");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        try {
            logger.severe("Opening an insecure JMXMP connector on port " + n);
            HashMap hashMap = new HashMap();
            JMXServiceURL jMXServiceURL = new JMXServiceURL("jmxmp", "localhost", n);
            insecureJmxmpConnectorServer = new JMXMPConnectorServer(jMXServiceURL, hashMap, JmxAgent.getMBeanServer());
            ObjectName objectName = null;
            objectName = Container.getCacaoObjectNameFactory().getObjectName(JMXConnectorServerMBean.class, "jmxmp-insecure");
            JmxAgent.getMBeanServer().registerMBean(insecureJmxmpConnectorServer, objectName);
        }
        catch (Exception exception) {
            logger.warning("unable to register insecure JMXMP connector:" + exception.getMessage());
            logger.log(Level.WARNING, "caught exception", exception);
            insecureJmxmpConnectorServer = null;
        }
    }

    public static final void registerAdaptorsAndConnectors() {
        try {
            JmxAgent.createJMXMPConnector();
            JmxAgent.createInsecureJMXMPConnector();
            JmxAgent.createHTMLAdaptor();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "caught exception", exception);
        }
    }

    public static final boolean startAdaptorsAndConnectors() {
        ObjectName objectName;
        InstrumDefaultForwarder instrumDefaultForwarder;
        boolean bl = false;
        if (htmlAdaptor != null) {
            try {
                htmlAdaptor.start();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "caught exception", exception);
            }
        }
        if (jmxmpConnectorServer != null) {
            instrumDefaultForwarder = new InstrumDefaultForwarder(JmxAgent.getMBeanServer());
            jmxmpConnectorServer.setMBeanServerForwarder((MBeanServerForwarder)instrumDefaultForwarder);
            try {
                objectName = Container.getCacaoObjectNameFactory().getObjectName(InstrumDefaultForwarderMBean.class, "jmxmp");
                JmxAgent.getMBeanServer().registerMBean(instrumDefaultForwarder, objectName);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "caught exception while registering jmxmp forwarder", exception);
            }
            try {
                jmxmpConnectorServer.start();
                bl = true;
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "caught exception", exception);
            }
        }
        if (insecureJmxmpConnectorServer != null) {
            instrumDefaultForwarder = new InstrumDefaultForwarder(JmxAgent.getMBeanServer());
            insecureJmxmpConnectorServer.setMBeanServerForwarder((MBeanServerForwarder)instrumDefaultForwarder);
            try {
                objectName = Container.getCacaoObjectNameFactory().getObjectName(InstrumDefaultForwarderMBean.class, "jmxmp-insecure");
                JmxAgent.getMBeanServer().registerMBean(instrumDefaultForwarder, objectName);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "caught exception while registering jmxmp-insecure forwarder", exception);
            }
            try {
                insecureJmxmpConnectorServer.start();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "caught exception", exception);
            }
        }
        return bl;
    }

    public static final void stopAdaptorsAndConnectors() {
        try {
            ObjectName objectName;
            if (jmxmpConnectorServer != null) {
                objectName = null;
                objectName = Container.getCacaoObjectNameFactory().getObjectName(InstrumDefaultForwarderMBean.class, "jmxmp");
                JmxAgent.getMBeanServer().unregisterMBean(objectName);
                objectName = Container.getCacaoObjectNameFactory().getObjectName(JMXConnectorServerMBean.class, "jmxmp");
                JmxAgent.getMBeanServer().unregisterMBean(objectName);
                jmxmpConnectorServer.stop();
            }
            if (insecureJmxmpConnectorServer != null) {
                objectName = null;
                objectName = Container.getCacaoObjectNameFactory().getObjectName(InstrumDefaultForwarderMBean.class, "jmxmp-insecure");
                JmxAgent.getMBeanServer().unregisterMBean(objectName);
                objectName = Container.getCacaoObjectNameFactory().getObjectName(JMXConnectorServerMBean.class, "jmxmp-insecure");
                JmxAgent.getMBeanServer().unregisterMBean(objectName);
                insecureJmxmpConnectorServer.stop();
            }
            if (htmlAdaptor != null) {
                htmlAdaptor.stop();
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "caught exception", exception);
        }
    }

    static {
        jmxmpConnectorServer = null;
        insecureJmxmpConnectorServer = null;
        htmlAdaptor = null;
        password = null;
        keyStore = null;
        trustStore = null;
        keyMgrFactory = null;
        trustManagers = null;
        keyLock = new Object();
        trustLock = new Object();
    }
}

